/*
 * Decompiled with CFR 0.152.
 */
package ws.osiris.aws;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"BUCKET_NAME_REGEX", "Lkotlin/text/Regex;", "NAME_REGEX", "validateBucketName", "", "bucketName", "validateName", "name", "osiris-aws"})
public final class ConfigKt {
    private static final Regex BUCKET_NAME_REGEX = new Regex("[a-z0-9][a-z0-9-]{1,61}?[a-z0-9]");
    private static final Regex NAME_REGEX = new Regex("[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]");

    @NotNull
    public static final String validateBucketName(@NotNull String bucketName) {
        Intrinsics.checkParameterIsNotNull((Object)bucketName, (String)"bucketName");
        if (!BUCKET_NAME_REGEX.matches((CharSequence)bucketName)) {
            throw (Throwable)new IllegalArgumentException("Illegal bucket name '" + bucketName + "'. Bucket names must only contain " + "lower-case letters, numbers and dashes. They must start and end with a letter or a number. " + "The minimum length is 3 characters and the maximum is 63");
        }
        return bucketName;
    }

    @Nullable
    public static final String validateName(@Nullable String name) {
        if (name != null && !NAME_REGEX.matches((CharSequence)name)) {
            throw (Throwable)new IllegalArgumentException("Illegal name '" + name + "'. Names must only contain lower-case letters, " + "numbers and dashes. They must start and end with a letter or a number.");
        }
        return name;
    }
}

