/*
 * Decompiled with CFR 0.152.
 */
package ws.osiris.aws;

import com.amazonaws.services.lambda.runtime.Context;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import ws.osiris.aws.LambdaKt;
import ws.osiris.aws.ProxyResponse;
import ws.osiris.core.Api;
import ws.osiris.core.ComponentsProvider;
import ws.osiris.core.DataNotFoundException;
import ws.osiris.core.HttpMethod;
import ws.osiris.core.LambdaRoute;
import ws.osiris.core.Request;
import ws.osiris.core.Response;
import ws.osiris.core.Route;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001e\u0010\u0019\u001a\u00020\u001a2\u000e\u0010\u001b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0018\u0010\u001e\u001a\u00020\u001f2\u000e\u0010\u001b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\rH\u0002R\u0010\u0010\u0006\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000RG\u0010\f\u001a;\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u0012%\u0012#\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011j\b\u0012\u0004\u0012\u00028\u0000`\u0014\u00a2\u0006\u0002\b\u00150\rX\u0088\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lws/osiris/aws/ProxyLambda;", "T", "Lws/osiris/core/ComponentsProvider;", "", "api", "Lws/osiris/core/Api;", "components", "(Lws/osiris/core/Api;Lws/osiris/core/ComponentsProvider;)V", "Lws/osiris/core/ComponentsProvider;", "id", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "routeMap", "", "Lkotlin/Pair;", "Lws/osiris/core/HttpMethod;", "", "Lkotlin/Function2;", "Lws/osiris/core/Request;", "Lws/osiris/core/Response;", "Lws/osiris/core/RequestHandler;", "Lkotlin/ExtensionFunctionType;", "encodeBinaryBody", "byteArray", "", "handle", "Lws/osiris/aws/ProxyResponse;", "requestJson", "context", "Lcom/amazonaws/services/lambda/runtime/Context;", "keepAlive", "", "osiris-aws"})
public abstract class ProxyLambda<T extends ComponentsProvider> {
    private final Map<Pair<HttpMethod, String>, Function2<T, Request, Response>> routeMap;
    private final UUID id;
    private final T components;

    @NotNull
    public final ProxyResponse handle(@NotNull Map<?, ?> requestJson, @NotNull Context context) {
        ProxyResponse proxyResponse;
        Intrinsics.checkParameterIsNotNull(requestJson, (String)"requestJson");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        LambdaKt.access$getLog$p().debug("Handling request: {}", requestJson);
        if (this.keepAlive(requestJson)) {
            return new ProxyResponse(0, null, false, null, 15, null);
        }
        Request request = LambdaKt.buildRequest(requestJson, context);
        LambdaKt.access$getLog$p().debug("Request endpoint: {} {}", (Object)request.getMethod(), (Object)request.getPath());
        Function2<T, Request, Response> function2 = this.routeMap.get(new Pair((Object)request.getMethod(), (Object)request.getPath()));
        if (function2 == null) {
            throw (Throwable)new DataNotFoundException(null, 1, null);
        }
        Function2<T, Request, Response> handler = function2;
        LambdaKt.access$getLog$p().debug("Invoking handler");
        Response response = (Response)handler.invoke(this.components, (Object)request);
        LambdaKt.access$getLog$p().debug("Invoked handler");
        Object body = response.getBody();
        if (body == null) {
            proxyResponse = new ProxyResponse(response.getStatus(), response.getHeaders().getHeaderMap(), false, null);
        } else if (body instanceof byte[]) {
            proxyResponse = new ProxyResponse(response.getStatus(), response.getHeaders().getHeaderMap(), true, this.encodeBinaryBody((byte[])body));
        } else if (body instanceof String) {
            proxyResponse = new ProxyResponse(response.getStatus(), response.getHeaders().getHeaderMap(), false, (String)body);
        } else {
            throw (Throwable)new IllegalStateException("Response must contain null, a string or a ByteArray");
        }
        ProxyResponse proxyResponse2 = proxyResponse;
        LambdaKt.access$getLog$p().debug("Returning response");
        return proxyResponse2;
    }

    private final String encodeBinaryBody(byte[] byteArray) {
        byte[] byArray = Base64.getEncoder().encode(byteArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.getEncoder().encode(byteArray)");
        byte[] byArray2 = byArray;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        return new String(byArray2, charset);
    }

    private final boolean keepAlive(Map<?, ?> requestJson) {
        Map<?, ?> map = requestJson;
        Object object = "keepAlive";
        boolean bl = false;
        Map map2 = (Map)map.get(object);
        if (map2 == null) {
            return false;
        }
        Map keepAliveJson = map2;
        object = keepAliveJson;
        String string = "sleepTimeMs";
        boolean bl2 = false;
        Object v = object.get(string);
        if (v == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        int sleepTimeMs = (Integer)v;
        LambdaKt.access$getLog$p().debug("Keep-alive request received. Sleeping for {}ms. Function {}", (Object)sleepTimeMs, (Object)this.id);
        Thread.sleep(sleepTimeMs);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public ProxyLambda(@NotNull Api<T> api, @NotNull T components) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        LambdaRoute lambdaRoute;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Route it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkParameterIsNotNull(api, (String)"api");
        Intrinsics.checkParameterIsNotNull(components, (String)"components");
        this.components = components;
        this.id = UUID.randomUUID();
        LambdaKt.access$getLog$p().debug("Creating ProxyLambda");
        Iterable iterable = api.getRoutes();
        ProxyLambda proxyLambda = this;
        boolean $i$f$filter = false;
        void var5_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Route)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof LambdaRoute)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Object object = (List)destination$iv$iv;
        $this$filter$iv = (Iterable)object;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Route)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Route route = it;
            if (route == null) {
                throw new TypeCastException("null cannot be cast to non-null type ws.osiris.core.LambdaRoute<T>");
            }
            lambdaRoute = (LambdaRoute)route;
            object.add(lambdaRoute);
        }
        object = (List)destination$iv$iv;
        $this$map$iv = (Iterable)object;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            LambdaRoute it2;
            LambdaRoute bl = (LambdaRoute)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl2 = false;
            lambdaRoute = new Pair((Object)it2.getMethod(), (Object)it2.getPath());
            it2 = (LambdaRoute)element$iv$iv;
            boolean bl3 = false;
            Function2 function2 = it2.getHandler();
            object.put(lambdaRoute, function2);
        }
        proxyLambda.routeMap = object = destination$iv$iv2;
        LambdaKt.access$getLog$p().debug("Created routes");
    }
}

