/*
 * Decompiled with CFR 0.152.
 */
package ws.osiris.awsdeploy.cloudformation;

import com.amazonaws.services.apigateway.AmazonApiGateway;
import com.amazonaws.services.apigateway.model.GetRestApisRequest;
import com.amazonaws.services.apigateway.model.GetRestApisResult;
import com.amazonaws.services.apigateway.model.RestApi;
import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.model.CreateStackRequest;
import com.amazonaws.services.cloudformation.model.CreateStackResult;
import com.amazonaws.services.cloudformation.model.DeleteStackRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackResourceRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackResourceResult;
import com.amazonaws.services.cloudformation.model.DescribeStacksRequest;
import com.amazonaws.services.cloudformation.model.DescribeStacksResult;
import com.amazonaws.services.cloudformation.model.ListStacksRequest;
import com.amazonaws.services.cloudformation.model.ListStacksResult;
import com.amazonaws.services.cloudformation.model.Output;
import com.amazonaws.services.cloudformation.model.Stack;
import com.amazonaws.services.cloudformation.model.StackStatus;
import com.amazonaws.services.cloudformation.model.StackSummary;
import com.amazonaws.services.cloudformation.model.UpdateStackRequest;
import com.amazonaws.services.cloudformation.model.UpdateStackResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ws.osiris.awsdeploy.AwsProfile;
import ws.osiris.awsdeploy.cloudformation.DeployResult;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u001a\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0000\u001a\"\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a&\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0001\u001a\"\u0010\u001c\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0018\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0010\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 *\u00020\"\u001a\u0010\u0010#\u001a\b\u0012\u0004\u0012\u00020$0 *\u00020\u0015\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"CAPABILITY_NAMED_IAM", "", "createStatuses", "", "Lcom/amazonaws/services/cloudformation/model/StackStatus;", "deleteStatuses", "deployedStatuses", "failedStatuses", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "successStatuses", "updateStatuses", "apiId", "apiName", "profile", "Lws/osiris/awsdeploy/AwsProfile;", "appName", "envName", "createStack", "cloudFormationClient", "Lcom/amazonaws/services/cloudformation/AmazonCloudFormation;", "templateUrl", "deleteStack", "", "deployStack", "Lws/osiris/awsdeploy/cloudformation/DeployResult;", "stackName", "updateStack", "waitForStack", "stackId", "getAllRestApis", "", "Lcom/amazonaws/services/apigateway/model/RestApi;", "Lcom/amazonaws/services/apigateway/AmazonApiGateway;", "listAllStacks", "Lcom/amazonaws/services/cloudformation/model/StackSummary;", "osiris-aws-deploy"})
@SourceDebugExtension(value={"SMAP\nCloudFormation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudFormation.kt\nws/osiris/awsdeploy/cloudformation/CloudFormationKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,340:1\n766#2:341\n857#2,2:342\n766#2:345\n857#2,2:346\n1#3:344\n*S KotlinDebug\n*F\n+ 1 CloudFormation.kt\nws/osiris/awsdeploy/cloudformation/CloudFormationKt\n*L\n94#1:341\n94#1:342,2\n222#1:345\n222#1:346,2\n*E\n"})
public final class CloudFormationKt {
    private static final Logger log = LoggerFactory.getLogger((String)"ws.osiris.aws.cloudformation");
    @NotNull
    private static final String CAPABILITY_NAMED_IAM = "CAPABILITY_NAMED_IAM";
    @NotNull
    private static final Set<StackStatus> updateStatuses;
    @NotNull
    private static final Set<StackStatus> createStatuses;
    @NotNull
    private static final Set<StackStatus> deleteStatuses;
    @NotNull
    private static final Set<StackStatus> deployedStatuses;
    @NotNull
    private static final Set<StackStatus> successStatuses;
    @NotNull
    private static final Set<StackStatus> failedStatuses;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DeployResult deployStack(@NotNull AwsProfile profile, @NotNull String stackName, @NotNull String apiName, @NotNull String templateUrl) {
        Object v5;
        String keepAliveLambdaArn;
        Stack stack;
        boolean created;
        block15: {
            Object v2;
            Object object2;
            block14: {
                void $this$deployStack_u24lambda_u242;
                DescribeStacksRequest $this$deployStack_u24lambda_u241;
                Object stackId;
                Pair pair;
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
                Intrinsics.checkNotNullParameter((Object)stackName, (String)"stackName");
                Intrinsics.checkNotNullParameter((Object)apiName, (String)"apiName");
                Intrinsics.checkNotNullParameter((Object)templateUrl, (String)"templateUrl");
                log.debug("Deploying stack to region {} using template {}", (Object)profile.getRegion(), (Object)templateUrl);
                List<StackSummary> stackSummaries = CloudFormationKt.listAllStacks(profile.getCloudFormationClient());
                Iterable $this$filter$iv = stackSummaries;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo22 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    StackSummary it = (StackSummary)element$iv$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getStackName(), (Object)stackName) && !Intrinsics.areEqual((Object)it.getStackStatus(), (Object)"DELETE_COMPLETE"))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List liveStacks = (List)destination$iv$iv;
                if (liveStacks.isEmpty()) {
                    String stackId2 = CloudFormationKt.createStack(stackName, profile.getCloudFormationClient(), templateUrl);
                    pair = new Pair((Object)stackId2, (Object)true);
                } else {
                    if (liveStacks.size() > 1) {
                        throw new IllegalStateException("Found multiple stacks named '" + stackName + "': " + liveStacks);
                    }
                    StackSummary stackSummary = (StackSummary)liveStacks.get(0);
                    StackStatus status = StackStatus.fromValue((String)stackSummary.getStackStatus());
                    if (deleteStatuses.contains(status)) {
                        CloudFormationKt.deleteStack(stackName, profile.getCloudFormationClient());
                        stackId = CloudFormationKt.createStack(stackName, profile.getCloudFormationClient(), templateUrl);
                        pair = new Pair(stackId, (Object)true);
                    } else if (updateStatuses.contains(status)) {
                        stackId = CloudFormationKt.updateStack(stackName, templateUrl, profile);
                        pair = new Pair(stackId, (Object)false);
                    } else if (createStatuses.contains(status)) {
                        stackId = CloudFormationKt.createStack(stackName, profile.getCloudFormationClient(), templateUrl);
                        pair = new Pair(stackId, (Object)true);
                    } else {
                        throw new IllegalStateException("Unable to deploy stack '" + stackName + "' with status " + stackSummary.getStackStatus());
                    }
                }
                created = (Boolean)pair.component2();
                DescribeStackResourceRequest $i$f$filterTo22 = stackId = new DescribeStackResourceRequest();
                AmazonCloudFormation amazonCloudFormation = profile.getCloudFormationClient();
                boolean $i$a$-apply-CloudFormationKt$deployStack$apiStackResourceResult$22 = false;
                $this$deployStack_u24lambda_u241.setStackName(stackName);
                $this$deployStack_u24lambda_u241.setLogicalResourceId("ApiStack");
                DescribeStackResourceResult apiStackResourceResult = amazonCloudFormation.describeStackResource(stackId);
                DescribeStacksRequest $i$a$-apply-CloudFormationKt$deployStack$apiStackResourceResult$22 = $this$deployStack_u24lambda_u241 = new DescribeStacksRequest();
                amazonCloudFormation = profile.getCloudFormationClient();
                boolean bl = false;
                $this$deployStack_u24lambda_u242.setStackName(apiStackResourceResult.getStackResourceDetail().getPhysicalResourceId());
                DescribeStacksResult describeResult = amazonCloudFormation.describeStacks($this$deployStack_u24lambda_u241);
                if (describeResult.getStacks().size() != 1) {
                    throw new IllegalStateException("Multiple stacks found: " + describeResult.getStacks());
                }
                stack = (Stack)describeResult.getStacks().get(0);
                List list = stack.getOutputs();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getOutputs(...)");
                Iterable iterable2 = list;
                for (Object object2 : iterable2) {
                    Output it = (Output)object2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getOutputKey(), (Object)"KeepAliveLambdaArn")) continue;
                    v2 = object2;
                    break block14;
                }
                v2 = null;
            }
            Output output = v2;
            keepAliveLambdaArn = output != null ? output.getOutputValue() : null;
            List list = stack.getOutputs();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getOutputs(...)");
            Iterable iterable = list;
            object2 = iterable.iterator();
            while (object2.hasNext()) {
                Object e = object2.next();
                Output it = (Output)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getOutputKey(), (Object)"LambdaVersionArn")) continue;
                v5 = e;
                break block15;
            }
            v5 = null;
        }
        Output output = v5;
        String string = output != null ? output.getOutputValue() : null;
        Intrinsics.checkNotNull((Object)string);
        String lambdaVersionArn = string;
        StackStatus status = StackStatus.fromValue((String)stack.getStackStatus());
        if (!deployedStatuses.contains(status)) {
            throw new IllegalStateException("Stack status is " + stack.getStackStatus());
        }
        return new DeployResult(created, CloudFormationKt.apiId(apiName, profile), lambdaVersionArn, keepAliveLambdaArn);
    }

    @NotNull
    public static final List<StackSummary> listAllStacks(@NotNull AmazonCloudFormation $this$listAllStacks) {
        Intrinsics.checkNotNullParameter((Object)$this$listAllStacks, (String)"<this>");
        return CloudFormationKt.listAllStacks$listAllStacks($this$listAllStacks, null);
    }

    @NotNull
    public static final String apiId(@NotNull String apiName, @NotNull AwsProfile profile) {
        String string;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)apiName, (String)"apiName");
            Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
            Iterable iterable = CloudFormationKt.getAllRestApis(profile.getApiGatewayClient());
            for (Object t : iterable) {
                RestApi it = (RestApi)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)apiName)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        RestApi restApi = v0;
        String string2 = string = restApi != null ? restApi.getId() : null;
        if (string == null) {
            throw new IllegalStateException("No API found with name '" + apiName + "'");
        }
        return string;
    }

    @NotNull
    public static final List<RestApi> getAllRestApis(@NotNull AmazonApiGateway $this$getAllRestApis) {
        Intrinsics.checkNotNullParameter((Object)$this$getAllRestApis, (String)"<this>");
        return CloudFormationKt.getAllRestApis$restApis($this$getAllRestApis, null);
    }

    @NotNull
    public static final String apiName(@NotNull String appName, @Nullable String envName) {
        Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
        String string = envName;
        return string == null ? appName : appName + "." + string;
    }

    /*
     * WARNING - void declaration
     */
    private static final void deleteStack(String apiName, AmazonCloudFormation cloudFormationClient2) {
        void $this$deleteStack_u24lambda_u249;
        void $this$deleteStack_u24lambda_u248;
        DescribeStacksRequest describeStacksRequest;
        log.info("Deleting stack '" + apiName + "'");
        DescribeStacksRequest describeStacksRequest2 = describeStacksRequest = new DescribeStacksRequest();
        AmazonCloudFormation amazonCloudFormation = cloudFormationClient2;
        boolean $i$a$-apply-CloudFormationKt$deleteStack$describeResult$22 = false;
        $this$deleteStack_u24lambda_u248.setStackName(apiName);
        DescribeStacksResult describeResult = amazonCloudFormation.describeStacks(describeStacksRequest);
        String stackId = ((Stack)describeResult.getStacks().get(0)).getStackId();
        DescribeStacksRequest $i$a$-apply-CloudFormationKt$deleteStack$describeResult$22 = describeStacksRequest2 = new DeleteStackRequest();
        amazonCloudFormation = cloudFormationClient2;
        boolean bl = false;
        $this$deleteStack_u24lambda_u249.setStackName(apiName);
        amazonCloudFormation.deleteStack((DeleteStackRequest)describeStacksRequest2);
        Intrinsics.checkNotNull((Object)stackId);
        CloudFormationKt.waitForStack(stackId, cloudFormationClient2);
        log.info("Deleted stack '" + apiName + "'");
    }

    /*
     * WARNING - void declaration
     */
    private static final String updateStack(String appName, String templateUrl, AwsProfile profile) {
        void $this$updateStack_u24lambda_u2410;
        UpdateStackRequest updateStackRequest;
        log.info("Updating stack '{}'", (Object)appName);
        UpdateStackRequest updateStackRequest2 = updateStackRequest = new UpdateStackRequest();
        AmazonCloudFormation amazonCloudFormation = profile.getCloudFormationClient();
        boolean bl = false;
        $this$updateStack_u24lambda_u2410.setStackName(appName);
        $this$updateStack_u24lambda_u2410.setTemplateURL(templateUrl);
        $this$updateStack_u24lambda_u2410.setCapabilities((Collection)CollectionsKt.listOf((Object)CAPABILITY_NAMED_IAM));
        UpdateStackResult updateResult = amazonCloudFormation.updateStack(updateStackRequest);
        String string = updateResult.getStackId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackId(...)");
        CloudFormationKt.waitForStack(string, profile.getCloudFormationClient());
        log.info("Stack updated. ID = " + updateResult.getStackId());
        return updateResult.getStackId();
    }

    /*
     * WARNING - void declaration
     */
    private static final String createStack(String apiName, AmazonCloudFormation cloudFormationClient2, String templateUrl) {
        void $this$createStack_u24lambda_u2411;
        CreateStackRequest createStackRequest;
        log.info("Creating stack '{}'", (Object)apiName);
        CreateStackRequest createStackRequest2 = createStackRequest = new CreateStackRequest();
        AmazonCloudFormation amazonCloudFormation = cloudFormationClient2;
        boolean bl = false;
        $this$createStack_u24lambda_u2411.setStackName(apiName);
        $this$createStack_u24lambda_u2411.setTemplateURL(templateUrl);
        $this$createStack_u24lambda_u2411.setCapabilities((Collection)CollectionsKt.listOf((Object)CAPABILITY_NAMED_IAM));
        CreateStackResult createResult = amazonCloudFormation.createStack(createStackRequest);
        String string = createResult.getStackId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackId(...)");
        CloudFormationKt.waitForStack(string, cloudFormationClient2);
        log.info("Stack created. ID = " + createResult.getStackId());
        return createResult.getStackId();
    }

    private static final void waitForStack(String stackId, AmazonCloudFormation cloudFormationClient2) {
        CloudFormationKt.waitForStack$waitForStack(cloudFormationClient2, stackId, 1);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<StackSummary> listAllStacks$listAllStacks(AmazonCloudFormation $this_listAllStacks, String token) {
        Object object;
        void $this$listAllStacks_u24listAllStacks_u24lambda_u245;
        Object object2;
        ListStacksRequest listStacksRequest = object2 = new ListStacksRequest();
        AmazonCloudFormation amazonCloudFormation = $this_listAllStacks;
        boolean bl = false;
        $this$listAllStacks_u24listAllStacks_u24lambda_u245.setNextToken(token);
        ListStacksResult result = amazonCloudFormation.listStacks(object2);
        if (result.getNextToken() == null) {
            object2 = result.getStackSummaries();
            Intrinsics.checkNotNull((Object)object2);
            object = object2;
        } else {
            List list = result.getStackSummaries();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStackSummaries(...)");
            object = CollectionsKt.plus((Collection)list, (Iterable)CloudFormationKt.listAllStacks$listAllStacks($this_listAllStacks, result.getNextToken()));
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<RestApi> getAllRestApis$restApis(AmazonApiGateway $this_getAllRestApis, String token) {
        Object object;
        void $this$getAllRestApis_u24restApis_u24lambda_u247;
        GetRestApisRequest getRestApisRequest;
        Object object2 = getRestApisRequest = new GetRestApisRequest();
        AmazonApiGateway amazonApiGateway = $this_getAllRestApis;
        boolean bl = false;
        $this$getAllRestApis_u24restApis_u24lambda_u247.setPosition(token);
        GetRestApisResult result = amazonApiGateway.getRestApis(getRestApisRequest);
        List apis = result.getItems();
        if (result.getPosition() == null) {
            object2 = apis;
            Intrinsics.checkNotNull((Object)object2);
            object = object2;
        } else {
            Intrinsics.checkNotNull((Object)apis);
            object = CollectionsKt.plus((Collection)apis, (Iterable)CloudFormationKt.getAllRestApis$restApis($this_getAllRestApis, result.getPosition()));
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final void waitForStack$waitForStack(AmazonCloudFormation $cloudFormationClient, String $stackId, int count) {
        while (true) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = CloudFormationKt.listAllStacks($cloudFormationClient);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                StackSummary it = (StackSummary)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getStackId(), (Object)$stackId)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            StackSummary stackSummary = (StackSummary)((List)destination$iv$iv).get(0);
            StackStatus status = StackStatus.fromValue((String)stackSummary.getStackStatus());
            if (successStatuses.contains(status)) {
                log.debug("Stack status " + status + ", returning");
                return;
            }
            if (failedStatuses.contains(status)) {
                throw new IllegalStateException("Deployment failed, stack status: " + status);
            }
            log.debug("Stack status " + status + ", waiting");
            if (count % 5 == 0) {
                log.info("Waiting for stack to deploy...");
            }
            Thread.sleep(1000L);
            ++count;
        }
    }

    public static final /* synthetic */ Logger access$getLog$p() {
        return log;
    }

    static {
        Object[] objectArray = new StackStatus[]{StackStatus.CREATE_COMPLETE, StackStatus.UPDATE_COMPLETE, StackStatus.UPDATE_COMPLETE_CLEANUP_IN_PROGRESS, StackStatus.UPDATE_ROLLBACK_COMPLETE, StackStatus.UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS};
        updateStatuses = SetsKt.setOf((Object[])objectArray);
        objectArray = new StackStatus[]{StackStatus.CREATE_FAILED, StackStatus.DELETE_COMPLETE};
        createStatuses = SetsKt.setOf((Object[])objectArray);
        deleteStatuses = SetsKt.setOf((Object)StackStatus.ROLLBACK_COMPLETE);
        objectArray = new StackStatus[]{StackStatus.CREATE_COMPLETE, StackStatus.UPDATE_COMPLETE};
        deployedStatuses = SetsKt.setOf((Object[])objectArray);
        objectArray = new StackStatus[]{StackStatus.CREATE_COMPLETE, StackStatus.DELETE_COMPLETE, StackStatus.UPDATE_COMPLETE};
        successStatuses = SetsKt.setOf((Object[])objectArray);
        objectArray = new StackStatus[]{StackStatus.CREATE_FAILED, StackStatus.ROLLBACK_IN_PROGRESS, StackStatus.ROLLBACK_FAILED, StackStatus.DELETE_FAILED, StackStatus.ROLLBACK_COMPLETE, StackStatus.UPDATE_ROLLBACK_IN_PROGRESS, StackStatus.UPDATE_ROLLBACK_FAILED, StackStatus.UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS, StackStatus.UPDATE_ROLLBACK_COMPLETE};
        failedStatuses = SetsKt.setOf((Object[])objectArray);
    }
}

