/*
 * Decompiled with CFR 0.152.
 */
package ws.osiris.awsdeploy.cloudformation;

import com.google.common.hash.Hashing;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ws.osiris.awsdeploy.cloudformation.ApiTemplate;
import ws.osiris.awsdeploy.cloudformation.LambdaMethodTemplate;
import ws.osiris.awsdeploy.cloudformation.MethodTemplate;
import ws.osiris.awsdeploy.cloudformation.ResourceTemplate;
import ws.osiris.awsdeploy.cloudformation.StaticIndexFileMethodTemplate;
import ws.osiris.awsdeploy.cloudformation.StaticRootMethodTemplate;
import ws.osiris.awsdeploy.cloudformation.Template;
import ws.osiris.awsdeploy.cloudformation.TemplatesKt;
import ws.osiris.core.Api;
import ws.osiris.core.Auth;
import ws.osiris.core.FixedRouteNode;
import ws.osiris.core.HttpMethod;
import ws.osiris.core.RouteNode;
import ws.osiris.core.StaticRouteNode;
import ws.osiris.core.VariableRouteNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\b\u0018\u0000 \"2\u00020\u0001:\u0001\"B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0011\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u0012J\t\u0010\u0013\u001a\u00020\u0005H\u00c2\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u00c2\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u00c2\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u00c2\u0003JE\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\fH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006#"}, d2={"Lws/osiris/awsdeploy/cloudformation/ApiTemplate;", "Lws/osiris/awsdeploy/cloudformation/Template;", "rootResource", "Lws/osiris/awsdeploy/cloudformation/ResourceTemplate;", "name", "", "description", "envName", "binaryMimeTypes", "", "(Lws/osiris/awsdeploy/cloudformation/ResourceTemplate;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;)V", "resourceCount", "", "getResourceCount", "()I", "getRootResource$osiris_aws_deploy", "()Lws/osiris/awsdeploy/cloudformation/ResourceTemplate;", "component1", "component1$osiris_aws_deploy", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "toString", "write", "", "writer", "Ljava/io/Writer;", "Companion", "osiris-aws-deploy"})
public final class ApiTemplate
implements Template {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceTemplate rootResource;
    @NotNull
    private final String name;
    @Nullable
    private final String description;
    @Nullable
    private final String envName;
    @NotNull
    private final Set<String> binaryMimeTypes;
    private final int resourceCount;

    public ApiTemplate(@NotNull ResourceTemplate rootResource, @NotNull String name, @Nullable String description, @Nullable String envName, @NotNull Set<String> binaryMimeTypes) {
        Intrinsics.checkNotNullParameter((Object)rootResource, (String)"rootResource");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(binaryMimeTypes, (String)"binaryMimeTypes");
        this.rootResource = rootResource;
        this.name = name;
        this.description = description;
        this.envName = envName;
        this.binaryMimeTypes = binaryMimeTypes;
        this.resourceCount = 1;
    }

    @NotNull
    public final ResourceTemplate getRootResource$osiris_aws_deploy() {
        return this.rootResource;
    }

    @Override
    public int getResourceCount() {
        return this.resourceCount;
    }

    @Override
    public void write(@NotNull Writer writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        String name = this.envName == null ? this.name : this.name + "." + this.envName;
        String binaryTypes2 = CollectionsKt.joinToString$default((Iterable)this.binaryMimeTypes, (CharSequence)",", (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)write.binaryTypes.1.INSTANCE, (int)24, null);
        String string = this.description;
        if (string == null) {
            string = name;
        }
        String template = StringsKt.trimMargin$default((String)("\n        |\n        |  Api:\n        |    Type: AWS::ApiGateway::RestApi\n        |    Properties:\n        |      Name: \"" + name + "\"\n        |      Description: \"" + string + "\"\n        |      FailOnWarnings: true\n        |      BinaryMediaTypes: " + binaryTypes2 + "\n        |        \n        |  CloudWatchRole:\n        |    Type: AWS::IAM::Role\n        |    Properties:\n        |      AssumeRolePolicyDocument:\n        |        Version: 2012-10-17\n        |        Statement:\n        |          - Effect: Allow\n        |            Principal:\n        |              Service:\n        |                - apigateway.amazonaws.com\n        |            Action: sts:AssumeRole\n        |      ManagedPolicyArns:\n        |        - arn:aws:iam::aws:policy/service-role/AmazonAPIGatewayPushToCloudWatchLogs\n        |\n        |  ApiGatewayAccount:\n        |    Type: AWS::ApiGateway::Account\n        |    Properties:\n        |      CloudWatchRoleArn: !GetAtt CloudWatchRole.Arn\n"), null, (int)1, null);
        writer.write(template);
        this.rootResource.write(writer, "!GetAtt Api.RootResourceId", "LambdaVersion.FunctionArn");
    }

    @NotNull
    public final ResourceTemplate component1$osiris_aws_deploy() {
        return this.rootResource;
    }

    private final String component2() {
        return this.name;
    }

    private final String component3() {
        return this.description;
    }

    private final String component4() {
        return this.envName;
    }

    private final Set<String> component5() {
        return this.binaryMimeTypes;
    }

    @NotNull
    public final ApiTemplate copy(@NotNull ResourceTemplate rootResource, @NotNull String name, @Nullable String description, @Nullable String envName, @NotNull Set<String> binaryMimeTypes) {
        Intrinsics.checkNotNullParameter((Object)rootResource, (String)"rootResource");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(binaryMimeTypes, (String)"binaryMimeTypes");
        return new ApiTemplate(rootResource, name, description, envName, binaryMimeTypes);
    }

    public static /* synthetic */ ApiTemplate copy$default(ApiTemplate apiTemplate, ResourceTemplate resourceTemplate, String string, String string2, String string3, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            resourceTemplate = apiTemplate.rootResource;
        }
        if ((n & 2) != 0) {
            string = apiTemplate.name;
        }
        if ((n & 4) != 0) {
            string2 = apiTemplate.description;
        }
        if ((n & 8) != 0) {
            string3 = apiTemplate.envName;
        }
        if ((n & 0x10) != 0) {
            set = apiTemplate.binaryMimeTypes;
        }
        return apiTemplate.copy(resourceTemplate, string, string2, string3, set);
    }

    @NotNull
    public String toString() {
        return "ApiTemplate(rootResource=" + this.rootResource + ", name=" + this.name + ", description=" + this.description + ", envName=" + this.envName + ", binaryMimeTypes=" + this.binaryMimeTypes + ")";
    }

    public int hashCode() {
        int result = this.rootResource.hashCode();
        result = result * 31 + this.name.hashCode();
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.envName == null ? 0 : this.envName.hashCode());
        result = result * 31 + ((Object)this.binaryMimeTypes).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ApiTemplate)) {
            return false;
        }
        ApiTemplate apiTemplate = (ApiTemplate)other;
        if (!Intrinsics.areEqual((Object)this.rootResource, (Object)apiTemplate.rootResource)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)apiTemplate.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.description, (Object)apiTemplate.description)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.envName, (Object)apiTemplate.envName)) {
            return false;
        }
        return Intrinsics.areEqual(this.binaryMimeTypes, apiTemplate.binaryMimeTypes);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\bJ6\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\bH\u0002J>\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000e2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\bH\u0002J*\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000e2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0002J>\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u000e2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bH\u0002J8\u0010\u001c\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\bH\u0002J6\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\bH\u0002J6\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\bH\u0002\u00a8\u0006!"}, d2={"Lws/osiris/awsdeploy/cloudformation/ApiTemplate$Companion;", "", "()V", "create", "Lws/osiris/awsdeploy/cloudformation/ApiTemplate;", "api", "Lws/osiris/core/Api;", "name", "", "description", "envName", "staticFilesBucket", "staticHash", "fixedChildResourceTemplates", "", "Lws/osiris/awsdeploy/cloudformation/ResourceTemplate;", "node", "Lws/osiris/core/RouteNode;", "parentPath", "indexFileMethodTemplates", "Lws/osiris/awsdeploy/cloudformation/MethodTemplate;", "Lws/osiris/core/StaticRouteNode;", "resourceName", "resourceRef", "lambdaMethodTemplates", "Lws/osiris/awsdeploy/cloudformation/LambdaMethodTemplate;", "methodTemplates", "path", "resourceTemplate", "isRoot", "", "staticProxyResourceTemplates", "variableChildResourceTemplates", "osiris-aws-deploy"})
    @SourceDebugExtension(value={"SMAP\nTemplates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Templates.kt\nws/osiris/awsdeploy/cloudformation/ApiTemplate$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,1409:1\n1549#2:1410\n1620#2,3:1411\n125#3:1414\n152#3,3:1415\n*S KotlinDebug\n*F\n+ 1 Templates.kt\nws/osiris/awsdeploy/cloudformation/ApiTemplate$Companion\n*L\n425#1:1410\n425#1:1411,3\n503#1:1414\n503#1:1415,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ApiTemplate create(@NotNull Api<?> api, @NotNull String name, @Nullable String description, @Nullable String envName, @Nullable String staticFilesBucket, @Nullable String staticHash) {
            Intrinsics.checkNotNullParameter(api, (String)"api");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            RouteNode rootNode = RouteNode.Companion.create(api);
            ResourceTemplate rootTemplate = this.resourceTemplate(rootNode, staticFilesBucket, staticHash, true, "");
            return new ApiTemplate(rootTemplate, name, description, envName, api.getBinaryMimeTypes());
        }

        private final ResourceTemplate resourceTemplate(RouteNode<?> node, String staticFilesBucket, String staticHash, boolean isRoot, String parentPath) {
            Object pathPart = node instanceof VariableRouteNode ? "{" + node.getName() + "}" : node.getName();
            String path = parentPath + "/" + (String)pathPart;
            String resourceName = this.resourceName(path);
            Object resourceRef = isRoot ? "!GetAtt Api.RootResourceId" : "!Ref " + resourceName;
            List<MethodTemplate> methods = this.methodTemplates(node, resourceName, (String)resourceRef, staticFilesBucket, staticHash);
            List<ResourceTemplate> fixedChildTemplates = this.fixedChildResourceTemplates(node, staticFilesBucket, staticHash, path);
            List<ResourceTemplate> staticProxyTemplates = this.staticProxyResourceTemplates(node, staticFilesBucket, staticHash, path);
            List<ResourceTemplate> variableChildTemplates = this.variableChildResourceTemplates(node, staticFilesBucket, staticHash, path);
            List childResourceTemplates = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)fixedChildTemplates, (Iterable)variableChildTemplates), (Iterable)staticProxyTemplates);
            return new ResourceTemplate(methods, childResourceTemplates, (String)pathPart, resourceName, isRoot);
        }

        /*
         * WARNING - void declaration
         */
        private final List<ResourceTemplate> fixedChildResourceTemplates(RouteNode<?> node, String staticFilesBucket, String staticHash, String parentPath) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = node.getFixedChildren().values();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RouteNode routeNode = (RouteNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.resourceTemplate((RouteNode<?>)it, staticFilesBucket, staticHash, false, parentPath));
            }
            return (List)destination$iv$iv;
        }

        private final List<ResourceTemplate> variableChildResourceTemplates(RouteNode<?> node, String staticFilesBucket, String staticHash, String parentPath) {
            VariableRouteNode variableChild = node.getVariableChild();
            return variableChild == null ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)this.resourceTemplate((RouteNode)variableChild, staticFilesBucket, staticHash, false, parentPath));
        }

        private final List<ResourceTemplate> staticProxyResourceTemplates(RouteNode<?> node, String staticFilesBucket, String staticHash, String parentPath) {
            List list;
            if (node instanceof StaticRouteNode) {
                if (staticFilesBucket == null) {
                    throw new IllegalStateException("Index file specified with no static files bucket");
                }
                TemplatesKt.access$getLog$p().debug("Creating static root template with hash {}, bucket {}", (Object)staticHash, (Object)staticFilesBucket);
                String pathPart = "{proxy+}";
                String path = parentPath + "/" + pathPart;
                String proxyChildName = this.resourceName(path);
                String proxyChildRef = "!Ref " + proxyChildName;
                StaticRootMethodTemplate proxyChildMethodTemplate = new StaticRootMethodTemplate(proxyChildName, proxyChildRef, ((StaticRouteNode)node).getAuth(), staticFilesBucket, staticHash);
                List proxyChildren = CollectionsKt.listOf((Object)proxyChildMethodTemplate);
                list = CollectionsKt.listOf((Object)new ResourceTemplate(proxyChildren, CollectionsKt.emptyList(), pathPart, proxyChildName, false));
            } else {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        private final List<MethodTemplate> methodTemplates(RouteNode<?> node, String resourceName, String resourceRef, String staticFilesBucket, String staticHash) {
            List<MethodTemplate> list;
            RouteNode<?> routeNode = node;
            if (routeNode instanceof FixedRouteNode) {
                list = this.lambdaMethodTemplates(node, resourceName, resourceRef);
            } else if (routeNode instanceof VariableRouteNode) {
                list = this.lambdaMethodTemplates(node, resourceName, resourceRef);
            } else if (routeNode instanceof StaticRouteNode) {
                list = this.indexFileMethodTemplates((StaticRouteNode)node, resourceName, resourceRef, staticFilesBucket, staticHash);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return list;
        }

        /*
         * WARNING - void declaration
         */
        private final List<LambdaMethodTemplate> lambdaMethodTemplates(RouteNode<?> node, String resourceName, String resourceRef) {
            void $this$mapTo$iv$iv;
            Map $this$map$iv = node.getHandlers();
            boolean $i$f$map = false;
            Map map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                HttpMethod httpMethod = (HttpMethod)entry.getKey();
                Pair pair = (Pair)entry.getValue();
                collection.add(new LambdaMethodTemplate(resourceName, resourceRef, httpMethod, (Auth)pair.getSecond()));
            }
            return (List)destination$iv$iv;
        }

        private final List<MethodTemplate> indexFileMethodTemplates(StaticRouteNode<?> node, String resourceName, String resourceRef, String staticFilesBucket, String staticHash) {
            List list;
            TemplatesKt.access$getLog$p().debug("Creating static index file template with hash {}, bucket {}", (Object)staticHash, (Object)staticFilesBucket);
            String indexFile = node.getIndexFile();
            if (indexFile == null) {
                list = CollectionsKt.emptyList();
            } else {
                if (staticFilesBucket == null) {
                    throw new IllegalStateException("Index file specified with no static files bucket");
                }
                list = CollectionsKt.listOf((Object)new StaticIndexFileMethodTemplate(resourceName, resourceRef, node.getAuth(), staticFilesBucket, staticHash, indexFile));
            }
            return list;
        }

        private final String resourceName(String path) {
            long hash = Hashing.farmHashFingerprint64().hashString((CharSequence)path, Charsets.UTF_8).asLong();
            String id = Long.toHexString(hash);
            return "Resource" + id;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

