/*
 * Decompiled with CFR 0.152.
 */
package ws.osiris.awsdeploy;

import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.InvokeRequest;
import com.google.gson.Gson;
import java.awt.Desktop;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ws.osiris.aws.ApiFactory;
import ws.osiris.aws.ApplicationConfig;
import ws.osiris.awsdeploy.AwsProfile;
import ws.osiris.awsdeploy.DeployException;
import ws.osiris.awsdeploy.DeployKt;
import ws.osiris.awsdeploy.DeployableProject;
import ws.osiris.awsdeploy.DeployableProjectKt;
import ws.osiris.awsdeploy.StaticFilesInfo;
import ws.osiris.awsdeploy.cloudformation.CloudFormationFile;
import ws.osiris.awsdeploy.cloudformation.CloudFormationKt;
import ws.osiris.awsdeploy.cloudformation.DeployResult;
import ws.osiris.awsdeploy.cloudformation.Templates;
import ws.osiris.core.Api;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001:\u0001RJ\u0014\u0010(\u001a\u0006\u0012\u0002\b\u00030)2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\bH\u0002J\u0014\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000300H\u0016J\b\u00101\u001a\u00020-H\u0016J\u001e\u00102\u001a\b\u0012\u0004\u0012\u00020\u0003032\u0006\u00104\u001a\u00020\b2\u0006\u00105\u001a\u00020\u0003H\u0002J\u001c\u00106\u001a\u00020\u00032\u0012\u00107\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b08\"\u00020\bH\u0002J\u0018\u00109\u001a\u00020-2\u0006\u0010:\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u0003H\u0016J\b\u0010<\u001a\u00020=H\u0002J(\u0010>\u001a\u00020-2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\u0006\u0010<\u001a\u00020=H\u0002J \u0010E\u001a\u0004\u0018\u00010F2\n\u0010G\u001a\u0006\u0012\u0002\b\u00030H2\b\u0010 \u001a\u0004\u0018\u00010\u0003H\u0002J \u0010I\u001a\u00020\u00032\u0006\u0010J\u001a\u00020\u00032\u0006\u0010K\u001a\u00020\u00032\u0006\u0010L\u001a\u00020\u0003H\u0002J.\u0010M\u001a\u00020-2\u0006\u0010<\u001a\u00020=2\n\u0010G\u001a\u0006\u0012\u0002\b\u00030H2\u0006\u0010N\u001a\u00020\u00032\b\u0010 \u001a\u0004\u0018\u00010\u0003H\u0002J\u0018\u0010O\u001a\u00020-2\u0006\u0010<\u001a\u00020=2\u0006\u0010K\u001a\u00020\u0003H\u0002J\u0010\u0010P\u001a\u00020Q2\u0006\u00105\u001a\u00020\u0003H\u0002R\u000b\u0010\u0002\u001a\u00020\u00038BX\u0082\u0004R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000b\u0010\u000b\u001a\u00020\b8BX\u0082\u0004R\u000b\u0010\f\u001a\u00020\b8BX\u0082\u0004R\u0014\u0010\r\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u000b\u0010\u000f\u001a\u00020\u00038BX\u0082\u0004R\u000b\u0010\u0010\u001a\u00020\u00038BX\u0082\u0004R\u0012\u0010\u0011\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0006R\u0012\u0010\u0013\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\nR\u0012\u0010\u0015\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0006R\u000b\u0010\u0017\u001a\u00020\b8BX\u0082\u0004R\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0012\u0010\u001c\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\nR\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0006R\u0014\u0010 \u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0006R\u0014\u0010\"\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0006R\u0012\u0010$\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\nR\u000b\u0010&\u001a\u00020\b8BX\u0082\u0004R\u000b\u0010'\u001a\u00020\u00038BX\u0082\u0004\u00a8\u0006S"}, d2={"Lws/osiris/awsdeploy/DeployableProject;", "", "apiFactoryClassName", "", "awsProfile", "getAwsProfile", "()Ljava/lang/String;", "buildDir", "Ljava/nio/file/Path;", "getBuildDir", "()Ljava/nio/file/Path;", "cloudFormationGeneratedDir", "cloudFormationSourceDir", "environmentName", "getEnvironmentName", "generatedCorePackage", "lambdaClassName", "name", "getName", "projectJar", "getProjectJar", "rootPackage", "getRootPackage", "rootTemplate", "runtimeClasspath", "", "getRuntimeClasspath", "()Ljava/util/List;", "sourceDir", "getSourceDir", "stackName", "getStackName", "staticFilesDirectory", "getStaticFilesDirectory", "version", "getVersion", "zipBuildDir", "getZipBuildDir", "zipFile", "zipName", "createApiFactory", "Lws/osiris/aws/ApiFactory;", "parentClassLoader", "Ljava/lang/ClassLoader;", "deleteContents", "", "dir", "deploy", "", "generateCloudFormation", "generatedTemplateParameters", "", "rootTemplatePath", "apiName", "md5Hash", "files", "", "openBrowser", "stage", "path", "profile", "Lws/osiris/awsdeploy/AwsProfile;", "sendKeepAlive", "deployResult", "Lws/osiris/awsdeploy/cloudformation/DeployResult;", "instanceCount", "", "sleepTimeMs", "Ljava/time/Duration;", "staticFilesInfo", "Lws/osiris/awsdeploy/StaticFilesInfo;", "api", "Lws/osiris/core/Api;", "templateUrl", "templateName", "codeBucket", "region", "uploadStaticFiles", "bucket", "uploadTemplates", "zipS3Key", "Lws/osiris/awsdeploy/DeployableProject$ZipKey;", "ZipKey", "osiris-aws-deploy"})
public interface DeployableProject {
    @NotNull
    public String getName();

    @Nullable
    public String getVersion();

    @NotNull
    public Path getBuildDir();

    @NotNull
    public Path getZipBuildDir();

    @NotNull
    public Path getSourceDir();

    @NotNull
    public String getRootPackage();

    @Nullable
    public String getEnvironmentName();

    @Nullable
    public String getStaticFilesDirectory();

    @Nullable
    public String getAwsProfile();

    @Nullable
    public String getStackName();

    @NotNull
    public List<Path> getRuntimeClasspath();

    @NotNull
    public Path getProjectJar();

    @NotNull
    public ApiFactory<?> createApiFactory(@NotNull ClassLoader var1);

    public void generateCloudFormation();

    @NotNull
    public Map<String, String> deploy();

    public void openBrowser(@NotNull String var1, @NotNull String var2);

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nDeployableProject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeployableProject.kt\nws/osiris/awsdeploy/DeployableProject$DefaultImpls\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,337:1\n1549#2:338\n1620#2,3:339\n1271#2,2:345\n1285#2,4:347\n37#3,2:342\n37#3,2:351\n1#4:344\n*S KotlinDebug\n*F\n+ 1 DeployableProject.kt\nws/osiris/awsdeploy/DeployableProject$DefaultImpls\n*L\n109#1:338\n109#1:339,3\n249#1:345,2\n249#1:347,4\n110#1:342,2\n296#1:351,2\n*E\n"})
    public static final class DefaultImpls {
        private static Path getCloudFormationSourceDir(DeployableProject $this) {
            Path path = $this.getSourceDir().resolve("cloudformation");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            return path;
        }

        private static Path getRootTemplate(DeployableProject $this) {
            Path path = DefaultImpls.getCloudFormationSourceDir($this).resolve("root.template");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            return path;
        }

        private static String getGeneratedCorePackage(DeployableProject $this) {
            return $this.getRootPackage() + ".core.generated";
        }

        private static String getLambdaClassName(DeployableProject $this) {
            return DefaultImpls.getGeneratedCorePackage($this) + ".GeneratedLambda";
        }

        private static Path getCloudFormationGeneratedDir(DeployableProject $this) {
            Path path = $this.getBuildDir().resolve("cloudformation");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            return path;
        }

        private static String getApiFactoryClassName(DeployableProject $this) {
            return DefaultImpls.getGeneratedCorePackage($this) + ".GeneratedApiFactory";
        }

        private static Path getZipFile(DeployableProject $this) {
            Path path = $this.getZipBuildDir().resolve(DefaultImpls.getZipName($this));
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            return path;
        }

        private static String getZipName(DeployableProject $this) {
            return $this.getVersion() == null ? $this.getName() + "-dist.zip" : $this.getName() + "-" + $this.getVersion() + "-dist.zip";
        }

        /*
         * WARNING - void declaration
         */
        private static AwsProfile profile(DeployableProject $this) {
            AwsProfile awsProfile;
            String awsProfile2 = $this.getAwsProfile();
            if (awsProfile2 == null) {
                AwsProfile profile = AwsProfile.Companion.default();
                DeployableProjectKt.access$getLog$p().info("Using default AWS profile, region = {}", (Object)profile.getRegion());
                awsProfile = profile;
            } else {
                void var2_3;
                AwsProfile profile = AwsProfile.Companion.named(awsProfile2);
                DeployableProjectKt.access$getLog$p().info("Using AWS profile named '{}', region = {}", (Object)awsProfile2, (Object)profile.getRegion());
                awsProfile = var2_3;
            }
            return awsProfile;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static ApiFactory<?> createApiFactory(@NotNull DeployableProject $this, @NotNull ClassLoader parentClassLoader) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)parentClassLoader, (String)"parentClassLoader");
            DeployableProjectKt.access$getLog$p().debug("runtime classpath: {}", $this.getRuntimeClasspath());
            DeployableProjectKt.access$getLog$p().debug("project jar: {}", (Object)$this.getProjectJar());
            Iterable $this$map$iv = $this.getRuntimeClasspath();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Path path = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toUri().toURL());
            }
            List classpathJars = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)$this.getProjectJar().toUri().toURL());
            Collection $this$toTypedArray$iv = classpathJars;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            URLClassLoader classLoader = new URLClassLoader(thisCollection$iv.toArray(new URL[0]), parentClassLoader);
            Class<?> apiFactoryClass = Class.forName(DefaultImpls.getApiFactoryClassName($this), true, classLoader);
            Object obj = apiFactoryClass.newInstance();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type ws.osiris.aws.ApiFactory<*>");
            return (ApiFactory)obj;
        }

        public static void generateCloudFormation(@NotNull DeployableProject $this) {
            ClassLoader classLoader = $this.getClass().getClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
            ApiFactory<?> apiFactory = $this.createApiFactory(classLoader);
            Api api = apiFactory.getApi();
            ApplicationConfig appConfig = apiFactory.getConfig();
            String appName = appConfig.getApplicationName();
            AwsProfile profile = DefaultImpls.profile($this);
            String string = appConfig.getCodeBucket();
            if (string == null) {
                string = DeployKt.codeBucketName(appName, $this.getEnvironmentName(), profile.getAccountId());
            }
            String codeBucket = string;
            ZipKey zipKey = DefaultImpls.zipS3Key($this, appName);
            String codeHash = zipKey.component1();
            String jarKey = zipKey.component2();
            Set<String> templateParams = DefaultImpls.generatedTemplateParameters($this, DefaultImpls.getRootTemplate($this), appName);
            StaticFilesInfo staticFilesInfo2 = DefaultImpls.staticFilesInfo($this, api, $this.getStaticFilesDirectory());
            String staticHash = staticFilesInfo2 != null ? staticFilesInfo2.getHash() : null;
            DefaultImpls.deleteContents($this, DefaultImpls.getCloudFormationGeneratedDir($this));
            Files.createDirectories(DefaultImpls.getCloudFormationGeneratedDir($this), new FileAttribute[0]);
            Templates templates = Templates.Companion.create(api, appConfig, templateParams, DefaultImpls.getLambdaClassName($this), codeHash, staticHash, codeBucket, jarKey, $this.getEnvironmentName(), profile.getAccountId());
            for (CloudFormationFile file : templates.getFiles$osiris_aws_deploy()) {
                file.write(DefaultImpls.getCloudFormationGeneratedDir($this));
            }
            if (!Files.exists(DefaultImpls.getCloudFormationSourceDir($this), new LinkOption[0])) {
                return;
            }
            Files.list(DefaultImpls.getCloudFormationSourceDir($this)).filter(arg_0 -> DefaultImpls.generateCloudFormation$lambda$1(generateCloudFormation.1.INSTANCE, arg_0)).forEach(arg_0 -> DefaultImpls.generateCloudFormation$lambda$2((Function1)new Function1<Path, Unit>(codeBucket, jarKey, $this){
                final /* synthetic */ String $codeBucket;
                final /* synthetic */ String $jarKey;
                final /* synthetic */ DeployableProject this$0;
                {
                    this.$codeBucket = $codeBucket;
                    this.$jarKey = $jarKey;
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(Path file) {
                    String string;
                    Closeable closeable = new BufferedReader(new FileReader(file.toFile()));
                    Throwable throwable = null;
                    try {
                        BufferedReader it = (BufferedReader)closeable;
                        boolean bl = false;
                        string = TextStreamsKt.readText((Reader)it);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    String templateText = string;
                    String string2 = StringsKt.replace$default((String)StringsKt.replace$default((String)templateText, (String)"${codeS3Bucket}", (String)this.$codeBucket, (boolean)false, (int)4, null), (String)"${codeS3Key}", (String)this.$jarKey, (boolean)false, (int)4, null);
                    String string3 = this.this$0.getEnvironmentName();
                    if (string3 == null) {
                        string3 = "null";
                    }
                    String generatedFile = StringsKt.replace$default((String)string2, (String)"${environmentName}", (String)string3, (boolean)false, (int)4, null);
                    Path generatedFilePath = DefaultImpls.access$getCloudFormationGeneratedDir(this.this$0).resolve(file.getFileName());
                    DeployableProjectKt.access$getLog$p().debug("Copying template from " + file.toAbsolutePath() + " to " + generatedFilePath.toAbsolutePath());
                    byte[] byArray = generatedFile.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    Files.write(generatedFilePath, byArray, new OpenOption[0]);
                }
            }, arg_0));
        }

        private static void deleteContents(DeployableProject $this, Path dir) {
            if (!Files.exists(dir, new LinkOption[0])) {
                return;
            }
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @NotNull
                public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @NotNull
                public FileVisitResult postVisitDirectory(@NotNull Path dir, @Nullable IOException exc) {
                    Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }

        private static ZipKey zipS3Key(DeployableProject $this, String apiName) {
            Path zipPath = $this.getZipBuildDir().resolve(DefaultImpls.getZipName($this));
            Path[] pathArray = new Path[1];
            Intrinsics.checkNotNull((Object)zipPath);
            pathArray[0] = zipPath;
            String md5Hash2 = DefaultImpls.md5Hash($this, pathArray);
            return new ZipKey(md5Hash2, apiName + "." + md5Hash2 + ".jar");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static String md5Hash(DeployableProject $this, Path ... files) {
            MessageDigest messageDigest = MessageDigest.getInstance("md5");
            byte[] buffer = new byte[0x100000];
            for (Path file : files) {
                InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                Closeable closeable = inputStream;
                int n = 0x100000;
                closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
                Throwable throwable = null;
                try {
                    BufferedInputStream it = (BufferedInputStream)closeable;
                    boolean bl = false;
                    DefaultImpls.md5Hash$readChunk(buffer, messageDigest, it);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            byte[] digest = messageDigest.digest();
            Intrinsics.checkNotNull((Object)digest);
            return ArraysKt.joinToString$default((byte[])digest, (CharSequence)"", null, null, (int)0, null, (Function1)md5Hash.2.INSTANCE, (int)30, null);
        }

        private static String templateUrl(DeployableProject $this, String templateName, String codeBucket, String region) {
            return "https://" + codeBucket + ".s3." + region + ".amazonaws.com/" + templateName;
        }

        private static Set<String> generatedTemplateParameters(DeployableProject $this, Path rootTemplatePath, String apiName) {
            byte[] templateBytes = Files.readAllBytes(rootTemplatePath);
            Intrinsics.checkNotNull((Object)templateBytes);
            String templateYaml = new String(templateBytes, Charsets.UTF_8);
            return DeployKt.generatedTemplateParameters(templateYaml, apiName);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static Map<String, String> deploy(@NotNull DeployableProject $this) {
            Object object;
            if (!Files.exists(DefaultImpls.getZipFile($this), new LinkOption[0])) {
                throw new DeployException("Cannot find " + DefaultImpls.getZipName($this));
            }
            ClassLoader classLoader = $this.getClass().getClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
            ApiFactory<?> apiFactory = $this.createApiFactory(classLoader);
            ApplicationConfig appConfig = apiFactory.getConfig();
            Api api = apiFactory.getApi();
            String appName = appConfig.getApplicationName();
            AwsProfile profile = DefaultImpls.profile($this);
            String string = appConfig.getCodeBucket();
            if (string == null) {
                string = DeployKt.createBucket(profile, DeployKt.codeBucketName(appName, $this.getEnvironmentName(), profile.getAccountId()));
            }
            String codeBucket = string;
            String jarKey = DefaultImpls.zipS3Key($this, appName).component2();
            DeployableProjectKt.access$getLog$p().info("Uploading function code '" + DefaultImpls.getZipFile($this) + "' to " + codeBucket + " with key " + jarKey);
            DeployKt.uploadFile(profile, DefaultImpls.getZipFile($this), codeBucket, jarKey);
            DeployableProjectKt.access$getLog$p().info("Upload of function code complete");
            DefaultImpls.uploadTemplates($this, profile, codeBucket);
            if (!Files.exists(DefaultImpls.getRootTemplate($this), new LinkOption[0])) {
                throw new IllegalStateException("core/src/main/cloudformation/root.template is missing");
            }
            String deploymentTemplateUrl = DefaultImpls.templateUrl($this, ((Object)DefaultImpls.getRootTemplate($this).getFileName()).toString(), codeBucket, profile.getRegion());
            String apiName = CloudFormationKt.apiName(appConfig.getApplicationName(), $this.getEnvironmentName());
            String localStackName = $this.getStackName();
            if (localStackName == null) {
                String stackEnvSuffix = $this.getEnvironmentName() == null ? "" : "-" + $this.getEnvironmentName();
                object = appConfig.getApplicationName() + stackEnvSuffix;
            } else {
                object = localStackName;
            }
            String stackName = object;
            DeployResult deployResult = CloudFormationKt.deployStack(profile, stackName, apiName, deploymentTemplateUrl);
            String string2 = appConfig.getStaticFilesBucket();
            if (string2 == null) {
                string2 = DeployKt.staticFilesBucketName(appName, $this.getEnvironmentName(), profile.getAccountId());
            }
            String staticBucket = string2;
            DefaultImpls.uploadStaticFiles($this, profile, api, staticBucket, $this.getStaticFilesDirectory());
            String apiId = deployResult.getApiId();
            boolean stackCreated = deployResult.getStackCreated();
            List<String> deployedStages = DeployKt.deployStages(profile, apiId, apiName, appConfig.getStages(), stackCreated);
            Iterable $this$associateWith$iv = deployedStages;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                String string3 = (String)element$iv$iv;
                Object t = element$iv$iv;
                Map map = result$iv;
                boolean bl = false;
                String string4 = DeployableProjectKt.stageUrl(apiId, (String)it, profile.getRegion());
                map.put(t, string4);
            }
            Map stageUrls = result$iv;
            for (Map.Entry entry : stageUrls.entrySet()) {
                String stage = (String)entry.getKey();
                String url = (String)entry.getValue();
                DeployableProjectKt.access$getLog$p().info("Deployed to stage '" + stage + "' at " + url);
            }
            DefaultImpls.sendKeepAlive($this, deployResult, appConfig.getKeepAliveCount(), appConfig.getKeepAliveSleep(), profile);
            return stageUrls;
        }

        public static void openBrowser(@NotNull DeployableProject $this, @NotNull String stage, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                ClassLoader classLoader = $this.getClass().getClassLoader();
                Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
                ApiFactory<?> apiFactory = $this.createApiFactory(classLoader);
                String apiName = CloudFormationKt.apiName(apiFactory.getConfig().getApplicationName(), $this.getEnvironmentName());
                String urlBase = DeployableProjectKt.stageUrl(apiName, stage, DefaultImpls.profile($this));
                String url = urlBase + StringsKt.removePrefix((String)path, (CharSequence)"/");
                Object[] objectArray = new Object[]{path, stage, apiName, url};
                DeployableProjectKt.access$getLog$p().debug("Opening path {} of stage {} of API {} in the default browser: {}", objectArray);
                Desktop.getDesktop().browse(new URI(url));
            } else {
                DeployableProjectKt.access$getLog$p().warn("Opening a browser is not supported");
            }
        }

        private static void uploadStaticFiles(DeployableProject $this, AwsProfile profile, Api<?> api, String bucket, String staticFilesDirectory) {
            Object object;
            StaticFilesInfo staticFilesInfo2;
            block6: {
                block5: {
                    StaticFilesInfo staticFilesInfo3 = DefaultImpls.staticFilesInfo($this, api, staticFilesDirectory);
                    if (staticFilesInfo3 == null) {
                        return;
                    }
                    staticFilesInfo2 = staticFilesInfo3;
                    object = staticFilesDirectory;
                    if (object == null) break block5;
                    String it = object;
                    boolean bl = false;
                    Path path = Paths.get(it, new String[0]);
                    object = path;
                    if (path != null) break block6;
                }
                object = $this.getSourceDir().resolve("static");
            }
            Object staticFilesDir = object;
            for (Path file : staticFilesInfo2.getFiles()) {
                Intrinsics.checkNotNull((Object)staticFilesDir);
                DeployKt.uploadFile$default(profile, file, bucket, (Path)staticFilesDir, null, staticFilesInfo2.getHash(), 16, null);
            }
        }

        private static void uploadTemplates(DeployableProject $this, AwsProfile profile, String codeBucket) {
            if (!Files.exists(DefaultImpls.getCloudFormationGeneratedDir($this), new LinkOption[0])) {
                return;
            }
            Files.list(DefaultImpls.getCloudFormationGeneratedDir($this)).filter(arg_0 -> DefaultImpls.uploadTemplates$lambda$6(uploadTemplates.1.INSTANCE, arg_0)).forEach(arg_0 -> DefaultImpls.uploadTemplates$lambda$7((Function1)new Function1<Path, Unit>(profile, codeBucket){
                final /* synthetic */ AwsProfile $profile;
                final /* synthetic */ String $codeBucket;
                {
                    this.$profile = $profile;
                    this.$codeBucket = $codeBucket;
                    super(1);
                }

                public final void invoke(Path it) {
                    Intrinsics.checkNotNull((Object)it);
                    DeployKt.uploadFile$default(this.$profile, it, this.$codeBucket, null, 8, null);
                }
            }, arg_0));
        }

        private static StaticFilesInfo staticFilesInfo(DeployableProject $this, Api<?> api, String staticFilesDirectory) {
            Object object;
            block5: {
                block4: {
                    if (!api.getStaticFiles()) {
                        return null;
                    }
                    object = staticFilesDirectory;
                    if (object == null) break block4;
                    String it = object;
                    boolean bl = false;
                    Path path = Paths.get(it, new String[0]);
                    object = path;
                    if (path != null) break block5;
                }
                object = $this.getSourceDir().resolve("static");
            }
            Object staticFilesDir = object;
            List staticFiles2 = Files.walk((Path)staticFilesDir, Integer.MAX_VALUE, new FileVisitOption[0]).filter(arg_0 -> DefaultImpls.staticFilesInfo$lambda$9(staticFilesInfo.staticFiles.1.INSTANCE, arg_0)).collect(Collectors.toList());
            Intrinsics.checkNotNull(staticFiles2);
            Collection $this$toTypedArray$iv = staticFiles2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Path[] pathArray = thisCollection$iv.toArray(new Path[0]);
            String hash = DefaultImpls.md5Hash($this, Arrays.copyOf(pathArray, pathArray.length));
            return new StaticFilesInfo(staticFiles2, hash);
        }

        /*
         * WARNING - void declaration
         */
        private static void sendKeepAlive(DeployableProject $this, DeployResult deployResult, int instanceCount, Duration sleepTimeMs, AwsProfile profile) {
            void $this$sendKeepAlive_u24lambda_u2410;
            InvokeRequest invokeRequest;
            if (deployResult.getKeepAliveLambdaArn() == null) {
                return;
            }
            DeployableProjectKt.access$getLog$p().info("Invoking keep-alive lambda {}", (Object)deployResult.getKeepAliveLambdaArn());
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"functionArn", (Object)deployResult.getLambdaVersionArn()), TuplesKt.to((Object)"instanceCount", (Object)instanceCount), TuplesKt.to((Object)"sleepTimeMs", (Object)sleepTimeMs.toMillis())};
            Map payloadMap = MapsKt.mapOf((Pair[])pairArray);
            DeployableProjectKt.access$getLog$p().debug("Keep-alive payload: {}", (Object)payloadMap);
            String payloadJson = new Gson().toJson((Object)payloadMap);
            InvokeRequest invokeRequest2 = invokeRequest = new InvokeRequest();
            AWSLambda aWSLambda = profile.getLambdaClient();
            boolean bl = false;
            $this$sendKeepAlive_u24lambda_u2410.setFunctionName(deployResult.getKeepAliveLambdaArn());
            $this$sendKeepAlive_u24lambda_u2410.setInvocationType("Event");
            Intrinsics.checkNotNull((Object)payloadJson);
            byte[] byArray = payloadJson.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            $this$sendKeepAlive_u24lambda_u2410.setPayload(ByteBuffer.wrap(byArray));
            aWSLambda.invoke(invokeRequest);
        }

        private static boolean generateCloudFormation$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static void generateCloudFormation$lambda$2(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        private static void md5Hash$readChunk(byte[] buffer, MessageDigest messageDigest, InputStream stream) {
            int bytesRead;
            while ((bytesRead = stream.read(buffer)) != -1) {
                messageDigest.update(buffer, 0, bytesRead);
            }
            return;
        }

        private static boolean uploadTemplates$lambda$6(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static void uploadTemplates$lambda$7(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        private static boolean staticFilesInfo$lambda$9(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ Path access$getCloudFormationGeneratedDir(DeployableProject $this) {
            return DefaultImpls.getCloudFormationGeneratedDir($this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lws/osiris/awsdeploy/DeployableProject$ZipKey;", "", "hash", "", "name", "(Ljava/lang/String;Ljava/lang/String;)V", "getHash", "()Ljava/lang/String;", "getName", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "osiris-aws-deploy"})
    private static final class ZipKey {
        @NotNull
        private final String hash;
        @NotNull
        private final String name;

        public ZipKey(@NotNull String hash, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.hash = hash;
            this.name = name;
        }

        @NotNull
        public final String getHash() {
            return this.hash;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String component1() {
            return this.hash;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final ZipKey copy(@NotNull String hash, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new ZipKey(hash, name);
        }

        public static /* synthetic */ ZipKey copy$default(ZipKey zipKey, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = zipKey.hash;
            }
            if ((n & 2) != 0) {
                string2 = zipKey.name;
            }
            return zipKey.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "ZipKey(hash=" + this.hash + ", name=" + this.name + ")";
        }

        public int hashCode() {
            int result = this.hash.hashCode();
            result = result * 31 + this.name.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ZipKey)) {
                return false;
            }
            ZipKey zipKey = (ZipKey)other;
            if (!Intrinsics.areEqual((Object)this.hash, (Object)zipKey.hash)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.name, (Object)zipKey.name);
        }
    }
}

