/*
 * Decompiled with CFR 0.152.
 */
package ws.osiris.awsdeploy;

import com.amazonaws.services.apigateway.model.CreateDeploymentRequest;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ws.osiris.aws.ConfigKt;
import ws.osiris.aws.Stage;
import ws.osiris.awsdeploy.AwsProfile;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004\u001a \u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u0004\u001a\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0004\u001a:\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000e2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0000\u001a \u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u0004\u001a>\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001b2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u0004\u001a*\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u0004\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "bucketName", "", "appName", "envName", "suffix", "accountId", "codeBucketName", "createBucket", "profile", "Lws/osiris/awsdeploy/AwsProfile;", "deployStages", "", "apiId", "apiName", "stages", "Lws/osiris/aws/Stage;", "stackCreated", "", "generatedTemplateParameters", "", "templateYaml", "staticFilesBucketName", "uploadFile", "file", "Ljava/nio/file/Path;", "baseDir", "key", "bucketDir", "osiris-aws-deploy"})
@SourceDebugExtension(value={"SMAP\nDeploy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Deploy.kt\nws/osiris/awsdeploy/DeployKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,188:1\n1549#2:189\n1620#2,3:190\n766#2:193\n857#2,2:194\n1549#2:196\n1620#2,3:197\n766#2:201\n857#2,2:202\n766#2:208\n857#2,2:209\n1549#2:211\n1620#2,3:212\n766#2:215\n857#2,2:216\n1549#2:218\n1620#2,3:219\n1549#2:222\n1620#2,3:223\n1#3:200\n125#4:204\n152#4,3:205\n*S KotlinDebug\n*F\n+ 1 Deploy.kt\nws/osiris/awsdeploy/DeployKt\n*L\n30#1:189\n30#1:190,3\n32#1:193\n32#1:194,2\n42#1:196\n42#1:197,3\n120#1:201\n120#1:202,2\n178#1:208\n178#1:209,2\n179#1:211\n179#1:212,3\n180#1:215\n180#1:216,2\n181#1:218\n181#1:219,3\n182#1:222\n182#1:223,3\n177#1:204\n177#1:205,3\n*E\n"})
public final class DeployKt {
    private static final Logger log = LoggerFactory.getLogger((String)"ws.osiris.awsdeploy");

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> deployStages(@NotNull AwsProfile profile, @NotNull String apiId, @NotNull String apiName, @NotNull List<Stage> stages, boolean stackCreated) {
        List list;
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)apiId, (String)"apiId");
        Intrinsics.checkNotNullParameter((Object)apiName, (String)"apiName");
        Intrinsics.checkNotNullParameter(stages, (String)"stages");
        if (stackCreated) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = stages;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Stage stage = (Stage)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            list = (List)destination$iv$iv;
        } else {
            void $this$mapTo$iv$iv;
            Object object;
            Stage it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = stages;
            boolean $i$f$filter = false;
            Iterable destination$iv$iv = $this$filter$iv;
            Iterable destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Stage)element$iv$iv;
                boolean bl = false;
                if (!it.getDeployOnUpdate()) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List stagesToDeploy = (List)destination$iv$iv2;
            for (Stage stage : stagesToDeploy) {
                void $this$deployStages_u24lambda_u242;
                log.debug("Updating REST API '" + apiName + "' in stage '" + stage.getName() + "'");
                $this$filterTo$iv$iv = new CreateDeploymentRequest();
                destination$iv$iv2 = $this$filterTo$iv$iv;
                object = profile.getApiGatewayClient();
                boolean bl = false;
                $this$deployStages_u24lambda_u242.setRestApiId(apiId);
                $this$deployStages_u24lambda_u242.setStageName(stage.getName());
                $this$deployStages_u24lambda_u242.setVariables(stage.getVariables());
                $this$deployStages_u24lambda_u242.setDescription(stage.getDescription());
                object.createDeployment((CreateDeploymentRequest)$this$filterTo$iv$iv);
            }
            Iterable $this$map$iv = stagesToDeploy;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Stage)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl = false;
                object.add(it.getName());
            }
            list = (List)destination$iv$iv2;
        }
        return list;
    }

    @NotNull
    public static final String createBucket(@NotNull AwsProfile profile, @NotNull String bucketName) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)bucketName, (String)"bucketName");
        ConfigKt.validateBucketName((String)bucketName);
        if (!profile.getS3Client().doesBucketExistV2(bucketName)) {
            profile.getS3Client().createBucket(bucketName);
            log.info("Created S3 bucket '" + bucketName + "'");
        } else {
            log.info("Using existing S3 bucket '" + bucketName + "'");
        }
        return bucketName;
    }

    @NotNull
    public static final String uploadFile(@NotNull AwsProfile profile, @NotNull Path file, @NotNull String bucketName, @Nullable String key) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)bucketName, (String)"bucketName");
        Path path = file.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
        return DeployKt.uploadFile$default(profile, file, bucketName, path, key, null, 32, null);
    }

    public static /* synthetic */ String uploadFile$default(AwsProfile awsProfile, Path path, String string, String string2, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        return DeployKt.uploadFile(awsProfile, path, string, string2);
    }

    @NotNull
    public static final String uploadFile(@NotNull AwsProfile profile, @NotNull Path file, @NotNull String bucketName, @NotNull Path baseDir, @Nullable String key, @Nullable String bucketDir) {
        Object object;
        String uploadKey;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)bucketName, (String)"bucketName");
                Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
                String string = key;
                if (string == null) {
                    string = uploadKey = StringsKt.replace$default((String)((Object)baseDir.relativize(file)).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
                }
                if ((object = bucketDir) == null) break block4;
                String it = object;
                boolean bl = false;
                String string2 = bucketDir + "/";
                object = string2;
                if (string2 != null) break block5;
            }
            object = "";
        }
        String dirPart = object;
        String fullKey = dirPart + uploadKey;
        profile.getS3Client().putObject(bucketName, fullKey, file.toFile());
        String url = "https://" + bucketName + ".s3." + profile.getRegion() + ".amazonaws.com/" + fullKey;
        Object[] objectArray = new Object[]{file, bucketName, url};
        log.debug("Uploaded file {} to S3 bucket {}, URL {}", objectArray);
        return url;
    }

    public static /* synthetic */ String uploadFile$default(AwsProfile awsProfile, Path path, String string, Path path2, String string2, String string3, int n, Object object) {
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        if ((n & 0x20) != 0) {
            string3 = null;
        }
        return DeployKt.uploadFile(awsProfile, path, string, path2, string2, string3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String bucketName(@NotNull String appName, @Nullable String envName, @NotNull String suffix, @NotNull String accountId2) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Intrinsics.checkNotNullParameter((Object)accountId2, (String)"accountId");
        Object object = new String[]{appName, envName, suffix, accountId2};
        object = CollectionsKt.listOfNotNull((Object[])object);
        boolean $i$f$filter = false;
        void var7_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"-", null, null, (int)0, null, null, (int)62, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String bucketName = string;
        return ConfigKt.validateBucketName((String)bucketName);
    }

    @NotNull
    public static final String codeBucketName(@NotNull String appName, @Nullable String envName, @NotNull String accountId2) {
        Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
        Intrinsics.checkNotNullParameter((Object)accountId2, (String)"accountId");
        return DeployKt.bucketName(appName, envName, "code", accountId2);
    }

    @NotNull
    public static final String staticFilesBucketName(@NotNull String appName, @Nullable String envName, @NotNull String accountId2) {
        Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
        Intrinsics.checkNotNullParameter((Object)accountId2, (String)"accountId");
        return DeployKt.bucketName(appName, envName, "staticfiles", accountId2);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @NotNull
    public static final Set<String> generatedTemplateParameters(@NotNull String templateYaml, @NotNull String apiName) {
        Intrinsics.checkNotNullParameter((Object)templateYaml, (String)"templateYaml");
        Intrinsics.checkNotNullParameter((Object)apiName, (String)"apiName");
        objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        rootTemplateMap = (Map)objectMapper.readValue(templateYaml, Map.class);
        Intrinsics.checkNotNull((Object)rootTemplateMap);
        var5_4 = (Map)rootTemplateMap.get("Resources");
        if (var5_4 == null) ** GOTO lbl-1000
        var6_5 = var5_4;
        $i$f$map = false;
        var8_8 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>($this$map$iv.size());
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            var13_27 = item$iv$iv;
            var20_36 = destination$iv$iv;
            $i$a$-map-DeployKt$generatedTemplateParameters$parameters$1 = false;
            v0 = it.getValue();
            Intrinsics.checkNotNull(v0, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
            var20_36.add((Map)v0);
        }
        $i$f$map = (List)destination$iv$iv;
        $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map)element$iv$iv;
            $i$a$-filter-DeployKt$generatedTemplateParameters$parameters$2 = false;
            if (!Intrinsics.areEqual(it.get("Type"), (Object)"AWS::CloudFormation::Stack")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $i$f$filter = (List)destination$iv$iv;
        $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (E item$iv$iv : $this$mapTo$iv$iv) {
            $i$a$-filter-DeployKt$generatedTemplateParameters$parameters$2 = (Map)item$iv$iv;
            var20_36 = destination$iv$iv;
            $i$a$-map-DeployKt$generatedTemplateParameters$parameters$3 = false;
            v1 = it.get("Properties");
            Intrinsics.checkNotNull(v1, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
            var20_36.add((Map)v1);
        }
        $i$f$map = (List)destination$iv$iv;
        $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map)element$iv$iv;
            $i$a$-filter-DeployKt$generatedTemplateParameters$parameters$4 = false;
            var18_49 = it.get("TemplateURL");
            v2 = var18_49 instanceof String != false ? (String)var18_49 : null;
            if (!(v2 != null ? StringsKt.endsWith$default((String)v2, (String)("/" + apiName + ".template"), (boolean)false, (int)2, null) : false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $i$f$filter = (List)destination$iv$iv;
        $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            $i$a$-filter-DeployKt$generatedTemplateParameters$parameters$4 = (Map)item$iv$iv;
            var20_36 = destination$iv$iv;
            $i$a$-map-DeployKt$generatedTemplateParameters$parameters$5 = false;
            v3 = it.get("Parameters");
            Intrinsics.checkNotNull(v3, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
            var20_36.add((Map)v3);
        }
        $i$f$map = (List)destination$iv$iv;
        $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            $i$a$-map-DeployKt$generatedTemplateParameters$parameters$5 = (Map)item$iv$iv;
            var20_36 = destination$iv$iv;
            $i$a$-map-DeployKt$generatedTemplateParameters$parameters$6 = false;
            var20_36.add(it.keySet());
        }
        var11_22 = (Set)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
        if (var11_22 != null) {
            v4 = var11_22;
        } else lbl-1000:
        // 2 sources

        {
            v4 = SetsKt.emptySet();
        }
        parameters = v4;
        return SetsKt.minus((Set)SetsKt.minus((Set)parameters, (Object)"LambdaRole"), (Object)"CustomAuthArn");
    }
}

