/*
 * Decompiled with CFR 0.152.
 */
package ws.osiris.awsdeploy.cloudformation;

import java.io.Writer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import ws.osiris.awsdeploy.cloudformation.Template;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lws/osiris/awsdeploy/cloudformation/StaticFilesRoleTemplate;", "Lws/osiris/awsdeploy/cloudformation/Template;", "staticFilesBucketArn", "", "(Ljava/lang/String;)V", "resourceCount", "", "getResourceCount", "()I", "write", "", "writer", "Ljava/io/Writer;", "osiris-aws-deploy"})
public final class StaticFilesRoleTemplate
implements Template {
    private final int resourceCount = 1;
    private final String staticFilesBucketArn;

    @Override
    public int getResourceCount() {
        return this.resourceCount;
    }

    @Override
    public void write(@NotNull Writer writer) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        String template = StringsKt.trimMargin$default((String)("\n        |\n        |  StaticFilesRole:\n        |    Type: AWS::IAM::Role\n        |    Properties:\n        |      AssumeRolePolicyDocument:\n        |        Version: 2012-10-17\n        |        Statement:\n        |          - Effect: Allow\n        |            Principal:\n        |              Service:\n        |                - apigateway.amazonaws.com\n        |            Action: sts:AssumeRole\n        |      Policies:\n        |        - PolicyName: StaticFilesPolicy\n        |          PolicyDocument:\n        |            Version: 2012-10-17\n        |            Statement:\n        |              - Effect: Allow\n        |                Action:\n        |                  - \"s3:ListBucket\"\n        |                Resource: \"" + this.staticFilesBucketArn + "\"\n        |              - Effect: Allow\n        |                Action:\n        |                  - \"s3:GetObject\"\n        |                Resource: \"" + this.staticFilesBucketArn + "/*\"\n"), null, (int)1, null);
        writer.write(template);
    }

    public StaticFilesRoleTemplate(@NotNull String staticFilesBucketArn) {
        Intrinsics.checkParameterIsNotNull((Object)staticFilesBucketArn, (String)"staticFilesBucketArn");
        this.staticFilesBucketArn = staticFilesBucketArn;
        this.resourceCount = 1;
    }
}

