/*
 * Decompiled with CFR 0.152.
 */
package ws.osiris.awsdeploy.cloudformation;

import java.io.Writer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import ws.osiris.awsdeploy.cloudformation.Template;
import ws.osiris.awsdeploy.cloudformation.TemplatesKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lws/osiris/awsdeploy/cloudformation/OutputsTemplate;", "Lws/osiris/awsdeploy/cloudformation/Template;", "codeS3Bucket", "", "codeS3Key", "authorizer", "", "keepAlive", "(Ljava/lang/String;Ljava/lang/String;ZZ)V", "resourceCount", "", "getResourceCount", "()I", "write", "", "writer", "Ljava/io/Writer;", "osiris-aws-deploy"})
public final class OutputsTemplate
implements Template {
    private final int resourceCount = 0;
    private final String codeS3Bucket;
    private final String codeS3Key;
    private final boolean authorizer;
    private final boolean keepAlive;

    @Override
    public int getResourceCount() {
        return this.resourceCount;
    }

    @Override
    public void write(@NotNull Writer writer) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        if (this.authorizer) {
            TemplatesKt.access$getLog$p().debug("Creating template output AuthorizerId containing the ARN of the custom authorizer");
        }
        String authTemplate = this.authorizer ? "\n        |  AuthorizerId:\n        |    Description: ID of the authorizer\n        |    Value: !Ref Authorizer\n" : "";
        String keepAliveTemplate = this.keepAlive ? "\n        |  KeepAliveLambdaArn:\n        |    Description: The keep-alive lambda function\n        |    Value: !GetAtt KeepAliveFunction.Arn\n" : "";
        String template = StringsKt.trimMargin$default((String)("\n        |\n        |Outputs:\n        |  ApiId:\n        |    Description: ID of the API Gateway API\n        |    Value: !Ref Api\n        |  ApiRootResourceId:\n        |    Description: ID of the root resource API Gateway API\n        |    Value: !GetAtt Api.RootResourceId\n        |  LambdaArn:\n        |    Description: The lambda function\n        |    Value: !GetAtt Function.Arn\n        |  LambdaVersionArn:\n        |    Description: The lambda function version\n        |    Value: !GetAtt LambdaVersion.FunctionArn\n        |  CodeS3Bucket:\n        |    Description: The name of the bucket containing the code\n        |    Value: " + this.codeS3Bucket + "\n        |  CodeS3Key:\n        |    Description: The key used to store the jar file containing the code in the S3 bucket\n        |    Value: " + this.codeS3Key + authTemplate + keepAliveTemplate + '\n'), null, (int)1, null);
        writer.write(template);
    }

    public OutputsTemplate(@NotNull String codeS3Bucket, @NotNull String codeS3Key, boolean authorizer, boolean keepAlive) {
        Intrinsics.checkParameterIsNotNull((Object)codeS3Bucket, (String)"codeS3Bucket");
        Intrinsics.checkParameterIsNotNull((Object)codeS3Key, (String)"codeS3Key");
        this.codeS3Bucket = codeS3Bucket;
        this.codeS3Key = codeS3Key;
        this.authorizer = authorizer;
        this.keepAlive = keepAlive;
    }
}

