/*
 * Decompiled with CFR 0.152.
 */
package ws.osiris.awsdeploy.cloudformation;

import com.amazonaws.services.apigateway.AmazonApiGateway;
import com.amazonaws.services.apigateway.model.GetRestApisRequest;
import com.amazonaws.services.apigateway.model.GetRestApisResult;
import com.amazonaws.services.apigateway.model.RestApi;
import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.model.CreateStackRequest;
import com.amazonaws.services.cloudformation.model.CreateStackResult;
import com.amazonaws.services.cloudformation.model.DeleteStackRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackResourceRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackResourceResult;
import com.amazonaws.services.cloudformation.model.DescribeStacksRequest;
import com.amazonaws.services.cloudformation.model.DescribeStacksResult;
import com.amazonaws.services.cloudformation.model.ListStacksRequest;
import com.amazonaws.services.cloudformation.model.ListStacksResult;
import com.amazonaws.services.cloudformation.model.Output;
import com.amazonaws.services.cloudformation.model.Stack;
import com.amazonaws.services.cloudformation.model.StackResourceDetail;
import com.amazonaws.services.cloudformation.model.StackStatus;
import com.amazonaws.services.cloudformation.model.StackSummary;
import com.amazonaws.services.cloudformation.model.UpdateStackRequest;
import com.amazonaws.services.cloudformation.model.UpdateStackResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ws.osiris.awsdeploy.AwsProfile;
import ws.osiris.awsdeploy.cloudformation.DeployResult;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u001a\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0000\u001a\"\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a&\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0001\u001a\"\u0010\u001c\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0018\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0010\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 *\u00020\"\u001a\u0010\u0010#\u001a\b\u0012\u0004\u0012\u00020$0 *\u00020\u0015\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"CAPABILITY_NAMED_IAM", "", "createStatuses", "", "Lcom/amazonaws/services/cloudformation/model/StackStatus;", "deleteStatuses", "deployedStatuses", "failedStatuses", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "successStatuses", "updateStatuses", "apiId", "apiName", "profile", "Lws/osiris/awsdeploy/AwsProfile;", "appName", "envName", "createStack", "cloudFormationClient", "Lcom/amazonaws/services/cloudformation/AmazonCloudFormation;", "templateUrl", "deleteStack", "", "deployStack", "Lws/osiris/awsdeploy/cloudformation/DeployResult;", "stackName", "updateStack", "waitForStack", "stackId", "getAllRestApis", "", "Lcom/amazonaws/services/apigateway/model/RestApi;", "Lcom/amazonaws/services/apigateway/AmazonApiGateway;", "listAllStacks", "Lcom/amazonaws/services/cloudformation/model/StackSummary;", "osiris-aws-deploy"})
public final class CloudFormationKt {
    private static final Logger log = LoggerFactory.getLogger((String)"ws.osiris.aws.cloudformation");
    private static final String CAPABILITY_NAMED_IAM = "CAPABILITY_NAMED_IAM";
    private static final Set<StackStatus> updateStatuses = SetsKt.setOf((Object[])new StackStatus[]{StackStatus.CREATE_COMPLETE, StackStatus.UPDATE_COMPLETE, StackStatus.UPDATE_COMPLETE_CLEANUP_IN_PROGRESS, StackStatus.UPDATE_ROLLBACK_COMPLETE, StackStatus.UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS});
    private static final Set<StackStatus> createStatuses = SetsKt.setOf((Object[])new StackStatus[]{StackStatus.CREATE_FAILED, StackStatus.DELETE_COMPLETE});
    private static final Set<StackStatus> deleteStatuses = SetsKt.setOf((Object)StackStatus.ROLLBACK_COMPLETE);
    private static final Set<StackStatus> deployedStatuses = SetsKt.setOf((Object[])new StackStatus[]{StackStatus.CREATE_COMPLETE, StackStatus.UPDATE_COMPLETE});
    private static final Set<StackStatus> successStatuses = SetsKt.setOf((Object[])new StackStatus[]{StackStatus.CREATE_COMPLETE, StackStatus.DELETE_COMPLETE, StackStatus.UPDATE_COMPLETE});
    private static final Set<StackStatus> failedStatuses = SetsKt.setOf((Object[])new StackStatus[]{StackStatus.CREATE_FAILED, StackStatus.ROLLBACK_IN_PROGRESS, StackStatus.ROLLBACK_FAILED, StackStatus.DELETE_FAILED, StackStatus.ROLLBACK_COMPLETE, StackStatus.UPDATE_ROLLBACK_IN_PROGRESS, StackStatus.UPDATE_ROLLBACK_FAILED, StackStatus.UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS, StackStatus.UPDATE_ROLLBACK_COMPLETE});

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DeployResult deployStack(@NotNull AwsProfile profile, @NotNull String stackName, @NotNull String apiName, @NotNull String templateUrl) {
        Object v11;
        String keepAliveLambdaArn;
        Stack stack;
        boolean created;
        block16: {
            Object v7;
            block15: {
                DescribeStacksResult describeResult;
                StackSummary stackSummary;
                Pair pair;
                void $this$filterTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
                Intrinsics.checkParameterIsNotNull((Object)stackName, (String)"stackName");
                Intrinsics.checkParameterIsNotNull((Object)apiName, (String)"apiName");
                Intrinsics.checkParameterIsNotNull((Object)templateUrl, (String)"templateUrl");
                log.debug("Deploying stack to region {} using template {}", (Object)profile.getRegion(), (Object)templateUrl);
                List<StackSummary> stackSummaries = CloudFormationKt.listAllStacks(profile.getCloudFormationClient());
                Iterable $this$filter$iv = stackSummaries;
                boolean $i$f$filter22 = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    StackSummary it = (StackSummary)element$iv$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getStackName(), (Object)stackName) && Intrinsics.areEqual((Object)it.getStackStatus(), (Object)"DELETE_COMPLETE") ^ true)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List liveStacks = (List)destination$iv$iv;
                if (liveStacks.isEmpty()) {
                    String stackId = CloudFormationKt.createStack(stackName, profile.getCloudFormationClient(), templateUrl);
                    pair = new Pair((Object)stackId, (Object)true);
                } else {
                    if (liveStacks.size() > 1) {
                        throw (Throwable)new IllegalStateException("Found multiple stacks named '" + stackName + "': " + liveStacks);
                    }
                    stackSummary = (StackSummary)liveStacks.get(0);
                    StackStatus status22 = StackStatus.fromValue((String)stackSummary.getStackStatus());
                    if (deleteStatuses.contains(status22)) {
                        CloudFormationKt.deleteStack(stackName, profile.getCloudFormationClient());
                        String stackId = CloudFormationKt.createStack(stackName, profile.getCloudFormationClient(), templateUrl);
                        pair = new Pair((Object)stackId, (Object)true);
                    } else if (updateStatuses.contains(status22)) {
                        String stackId = CloudFormationKt.updateStack(stackName, templateUrl, profile);
                        pair = new Pair((Object)stackId, (Object)false);
                    } else if (createStatuses.contains(status22)) {
                        String stackId = CloudFormationKt.createStack(stackName, profile.getCloudFormationClient(), templateUrl);
                        pair = new Pair((Object)stackId, (Object)true);
                    } else {
                        throw (Throwable)new IllegalStateException("Unable to deploy stack '" + stackName + "' with status " + stackSummary.getStackStatus());
                    }
                }
                Pair $i$f$filter22 = pair;
                created = (Boolean)$i$f$filter22.component2();
                stackSummary = new DescribeStackResourceRequest();
                AmazonCloudFormation amazonCloudFormation = profile.getCloudFormationClient();
                boolean status22 = false;
                boolean stackId = false;
                StackSummary $this$apply322 = stackSummary;
                boolean bl = false;
                $this$apply322.setStackName(stackName);
                $this$apply322.setLogicalResourceId("ApiStack");
                StackSummary stackSummary2 = stackSummary;
                DescribeStackResourceResult apiStackResourceResult = amazonCloudFormation.describeStackResource((DescribeStackResourceRequest)stackSummary2);
                DescribeStacksRequest status22 = new DescribeStacksRequest();
                amazonCloudFormation = profile.getCloudFormationClient();
                stackId = false;
                boolean $this$apply322 = false;
                DescribeStacksRequest $this$apply22 = status22;
                boolean bl2 = false;
                DescribeStackResourceResult describeStackResourceResult = apiStackResourceResult;
                Intrinsics.checkExpressionValueIsNotNull((Object)describeStackResourceResult, (String)"apiStackResourceResult");
                StackResourceDetail stackResourceDetail = describeStackResourceResult.getStackResourceDetail();
                Intrinsics.checkExpressionValueIsNotNull((Object)stackResourceDetail, (String)"apiStackResourceResult.stackResourceDetail");
                $this$apply22.setStackName(stackResourceDetail.getPhysicalResourceId());
                stackSummary2 = status22;
                DescribeStacksResult describeStacksResult = describeResult = amazonCloudFormation.describeStacks((DescribeStacksRequest)stackSummary2);
                Intrinsics.checkExpressionValueIsNotNull((Object)describeStacksResult, (String)"describeResult");
                if (describeStacksResult.getStacks().size() != 1) {
                    throw (Throwable)new IllegalStateException("Multiple stacks found: " + describeResult.getStacks());
                }
                Stack stack2 = stack = (Stack)describeResult.getStacks().get(0);
                Intrinsics.checkExpressionValueIsNotNull((Object)stack2, (String)"stack");
                List list = stack2.getOutputs();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"stack.outputs");
                Iterable $this$apply322 = list;
                boolean $this$apply22 = false;
                Iterable iterable2 = $this$apply322;
                boolean bl3 = false;
                for (Object object : iterable2) {
                    Output it = (Output)object;
                    boolean bl4 = false;
                    Output output = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)output, (String)"it");
                    if (!Intrinsics.areEqual((Object)output.getOutputKey(), (Object)"KeepAliveLambdaArn")) continue;
                    v7 = object;
                    break block15;
                }
                v7 = null;
            }
            Output output = v7;
            keepAliveLambdaArn = output != null ? output.getOutputValue() : null;
            List list = stack.getOutputs();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"stack.outputs");
            Iterable $this$apply22 = list;
            boolean bl = false;
            Iterable iterable = $this$apply22;
            boolean bl5 = false;
            for (Object e : iterable) {
                Output it = (Output)e;
                boolean bl6 = false;
                Output output2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)output2, (String)"it");
                if (!Intrinsics.areEqual((Object)output2.getOutputKey(), (Object)"LambdaVersionArn")) continue;
                v11 = e;
                break block16;
            }
            v11 = null;
        }
        Output output = v11;
        String string = output != null ? output.getOutputValue() : null;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String lambdaVersionArn = string;
        StackStatus status = StackStatus.fromValue((String)stack.getStackStatus());
        if (!deployedStatuses.contains(status)) {
            throw (Throwable)new IllegalStateException("Stack status is " + stack.getStackStatus());
        }
        return new DeployResult(created, CloudFormationKt.apiId(apiName, profile), lambdaVersionArn, keepAliveLambdaArn);
    }

    @NotNull
    public static final List<StackSummary> listAllStacks(@NotNull AmazonCloudFormation $this$listAllStacks) {
        Intrinsics.checkParameterIsNotNull((Object)$this$listAllStacks, (String)"$this$listAllStacks");
        Function1<String, List<? extends StackSummary>> $fun$listAllStacks$1 = new Function1<String, List<? extends StackSummary>>($this$listAllStacks){
            final /* synthetic */ AmazonCloudFormation $this_listAllStacks;

            @NotNull
            public final List<StackSummary> invoke(@Nullable String token) {
                List list;
                ListStacksResult result;
                ListStacksRequest listStacksRequest = new ListStacksRequest();
                AmazonCloudFormation amazonCloudFormation = this.$this_listAllStacks;
                boolean bl = false;
                boolean bl2 = false;
                ListStacksRequest $this$apply = listStacksRequest;
                boolean bl3 = false;
                $this$apply.setNextToken(token);
                ListStacksRequest listStacksRequest2 = listStacksRequest;
                ListStacksResult listStacksResult = result = amazonCloudFormation.listStacks(listStacksRequest2);
                Intrinsics.checkExpressionValueIsNotNull((Object)listStacksResult, (String)"result");
                if (listStacksResult.getNextToken() == null) {
                    List list2 = result.getStackSummaries();
                    list = list2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"result.stackSummaries");
                } else {
                    List list3 = result.getStackSummaries();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"result.stackSummaries");
                    list = CollectionsKt.plus((Collection)list3, (Iterable)this.invoke(result.getNextToken()));
                }
                return list;
            }
            {
                this.$this_listAllStacks = amazonCloudFormation;
                super(1);
            }
        };
        return $fun$listAllStacks$1.invoke(null);
    }

    @NotNull
    public static final String apiId(@NotNull String apiName, @NotNull AwsProfile profile) {
        Object object;
        Object v0;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)apiName, (String)"apiName");
            Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
            Iterable iterable = CloudFormationKt.getAllRestApis(profile.getApiGatewayClient());
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                RestApi it = (RestApi)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)apiName)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((object = (RestApi)v0) == null || (object = object.getId()) == null) {
            throw (Throwable)new IllegalStateException("No API found with name '" + apiName + '\'');
        }
        return object;
    }

    @NotNull
    public static final List<RestApi> getAllRestApis(@NotNull AmazonApiGateway $this$getAllRestApis) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getAllRestApis, (String)"$this$getAllRestApis");
        Function1<String, List<? extends RestApi>> $fun$restApis$1 = new Function1<String, List<? extends RestApi>>($this$getAllRestApis){
            final /* synthetic */ AmazonApiGateway $this_getAllRestApis;

            @NotNull
            public final List<RestApi> invoke(@Nullable String token) {
                List list;
                GetRestApisResult result;
                GetRestApisRequest getRestApisRequest = new GetRestApisRequest();
                AmazonApiGateway amazonApiGateway = this.$this_getAllRestApis;
                boolean bl = false;
                boolean bl2 = false;
                GetRestApisRequest $this$apply = getRestApisRequest;
                boolean bl3 = false;
                $this$apply.setPosition(token);
                GetRestApisRequest getRestApisRequest2 = getRestApisRequest;
                GetRestApisResult getRestApisResult = result = amazonApiGateway.getRestApis(getRestApisRequest2);
                Intrinsics.checkExpressionValueIsNotNull((Object)getRestApisResult, (String)"result");
                List apis = getRestApisResult.getItems();
                if (result.getPosition() == null) {
                    List list2 = apis;
                    list = list2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"apis");
                } else {
                    List list3 = apis;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"apis");
                    list = CollectionsKt.plus((Collection)list3, (Iterable)this.invoke(result.getPosition()));
                }
                return list;
            }
            {
                this.$this_getAllRestApis = amazonApiGateway;
                super(1);
            }
        };
        return $fun$restApis$1.invoke(null);
    }

    @NotNull
    public static final String apiName(@NotNull String appName, @Nullable String envName) {
        Intrinsics.checkParameterIsNotNull((Object)appName, (String)"appName");
        return envName == null ? appName : appName + '.' + envName;
    }

    private static final void deleteStack(String apiName, AmazonCloudFormation cloudFormationClient2) {
        DescribeStacksResult describeResult;
        log.info("Deleting stack '" + apiName + '\'');
        DescribeStacksRequest describeStacksRequest = new DescribeStacksRequest();
        AmazonCloudFormation amazonCloudFormation = cloudFormationClient2;
        boolean bl = false;
        boolean bl2 = false;
        DescribeStacksRequest $this$apply = describeStacksRequest;
        boolean bl3 = false;
        $this$apply.setStackName(apiName);
        DescribeStacksRequest describeStacksRequest2 = describeStacksRequest;
        DescribeStacksResult describeStacksResult = describeResult = amazonCloudFormation.describeStacks(describeStacksRequest2);
        Intrinsics.checkExpressionValueIsNotNull((Object)describeStacksResult, (String)"describeResult");
        Object e = describeStacksResult.getStacks().get(0);
        Intrinsics.checkExpressionValueIsNotNull(e, (String)"describeResult.stacks[0]");
        String stackId = ((Stack)e).getStackId();
        DeleteStackRequest deleteStackRequest = new DeleteStackRequest();
        amazonCloudFormation = cloudFormationClient2;
        bl2 = false;
        boolean bl4 = false;
        DeleteStackRequest $this$apply2 = deleteStackRequest;
        boolean bl5 = false;
        $this$apply2.setStackName(apiName);
        describeStacksRequest2 = deleteStackRequest;
        amazonCloudFormation.deleteStack((DeleteStackRequest)describeStacksRequest2);
        String string = stackId;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"stackId");
        CloudFormationKt.waitForStack(string, cloudFormationClient2);
        log.info("Deleted stack '" + apiName + '\'');
    }

    private static final String updateStack(String appName, String templateUrl, AwsProfile profile) {
        UpdateStackResult updateResult;
        log.info("Updating stack '{}'", (Object)appName);
        UpdateStackRequest updateStackRequest = new UpdateStackRequest();
        AmazonCloudFormation amazonCloudFormation = profile.getCloudFormationClient();
        boolean bl = false;
        boolean bl2 = false;
        UpdateStackRequest $this$apply = updateStackRequest;
        boolean bl3 = false;
        $this$apply.setStackName(appName);
        $this$apply.setTemplateURL(templateUrl);
        $this$apply.setCapabilities((Collection)CollectionsKt.listOf((Object)CAPABILITY_NAMED_IAM));
        UpdateStackRequest updateStackRequest2 = updateStackRequest;
        UpdateStackResult updateStackResult = updateResult = amazonCloudFormation.updateStack(updateStackRequest2);
        Intrinsics.checkExpressionValueIsNotNull((Object)updateStackResult, (String)"updateResult");
        String string = updateStackResult.getStackId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"updateResult.stackId");
        CloudFormationKt.waitForStack(string, profile.getCloudFormationClient());
        log.info("Stack updated. ID = " + updateResult.getStackId());
        return updateResult.getStackId();
    }

    private static final String createStack(String apiName, AmazonCloudFormation cloudFormationClient2, String templateUrl) {
        CreateStackResult createResult;
        log.info("Creating stack '{}'", (Object)apiName);
        CreateStackRequest createStackRequest = new CreateStackRequest();
        AmazonCloudFormation amazonCloudFormation = cloudFormationClient2;
        boolean bl = false;
        boolean bl2 = false;
        CreateStackRequest $this$apply = createStackRequest;
        boolean bl3 = false;
        $this$apply.setStackName(apiName);
        $this$apply.setTemplateURL(templateUrl);
        $this$apply.setCapabilities((Collection)CollectionsKt.listOf((Object)CAPABILITY_NAMED_IAM));
        CreateStackRequest createStackRequest2 = createStackRequest;
        CreateStackResult createStackResult = createResult = amazonCloudFormation.createStack(createStackRequest2);
        Intrinsics.checkExpressionValueIsNotNull((Object)createStackResult, (String)"createResult");
        String string = createStackResult.getStackId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"createResult.stackId");
        CloudFormationKt.waitForStack(string, cloudFormationClient2);
        log.info("Stack created. ID = " + createResult.getStackId());
        return createResult.getStackId();
    }

    private static final void waitForStack(String stackId, AmazonCloudFormation cloudFormationClient2) {
        Function1<Integer, Unit> $fun$waitForStack$1 = new Function1<Integer, Unit>(cloudFormationClient2, stackId){
            final /* synthetic */ AmazonCloudFormation $cloudFormationClient;
            final /* synthetic */ String $stackId;

            /*
             * WARNING - void declaration
             */
            public final void invoke(int count) {
                while (true) {
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = CloudFormationKt.listAllStacks(this.$cloudFormationClient);
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        StackSummary it = (StackSummary)element$iv$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getStackId(), (Object)this.$stackId)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    StackSummary stackSummary = (StackSummary)((List)destination$iv$iv).get(0);
                    StackStatus status = StackStatus.fromValue((String)stackSummary.getStackStatus());
                    if (CloudFormationKt.access$getSuccessStatuses$p().contains(status)) {
                        CloudFormationKt.access$getLog$p().debug("Stack status " + status + ", returning");
                        return;
                    }
                    if (CloudFormationKt.access$getFailedStatuses$p().contains(status)) {
                        throw (Throwable)new IllegalStateException("Deployment failed, stack status: " + status);
                    }
                    CloudFormationKt.access$getLog$p().debug("Stack status " + status + ", waiting");
                    if (count % 5 == 0) {
                        CloudFormationKt.access$getLog$p().info("Waiting for stack to deploy...");
                    }
                    Thread.sleep(1000L);
                    ++count;
                }
            }
            {
                this.$cloudFormationClient = amazonCloudFormation;
                this.$stackId = string;
                super(1);
            }
        };
        $fun$waitForStack$1.invoke(1);
    }

    public static final /* synthetic */ Logger access$getLog$p() {
        return log;
    }

    public static final /* synthetic */ Set access$getSuccessStatuses$p() {
        return successStatuses;
    }

    public static final /* synthetic */ Set access$getFailedStatuses$p() {
        return failedStatuses;
    }
}

