/*
 * Decompiled with CFR 0.152.
 */
package ws.osiris.awsdeploy.cloudformation;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ws.osiris.awsdeploy.cloudformation.CloudFormationFile;
import ws.osiris.awsdeploy.cloudformation.CloudFormationKt;
import ws.osiris.awsdeploy.cloudformation.ResourceTemplate;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lws/osiris/awsdeploy/cloudformation/RestCloudFormationFile;", "Lws/osiris/awsdeploy/cloudformation/CloudFormationFile;", "fileName", "", "templates", "", "Lws/osiris/awsdeploy/cloudformation/ResourceTemplate;", "authorizerParam", "", "(Ljava/lang/String;Ljava/util/List;Z)V", "write", "", "templatesDir", "Ljava/nio/file/Path;", "osiris-aws-deploy"})
public final class RestCloudFormationFile
implements CloudFormationFile {
    private final String fileName;
    private final List<ResourceTemplate> templates;
    private final boolean authorizerParam;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(@NotNull Path templatesDir) {
        Intrinsics.checkParameterIsNotNull((Object)templatesDir, (String)"templatesDir");
        Path filePath = templatesDir.resolve(this.fileName);
        Closeable closeable = Files.newBufferedWriter(filePath, StandardOpenOption.CREATE);
        boolean bl = false;
        Throwable throwable = null;
        try {
            BufferedWriter writer = (BufferedWriter)closeable;
            boolean bl2 = false;
            CloudFormationKt.access$getLog$p().info("Writing CloudFormation template {}", (Object)filePath.toAbsolutePath());
            String header = "Parameters:\n  Api:\n    Type: String\n    Description: ID of the API Gateway API\n  ParentResourceId:\n    Type: String\n    Description: ID of the API Gateway resource\n  LambdaArn:\n    Type: String\n    Description: ARN of the lambda function version";
            String authorizerTemplate = "\n  Authorizer:\n    Type: String\n    Description: ID of the custom authorizer";
            writer.write(header);
            if (this.authorizerParam) {
                writer.write(authorizerTemplate);
            }
            writer.write("\n");
            writer.write("Resources:");
            writer.write("\n");
            for (ResourceTemplate template : this.templates) {
                CloudFormationKt.access$getLog$p().debug("Writing resource template with path part {}", (Object)template.getPathPart$osiris_aws_deploy());
                BufferedWriter bufferedWriter = writer;
                Intrinsics.checkExpressionValueIsNotNull((Object)bufferedWriter, (String)"writer");
                template.write(bufferedWriter, "!Ref ParentResourceId", "LambdaArn");
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public RestCloudFormationFile(@NotNull String fileName, @NotNull List<ResourceTemplate> templates, boolean authorizerParam) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull(templates, (String)"templates");
        this.fileName = fileName;
        this.templates = templates;
        this.authorizerParam = authorizerParam;
    }
}

