/*
 * Decompiled with CFR 0.152.
 */
package ws.osiris.awsdeploy.cloudformation;

import java.io.Writer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lws/osiris/awsdeploy/cloudformation/RestStackTemplate;", "", "name", "", "stackFileName", "codeBucket", "authorizerParam", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "getName", "()Ljava/lang/String;", "write", "", "writer", "Ljava/io/Writer;", "osiris-aws-deploy"})
public final class RestStackTemplate {
    @NotNull
    private final String name;
    private final String stackFileName;
    private final String codeBucket;
    private final boolean authorizerParam;

    public final void write(@NotNull Writer writer) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        String templateUrl = "https://" + this.codeBucket + ".s3.${AWS::Region}.amazonaws.com/" + this.stackFileName;
        String template = StringsKt.trimMargin$default((String)("\n        |\n        |  " + this.name + ":\n        |    Type: AWS::CloudFormation::Stack\n        |    Properties:\n        |      TemplateURL: !Sub \"" + templateUrl + "\"\n        |      Parameters:\n        |        ParentResourceId: !GetAtt Api.RootResourceId\n        |        Api: !Ref Api\n        |        LambdaArn: !GetAtt LambdaVersion.FunctionArn\n        "), null, (int)1, null);
        writer.write(template);
        if (this.authorizerParam) {
            writer.write("\n");
            writer.write("        Authorizer: !Ref Authorizer");
            writer.write("\n");
        }
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public RestStackTemplate(@NotNull String name, @NotNull String stackFileName, @NotNull String codeBucket, boolean authorizerParam) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)stackFileName, (String)"stackFileName");
        Intrinsics.checkParameterIsNotNull((Object)codeBucket, (String)"codeBucket");
        this.name = name;
        this.stackFileName = stackFileName;
        this.codeBucket = codeBucket;
        this.authorizerParam = authorizerParam;
    }
}

