/*
 * Decompiled with CFR 0.152.
 */
package ws.osiris.awsdeploy.cloudformation;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ws.osiris.awsdeploy.cloudformation.ApiTemplate;
import ws.osiris.awsdeploy.cloudformation.CloudFormationFile;
import ws.osiris.awsdeploy.cloudformation.CloudFormationKt;
import ws.osiris.awsdeploy.cloudformation.DeploymentTemplate;
import ws.osiris.awsdeploy.cloudformation.OutputsTemplate;
import ws.osiris.awsdeploy.cloudformation.ParametersTemplate;
import ws.osiris.awsdeploy.cloudformation.RestStackTemplate;
import ws.osiris.awsdeploy.cloudformation.Template;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BU\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0016\u0010\u000f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0010\"\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lws/osiris/awsdeploy/cloudformation/MainCloudFormationFile;", "Lws/osiris/awsdeploy/cloudformation/CloudFormationFile;", "fileName", "", "parametersTemplate", "Lws/osiris/awsdeploy/cloudformation/ParametersTemplate;", "outputsTemplate", "Lws/osiris/awsdeploy/cloudformation/OutputsTemplate;", "apiTemplate", "Lws/osiris/awsdeploy/cloudformation/ApiTemplate;", "deploymentTemplate", "Lws/osiris/awsdeploy/cloudformation/DeploymentTemplate;", "restStackTemplates", "", "Lws/osiris/awsdeploy/cloudformation/RestStackTemplate;", "templates", "", "Lws/osiris/awsdeploy/cloudformation/Template;", "(Ljava/lang/String;Lws/osiris/awsdeploy/cloudformation/ParametersTemplate;Lws/osiris/awsdeploy/cloudformation/OutputsTemplate;Lws/osiris/awsdeploy/cloudformation/ApiTemplate;Lws/osiris/awsdeploy/cloudformation/DeploymentTemplate;Ljava/util/List;[Lws/osiris/awsdeploy/cloudformation/Template;)V", "write", "", "templatesDir", "Ljava/nio/file/Path;", "osiris-aws-deploy"})
public final class MainCloudFormationFile
implements CloudFormationFile {
    private final List<Template> templates;
    private final String fileName;
    private final ParametersTemplate parametersTemplate;
    private final OutputsTemplate outputsTemplate;
    private final ApiTemplate apiTemplate;
    private final DeploymentTemplate deploymentTemplate;
    private final List<RestStackTemplate> restStackTemplates;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void write(@NotNull Path templatesDir) {
        Intrinsics.checkParameterIsNotNull((Object)templatesDir, (String)"templatesDir");
        Path filePath = templatesDir.resolve(this.fileName);
        Closeable closeable = Files.newBufferedWriter(filePath, StandardOpenOption.CREATE);
        boolean bl = false;
        Throwable throwable = null;
        try {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            BufferedWriter writer = (BufferedWriter)closeable;
            boolean bl2 = false;
            CloudFormationKt.access$getLog$p().info("Writing CloudFormation template {}", (Object)filePath.toAbsolutePath());
            BufferedWriter bufferedWriter = writer;
            Intrinsics.checkExpressionValueIsNotNull((Object)bufferedWriter, (String)"writer");
            this.parametersTemplate.write(bufferedWriter);
            writer.write("Resources:");
            for (Template template : CollectionsKt.filterNotNull((Iterable)this.templates)) {
                CloudFormationKt.access$getLog$p().debug("Writing template of type {}", (Object)template.getClass().getSimpleName());
                template.write(writer);
            }
            CloudFormationKt.access$getLog$p().debug("Writing root resource template");
            this.apiTemplate.write(writer);
            Iterable iterable = this.restStackTemplates;
            Writer writer2 = writer;
            DeploymentTemplate deploymentTemplate = this.deploymentTemplate;
            boolean $i$f$map = false;
            Iterable iterable2 = iterable;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RestStackTemplate restStackTemplate = (RestStackTemplate)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                String string = it.getName();
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            deploymentTemplate.write(writer2, (List<String>)collection, this.apiTemplate.getRootResource$osiris_aws_deploy());
            for (RestStackTemplate restStackTemplate : this.restStackTemplates) {
                restStackTemplate.write(writer);
            }
            this.outputsTemplate.write(writer);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public MainCloudFormationFile(@NotNull String fileName, @NotNull ParametersTemplate parametersTemplate, @NotNull OutputsTemplate outputsTemplate, @NotNull ApiTemplate apiTemplate, @NotNull DeploymentTemplate deploymentTemplate, @NotNull List<RestStackTemplate> restStackTemplates, Template ... templates) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)parametersTemplate, (String)"parametersTemplate");
        Intrinsics.checkParameterIsNotNull((Object)outputsTemplate, (String)"outputsTemplate");
        Intrinsics.checkParameterIsNotNull((Object)apiTemplate, (String)"apiTemplate");
        Intrinsics.checkParameterIsNotNull((Object)deploymentTemplate, (String)"deploymentTemplate");
        Intrinsics.checkParameterIsNotNull(restStackTemplates, (String)"restStackTemplates");
        Intrinsics.checkParameterIsNotNull((Object)templates, (String)"templates");
        this.fileName = fileName;
        this.parametersTemplate = parametersTemplate;
        this.outputsTemplate = outputsTemplate;
        this.apiTemplate = apiTemplate;
        this.deploymentTemplate = deploymentTemplate;
        this.restStackTemplates = restStackTemplates;
        this.templates = ArraysKt.toList((Object[])templates);
    }
}

