/*
 * Decompiled with CFR 0.152.
 */
package ws.osiris.awsdeploy.cloudformation;

import java.io.Writer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ws.osiris.aws.AuthConfig;
import ws.osiris.awsdeploy.cloudformation.TemplatesKt;
import ws.osiris.awsdeploy.cloudformation.WritableResource;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lws/osiris/awsdeploy/cloudformation/CognitoAuthorizerTemplate;", "Lws/osiris/awsdeploy/cloudformation/WritableResource;", "authConfig", "Lws/osiris/aws/AuthConfig;", "(Lws/osiris/aws/AuthConfig;)V", "write", "", "writer", "Ljava/io/Writer;", "osiris-aws-deploy"})
public final class CognitoAuthorizerTemplate
implements WritableResource {
    private final AuthConfig authConfig;

    @Override
    public void write(@NotNull Writer writer) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        if (this.authConfig instanceof AuthConfig.CognitoUserPools) {
            TemplatesKt.access$getLog$p().debug("Creating Cognito authorizer resource with ARN of existing user pool {}", (Object)((AuthConfig.CognitoUserPools)this.authConfig).getUserPoolArn());
            string = ((AuthConfig.CognitoUserPools)this.authConfig).getUserPoolArn();
        } else {
            TemplatesKt.access$getLog$p().debug("Creating Cognito authorizer resource using template parameter CognitoUserPoolArn");
            string = "!Ref CognitoUserPoolArn";
        }
        String arn = string;
        String template = StringsKt.trimMargin$default((String)("\n        |\n        |  Authorizer:\n        |    Type: \"AWS::ApiGateway::Authorizer\"\n        |    Properties:\n        |      Name: CognitoAuthorizer\n        |      IdentitySource: method.request.header.Authorization\n        |      ProviderARNs:\n        |        - " + arn + "\n        |      RestApiId: !Ref Api\n        |      Type: COGNITO_USER_POOLS\n"), null, (int)1, null);
        writer.write(template);
    }

    public CognitoAuthorizerTemplate(@Nullable AuthConfig authConfig) {
        this.authConfig = authConfig;
    }
}

