/*
 * Decompiled with CFR 0.152.
 */
package ws.osiris.awsdeploy;

import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.InvocationType;
import com.amazonaws.services.lambda.model.InvokeRequest;
import com.google.gson.Gson;
import java.awt.Desktop;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ws.osiris.aws.ApiFactory;
import ws.osiris.aws.ApplicationConfig;
import ws.osiris.awsdeploy.AwsProfile;
import ws.osiris.awsdeploy.DeployException;
import ws.osiris.awsdeploy.DeployKt;
import ws.osiris.awsdeploy.DeployableProject;
import ws.osiris.awsdeploy.DeployableProjectKt;
import ws.osiris.awsdeploy.StaticFilesInfo;
import ws.osiris.awsdeploy.cloudformation.CloudFormationFile;
import ws.osiris.awsdeploy.cloudformation.CloudFormationKt;
import ws.osiris.awsdeploy.cloudformation.DeployResult;
import ws.osiris.awsdeploy.cloudformation.Templates;
import ws.osiris.core.Api;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001:\u0001SJ\u0014\u0010)\u001a\u0006\u0012\u0002\b\u00030*2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\bH\u0002J\u0014\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000301H\u0016J\b\u00102\u001a\u00020.H\u0016J\u001e\u00103\u001a\b\u0012\u0004\u0012\u00020\u0003042\u0006\u00105\u001a\u00020\b2\u0006\u00106\u001a\u00020\u0003H\u0002J\u001c\u00107\u001a\u00020\u00032\u0012\u00108\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b09\"\u00020\bH\u0002J\u0018\u0010:\u001a\u00020.2\u0006\u0010;\u001a\u00020\u00032\u0006\u0010<\u001a\u00020\u0003H\u0016J\b\u0010=\u001a\u00020>H\u0002J(\u0010?\u001a\u00020.2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E2\u0006\u0010=\u001a\u00020>H\u0002J \u0010F\u001a\u0004\u0018\u00010G2\n\u0010H\u001a\u0006\u0012\u0002\b\u00030I2\b\u0010!\u001a\u0004\u0018\u00010\u0003H\u0002J \u0010J\u001a\u00020\u00032\u0006\u0010K\u001a\u00020\u00032\u0006\u0010L\u001a\u00020\u00032\u0006\u0010M\u001a\u00020\u0003H\u0002J.\u0010N\u001a\u00020.2\u0006\u0010=\u001a\u00020>2\n\u0010H\u001a\u0006\u0012\u0002\b\u00030I2\u0006\u0010O\u001a\u00020\u00032\b\u0010!\u001a\u0004\u0018\u00010\u0003H\u0002J\u0018\u0010P\u001a\u00020.2\u0006\u0010=\u001a\u00020>2\u0006\u0010L\u001a\u00020\u0003H\u0002J\u0010\u0010Q\u001a\u00020R2\u0006\u00106\u001a\u00020\u0003H\u0002R\u000b\u0010\u0002\u001a\u00020\u00038BX\u0082\u0004R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000b\u0010\u000b\u001a\u00020\b8BX\u0082\u0004R\u000b\u0010\f\u001a\u00020\b8BX\u0082\u0004R\u0014\u0010\r\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u000b\u0010\u000f\u001a\u00020\u00038BX\u0082\u0004R\u000b\u0010\u0010\u001a\u00020\u00038BX\u0082\u0004R\u000b\u0010\u0011\u001a\u00020\u00038BX\u0082\u0004R\u0012\u0010\u0012\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0006R\u0012\u0010\u0014\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\nR\u0012\u0010\u0016\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0006R\u000b\u0010\u0018\u001a\u00020\b8BX\u0082\u0004R\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u001aX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0012\u0010\u001d\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\nR\u0014\u0010\u001f\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0006R\u0014\u0010!\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0006R\u0014\u0010#\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0006R\u0012\u0010%\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\nR\u000b\u0010'\u001a\u00020\b8BX\u0082\u0004R\u000b\u0010(\u001a\u00020\u00038BX\u0082\u0004\u00a8\u0006T"}, d2={"Lws/osiris/awsdeploy/DeployableProject;", "", "apiFactoryClassName", "", "awsProfile", "getAwsProfile", "()Ljava/lang/String;", "buildDir", "Ljava/nio/file/Path;", "getBuildDir", "()Ljava/nio/file/Path;", "cloudFormationGeneratedDir", "cloudFormationSourceDir", "environmentName", "getEnvironmentName", "generatedCorePackage", "lambdaClassName", "lambdaHandler", "name", "getName", "projectJar", "getProjectJar", "rootPackage", "getRootPackage", "rootTemplate", "runtimeClasspath", "", "getRuntimeClasspath", "()Ljava/util/List;", "sourceDir", "getSourceDir", "stackName", "getStackName", "staticFilesDirectory", "getStaticFilesDirectory", "version", "getVersion", "zipBuildDir", "getZipBuildDir", "zipFile", "zipName", "createApiFactory", "Lws/osiris/aws/ApiFactory;", "parentClassLoader", "Ljava/lang/ClassLoader;", "deleteContents", "", "dir", "deploy", "", "generateCloudFormation", "generatedTemplateParameters", "", "rootTemplatePath", "apiName", "md5Hash", "files", "", "openBrowser", "stage", "path", "profile", "Lws/osiris/awsdeploy/AwsProfile;", "sendKeepAlive", "deployResult", "Lws/osiris/awsdeploy/cloudformation/DeployResult;", "instanceCount", "", "sleepTimeMs", "Ljava/time/Duration;", "staticFilesInfo", "Lws/osiris/awsdeploy/StaticFilesInfo;", "api", "Lws/osiris/core/Api;", "templateUrl", "templateName", "codeBucket", "region", "uploadStaticFiles", "bucket", "uploadTemplates", "zipS3Key", "Lws/osiris/awsdeploy/DeployableProject$ZipKey;", "ZipKey", "osiris-aws-deploy"})
public interface DeployableProject {
    @NotNull
    public String getName();

    @Nullable
    public String getVersion();

    @NotNull
    public Path getBuildDir();

    @NotNull
    public Path getZipBuildDir();

    @NotNull
    public Path getSourceDir();

    @NotNull
    public String getRootPackage();

    @Nullable
    public String getEnvironmentName();

    @Nullable
    public String getStaticFilesDirectory();

    @Nullable
    public String getAwsProfile();

    @Nullable
    public String getStackName();

    @NotNull
    public List<Path> getRuntimeClasspath();

    @NotNull
    public Path getProjectJar();

    @NotNull
    public ApiFactory<?> createApiFactory(@NotNull ClassLoader var1);

    public void generateCloudFormation();

    @NotNull
    public Map<String, String> deploy();

    public void openBrowser(@NotNull String var1, @NotNull String var2);

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lws/osiris/awsdeploy/DeployableProject$ZipKey;", "", "hash", "", "name", "(Ljava/lang/String;Ljava/lang/String;)V", "getHash", "()Ljava/lang/String;", "getName", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "osiris-aws-deploy"})
    private static final class ZipKey {
        @NotNull
        private final String hash;
        @NotNull
        private final String name;

        @NotNull
        public final String getHash() {
            return this.hash;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public ZipKey(@NotNull String hash, @NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            this.hash = hash;
            this.name = name;
        }

        @NotNull
        public final String component1() {
            return this.hash;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final ZipKey copy(@NotNull String hash, @NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            return new ZipKey(hash, name);
        }

        @NotNull
        public static /* synthetic */ ZipKey copy$default(ZipKey zipKey, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = zipKey.hash;
            }
            if ((n & 2) != 0) {
                string2 = zipKey.name;
            }
            return zipKey.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "ZipKey(hash=" + this.hash + ", name=" + this.name + ")";
        }

        public int hashCode() {
            String string = this.hash;
            String string2 = this.name;
            return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ZipKey)) break block3;
                    ZipKey zipKey = (ZipKey)object;
                    if (!Intrinsics.areEqual((Object)this.hash, (Object)zipKey.hash) || !Intrinsics.areEqual((Object)this.name, (Object)zipKey.name)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        private static Path getCloudFormationSourceDir(DeployableProject $this) {
            Path path = $this.getSourceDir().resolve("cloudformation");
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"sourceDir.resolve(\"cloudformation\")");
            return path;
        }

        private static Path getRootTemplate(DeployableProject $this) {
            Path path = DefaultImpls.getCloudFormationSourceDir($this).resolve("root.template");
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"cloudFormationSourceDir.resolve(\"root.template\")");
            return path;
        }

        private static String getGeneratedCorePackage(DeployableProject $this) {
            return $this.getRootPackage() + ".core.generated";
        }

        private static String getLambdaClassName(DeployableProject $this) {
            return DefaultImpls.getGeneratedCorePackage($this) + ".GeneratedLambda";
        }

        private static String getLambdaHandler(DeployableProject $this) {
            return DefaultImpls.getLambdaClassName($this) + "::handle";
        }

        private static Path getCloudFormationGeneratedDir(DeployableProject $this) {
            Path path = $this.getBuildDir().resolve("cloudformation");
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"buildDir.resolve(\"cloudformation\")");
            return path;
        }

        private static String getApiFactoryClassName(DeployableProject $this) {
            return DefaultImpls.getGeneratedCorePackage($this) + ".GeneratedApiFactory";
        }

        private static Path getZipFile(DeployableProject $this) {
            Path path = $this.getZipBuildDir().resolve(DefaultImpls.getZipName($this));
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"zipBuildDir.resolve(zipName)");
            return path;
        }

        private static String getZipName(DeployableProject $this) {
            return $this.getVersion() == null ? $this.getName() + "-dist.zip" : $this.getName() + '-' + $this.getVersion() + "-dist.zip";
        }

        /*
         * WARNING - void declaration
         */
        private static AwsProfile profile(DeployableProject $this) {
            AwsProfile awsProfile;
            String awsProfile2 = $this.getAwsProfile();
            if (awsProfile2 == null) {
                AwsProfile profile = AwsProfile.Companion.default();
                DeployableProjectKt.access$getLog$p().info("Using default AWS profile, region = {}", (Object)profile.getRegion());
                awsProfile = profile;
            } else {
                void var2_3;
                AwsProfile profile = AwsProfile.Companion.named(awsProfile2);
                DeployableProjectKt.access$getLog$p().info("Using AWS profile named '{}', region = {}", (Object)awsProfile2, (Object)profile.getRegion());
                awsProfile = var2_3;
            }
            return awsProfile;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static ApiFactory<?> createApiFactory(DeployableProject $this, @NotNull ClassLoader parentClassLoader) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)parentClassLoader, (String)"parentClassLoader");
            DeployableProjectKt.access$getLog$p().debug("runtime classpath: {}", $this.getRuntimeClasspath());
            DeployableProjectKt.access$getLog$p().debug("project jar: {}", (Object)$this.getProjectJar());
            Iterable $this$map$iv = $this.getRuntimeClasspath();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Path path = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                URL uRL = it.toUri().toURL();
                collection.add(uRL);
            }
            List classpathJars = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)$this.getProjectJar().toUri().toURL());
            Collection $this$toTypedArray$iv = classpathJars;
            boolean $i$f$toTypedArray = false;
            Collection collection = $this$toTypedArray$iv;
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = collection;
            URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
            if (uRLArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            URL[] uRLArray2 = uRLArray;
            ClassLoader classLoader = parentClassLoader;
            URL[] uRLArray3 = uRLArray2;
            URLClassLoader classLoader2 = new URLClassLoader(uRLArray3, classLoader);
            Class<?> apiFactoryClass = Class.forName(DefaultImpls.getApiFactoryClassName($this), true, classLoader2);
            Object obj = apiFactoryClass.newInstance();
            if (obj == null) {
                throw new TypeCastException("null cannot be cast to non-null type ws.osiris.aws.ApiFactory<*>");
            }
            return (ApiFactory)obj;
        }

        /*
         * WARNING - void declaration
         */
        public static void generateCloudFormation(DeployableProject $this) {
            void codeHash;
            ClassLoader classLoader = $this.getClass().getClassLoader();
            Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"javaClass.classLoader");
            ApiFactory<?> apiFactory = $this.createApiFactory(classLoader);
            Api api = apiFactory.getApi();
            ApplicationConfig appConfig = apiFactory.getConfig();
            String appName = appConfig.getApplicationName();
            String string = appConfig.getCodeBucket();
            if (string == null) {
                string = DeployKt.codeBucketName(appName, $this.getEnvironmentName(), appConfig.getBucketSuffix());
            }
            String codeBucket = string;
            ZipKey zipKey = DefaultImpls.zipS3Key($this, appName);
            String string2 = zipKey.component1();
            String jarKey = zipKey.component2();
            String lambdaHandler = DefaultImpls.getLambdaHandler($this);
            Set<String> templateParams = DefaultImpls.generatedTemplateParameters($this, DefaultImpls.getRootTemplate($this), appName);
            StaticFilesInfo staticFilesInfo2 = DefaultImpls.staticFilesInfo($this, api, $this.getStaticFilesDirectory());
            String staticHash = staticFilesInfo2 != null ? staticFilesInfo2.getHash() : null;
            DefaultImpls.deleteContents($this, DefaultImpls.getCloudFormationGeneratedDir($this));
            Files.createDirectories(DefaultImpls.getCloudFormationGeneratedDir($this), new FileAttribute[0]);
            Templates templates = Templates.Companion.create(api, appConfig, templateParams, lambdaHandler, (String)codeHash, staticHash, codeBucket, jarKey, $this.getEnvironmentName(), appConfig.getBucketSuffix());
            for (CloudFormationFile file : templates.getFiles$osiris_aws_deploy()) {
                file.write(DefaultImpls.getCloudFormationGeneratedDir($this));
            }
            if (!Files.exists(DefaultImpls.getCloudFormationSourceDir($this), new LinkOption[0])) {
                return;
            }
            Files.list(DefaultImpls.getCloudFormationSourceDir($this)).filter(generateCloudFormation.1.INSTANCE).forEach(new Consumer<Path>($this, codeBucket, jarKey){
                final /* synthetic */ DeployableProject this$0;
                final /* synthetic */ String $codeBucket;
                final /* synthetic */ String $jarKey;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void accept(Path file) {
                    Object object;
                    Closeable closeable = new BufferedReader(new FileReader(file.toFile()));
                    boolean bl = false;
                    Object object2 = null;
                    try {
                        BufferedReader it = (BufferedReader)closeable;
                        boolean bl2 = false;
                        object = TextStreamsKt.readText((Reader)it);
                    }
                    catch (Throwable throwable) {
                        object2 = throwable;
                        throw throwable;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
                    }
                    String templateText = object;
                    String string = StringsKt.replace$default((String)StringsKt.replace$default((String)templateText, (String)"${codeS3Bucket}", (String)this.$codeBucket, (boolean)false, (int)4, null), (String)"${codeS3Key}", (String)this.$jarKey, (boolean)false, (int)4, null);
                    String string2 = this.this$0.getEnvironmentName();
                    if (string2 == null) {
                        string2 = "null";
                    }
                    String generatedFile = StringsKt.replace$default((String)string, (String)"${environmentName}", (String)string2, (boolean)false, (int)4, null);
                    Path path = DefaultImpls.access$getCloudFormationGeneratedDir$p(this.this$0);
                    Path path2 = file;
                    Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"file");
                    Path generatedFilePath = path.resolve(path2.getFileName());
                    DeployableProjectKt.access$getLog$p().debug("Copying template from " + file.toAbsolutePath() + " to " + generatedFilePath.toAbsolutePath());
                    object2 = generatedFile;
                    object = Charsets.UTF_8;
                    Path path3 = generatedFilePath;
                    boolean bl3 = false;
                    Object object3 = object2;
                    if (object3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    byte[] byArray = ((String)object3).getBytes((Charset)object);
                    Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                    byte[] byArray2 = byArray;
                    Files.write(path3, byArray2, new OpenOption[0]);
                }
                {
                    this.this$0 = deployableProject;
                    this.$codeBucket = string;
                    this.$jarKey = string2;
                }
            });
        }

        private static void deleteContents(DeployableProject $this, Path dir) {
            if (!Files.exists(dir, new LinkOption[0])) {
                return;
            }
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @NotNull
                public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) {
                    Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                    Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @NotNull
                public FileVisitResult postVisitDirectory(@NotNull Path dir, @Nullable IOException exc) {
                    Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }

        private static ZipKey zipS3Key(DeployableProject $this, String apiName) {
            Path zipPath = $this.getZipBuildDir().resolve(DefaultImpls.getZipName($this));
            Path[] pathArray = new Path[1];
            Path path = zipPath;
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"zipPath");
            pathArray[0] = path;
            String md5Hash2 = DefaultImpls.md5Hash($this, pathArray);
            return new ZipKey(md5Hash2, apiName + '.' + md5Hash2 + ".jar");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static String md5Hash(DeployableProject $this, Path ... files) {
            MessageDigest messageDigest = MessageDigest.getInstance("md5");
            byte[] buffer = new byte[0x100000];
            Function1<InputStream, Unit> $fun$readChunk$1 = new Function1<InputStream, Unit>(buffer, messageDigest){
                final /* synthetic */ byte[] $buffer;
                final /* synthetic */ MessageDigest $messageDigest;

                public final void invoke(@NotNull InputStream stream) {
                    while (true) {
                        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
                        int bytesRead = stream.read(this.$buffer);
                        if (bytesRead == -1) {
                            return;
                        }
                        this.$messageDigest.update(this.$buffer, 0, bytesRead);
                    }
                }
                {
                    this.$buffer = byArray;
                    this.$messageDigest = messageDigest;
                    super(1);
                }
            };
            for (Path file : files) {
                InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"Files.newInputStream(file)");
                Closeable closeable = inputStream;
                int n = 0x100000;
                boolean bl = false;
                closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
                n = 0;
                Throwable throwable = null;
                try {
                    BufferedInputStream it = (BufferedInputStream)closeable;
                    boolean bl2 = false;
                    $fun$readChunk$1.invoke((InputStream)it);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            byte[] digest = messageDigest.digest();
            Intrinsics.checkExpressionValueIsNotNull((Object)digest, (String)"digest");
            return ArraysKt.joinToString$default((byte[])digest, (CharSequence)"", null, null, (int)0, null, (Function1)md5Hash.3.INSTANCE, (int)30, null);
        }

        private static String templateUrl(DeployableProject $this, String templateName, String codeBucket, String region) {
            return "https://" + codeBucket + ".s3." + region + ".amazonaws.com/" + templateName;
        }

        private static Set<String> generatedTemplateParameters(DeployableProject $this, Path rootTemplatePath, String apiName) {
            byte[] templateBytes = Files.readAllBytes(rootTemplatePath);
            Intrinsics.checkExpressionValueIsNotNull((Object)templateBytes, (String)"templateBytes");
            byte[] byArray = templateBytes;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            String templateYaml = new String(byArray, charset);
            return DeployKt.generatedTemplateParameters(templateYaml, apiName);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static Map<String, String> deploy(DeployableProject $this) {
            Map stageUrls;
            void $this$associateTo$iv$iv2;
            String string;
            if (!Files.exists(DefaultImpls.getZipFile($this), new LinkOption[0])) {
                throw (Throwable)new DeployException("Cannot find " + DefaultImpls.getZipName($this));
            }
            ClassLoader classLoader = $this.getClass().getClassLoader();
            Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"javaClass.classLoader");
            ApiFactory<?> apiFactory = $this.createApiFactory(classLoader);
            ApplicationConfig appConfig = apiFactory.getConfig();
            Api api = apiFactory.getApi();
            String appName = appConfig.getApplicationName();
            AwsProfile profile = DefaultImpls.profile($this);
            String string2 = appConfig.getCodeBucket();
            if (string2 == null) {
                string2 = DeployKt.createBucket(profile, DeployKt.codeBucketName(appName, $this.getEnvironmentName(), appConfig.getBucketSuffix()));
            }
            String codeBucket = string2;
            ZipKey zipKey = DefaultImpls.zipS3Key($this, appName);
            String jarKey = zipKey.component2();
            DeployableProjectKt.access$getLog$p().info("Uploading function code '" + DefaultImpls.getZipFile($this) + "' to " + codeBucket + " with key " + jarKey);
            DeployKt.uploadFile(profile, DefaultImpls.getZipFile($this), codeBucket, jarKey);
            DeployableProjectKt.access$getLog$p().info("Upload of function code complete");
            DefaultImpls.uploadTemplates($this, profile, codeBucket);
            if (!Files.exists(DefaultImpls.getRootTemplate($this), new LinkOption[0])) {
                throw (Throwable)new IllegalStateException("core/src/main/cloudformation/root.template is missing");
            }
            String deploymentTemplateUrl = DefaultImpls.templateUrl($this, ((Object)DefaultImpls.getRootTemplate($this).getFileName()).toString(), codeBucket, profile.getRegion());
            String apiName = CloudFormationKt.apiName(appConfig.getApplicationName(), $this.getEnvironmentName());
            String localStackName = $this.getStackName();
            if (localStackName == null) {
                String stackEnvSuffix = $this.getEnvironmentName() == null ? "" : '-' + $this.getEnvironmentName();
                string = appConfig.getApplicationName() + stackEnvSuffix;
            } else {
                string = localStackName;
            }
            String stackName = string;
            DeployResult deployResult = CloudFormationKt.deployStack(profile, stackName, apiName, deploymentTemplateUrl);
            String string3 = appConfig.getStaticFilesBucket();
            if (string3 == null) {
                string3 = DeployKt.staticFilesBucketName(appName, $this.getEnvironmentName(), appConfig.getBucketSuffix());
            }
            String staticBucket = string3;
            DefaultImpls.uploadStaticFiles($this, profile, api, staticBucket, $this.getStaticFilesDirectory());
            String apiId = deployResult.getApiId();
            boolean stackCreated = deployResult.getStackCreated();
            List<String> deployedStages = DeployKt.deployStages(profile, apiId, apiName, appConfig.getStages(), stackCreated);
            Iterable $this$associate$iv = deployedStages;
            boolean $i$f$associate = false;
            int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv2) {
                Map map = destination$iv$iv;
                String it = (String)element$iv$iv;
                boolean bl = false;
                Pair pair = new Pair((Object)it, (Object)DeployableProjectKt.stageUrl(apiId, it, profile.getRegion()));
                boolean bl2 = false;
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map capacity$iv22 = stageUrls = destination$iv$iv;
            boolean $this$associateTo$iv$iv2 = false;
            Iterator iterator = capacity$iv22.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                boolean bl = false;
                String stage = (String)entry2.getKey();
                entry2 = entry;
                bl = false;
                String url = (String)entry2.getValue();
                DeployableProjectKt.access$getLog$p().info("Deployed to stage '" + stage + "' at " + url);
            }
            DefaultImpls.sendKeepAlive($this, deployResult, appConfig.getKeepAliveCount(), appConfig.getKeepAliveSleep(), profile);
            return stageUrls;
        }

        public static void openBrowser(DeployableProject $this, @NotNull String stage, @NotNull String path) {
            Intrinsics.checkParameterIsNotNull((Object)stage, (String)"stage");
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                ClassLoader classLoader = $this.getClass().getClassLoader();
                Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"javaClass.classLoader");
                ApiFactory<?> apiFactory = $this.createApiFactory(classLoader);
                String apiName = CloudFormationKt.apiName(apiFactory.getConfig().getApplicationName(), $this.getEnvironmentName());
                String urlBase = DeployableProjectKt.stageUrl(apiName, stage, DefaultImpls.profile($this));
                String url = urlBase + StringsKt.removePrefix((String)path, (CharSequence)"/");
                DeployableProjectKt.access$getLog$p().debug("Opening path {} of stage {} of API {} in the default browser: {}", new Object[]{path, stage, apiName, url});
                Desktop.getDesktop().browse(new URI(url));
            } else {
                DeployableProjectKt.access$getLog$p().warn("Opening a browser is not supported");
            }
        }

        private static void uploadStaticFiles(DeployableProject $this, AwsProfile profile, Api<?> api, String bucket, String staticFilesDirectory) {
            Object object;
            StaticFilesInfo staticFilesInfo2;
            block6: {
                block5: {
                    StaticFilesInfo staticFilesInfo3 = DefaultImpls.staticFilesInfo($this, api, staticFilesDirectory);
                    if (staticFilesInfo3 == null) {
                        return;
                    }
                    staticFilesInfo2 = staticFilesInfo3;
                    object = staticFilesDirectory;
                    if (object == null) break block5;
                    String string = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string;
                    boolean bl3 = false;
                    object = Paths.get(it, new String[0]);
                    if (object != null) break block6;
                }
                object = $this.getSourceDir().resolve("static");
            }
            Object staticFilesDir = object;
            for (Path file : staticFilesInfo2.getFiles()) {
                Object object2 = staticFilesDir;
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"staticFilesDir");
                DeployKt.uploadFile$default(profile, file, bucket, (Path)object2, null, staticFilesInfo2.getHash(), 16, null);
            }
        }

        private static void uploadTemplates(DeployableProject $this, AwsProfile profile, String codeBucket) {
            if (!Files.exists(DefaultImpls.getCloudFormationGeneratedDir($this), new LinkOption[0])) {
                return;
            }
            Files.list(DefaultImpls.getCloudFormationGeneratedDir($this)).filter(uploadTemplates.1.INSTANCE).forEach(new Consumer<Path>(profile, codeBucket){
                final /* synthetic */ AwsProfile $profile;
                final /* synthetic */ String $codeBucket;

                public final void accept(Path it) {
                    Path path = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"it");
                    DeployKt.uploadFile$default(this.$profile, path, this.$codeBucket, null, 8, null);
                }
                {
                    this.$profile = awsProfile;
                    this.$codeBucket = string;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private static StaticFilesInfo staticFilesInfo(DeployableProject $this, Api<?> api, String staticFilesDirectory) {
            void $this$toTypedArray$iv;
            List staticFiles2;
            Object object;
            block7: {
                block6: {
                    if (!api.getStaticFiles()) {
                        return null;
                    }
                    object = staticFilesDirectory;
                    if (object == null) break block6;
                    String string = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string;
                    boolean bl3 = false;
                    object = Paths.get(it, new String[0]);
                    if (object != null) break block7;
                }
                object = $this.getSourceDir().resolve("static");
            }
            Object staticFilesDir = object;
            List list = staticFiles2 = Files.walk((Path)staticFilesDir, Integer.MAX_VALUE, new FileVisitOption[0]).filter(staticFilesInfo.staticFiles.1.INSTANCE).collect(Collectors.toList());
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"staticFiles");
            Collection collection = list;
            DeployableProject deployableProject = $this;
            boolean $i$f$toTypedArray = false;
            void v2 = $this$toTypedArray$iv;
            if (v2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            void thisCollection$iv = v2;
            Path[] pathArray = thisCollection$iv.toArray(new Path[0]);
            if (pathArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Path[] pathArray2 = pathArray;
            String hash = DefaultImpls.md5Hash(deployableProject, Arrays.copyOf(pathArray2, pathArray2.length));
            return new StaticFilesInfo(staticFiles2, hash);
        }

        private static void sendKeepAlive(DeployableProject $this, DeployResult deployResult, int instanceCount, Duration sleepTimeMs, AwsProfile profile) {
            if (deployResult.getKeepAliveLambdaArn() == null) {
                return;
            }
            DeployableProjectKt.access$getLog$p().info("Invoking keep-alive lambda {}", (Object)deployResult.getKeepAliveLambdaArn());
            Map payloadMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"functionArn", (Object)deployResult.getLambdaVersionArn()), TuplesKt.to((Object)"instanceCount", (Object)instanceCount), TuplesKt.to((Object)"sleepTimeMs", (Object)sleepTimeMs.toMillis())});
            DeployableProjectKt.access$getLog$p().debug("Keep-alive payload: {}", (Object)payloadMap);
            String payloadJson = new Gson().toJson((Object)payloadMap);
            InvokeRequest invokeRequest = new InvokeRequest();
            AWSLambda aWSLambda = profile.getLambdaClient();
            boolean bl = false;
            boolean bl2 = false;
            InvokeRequest $this$apply = invokeRequest;
            boolean bl3 = false;
            $this$apply.setFunctionName(deployResult.getKeepAliveLambdaArn());
            $this$apply.setInvocationType(InvocationType.Event.name());
            String string = payloadJson;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"payloadJson");
            String string2 = string;
            InvokeRequest invokeRequest2 = $this$apply;
            Charset charset = Charsets.UTF_8;
            boolean bl4 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string3.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            invokeRequest2.setPayload(ByteBuffer.wrap(byArray2));
            InvokeRequest invokeRequest3 = invokeRequest;
            aWSLambda.invoke(invokeRequest3);
        }

        public static /* synthetic */ Path access$getCloudFormationGeneratedDir$p(DeployableProject $this) {
            return DefaultImpls.getCloudFormationGeneratedDir($this);
        }
    }
}

