/*
 * Decompiled with CFR 0.152.
 */
package ws.osiris.awsdeploy;

import com.amazonaws.services.apigateway.model.CreateDeploymentRequest;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ws.osiris.aws.ConfigKt;
import ws.osiris.aws.Stage;
import ws.osiris.awsdeploy.AwsProfile;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0004\u001a\"\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0004\u001a\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u0004\u001a:\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f2\u0006\u0010\u0013\u001a\u00020\u0014\u001a&\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0000\u001a\"\u0010\u0018\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0004\u001a>\u0010\u0019\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001b2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u0004\u001a*\u0010\u0019\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u0004\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "bucketName", "", "appName", "envName", "suffix", "prefix", "codeBucketName", "apiName", "createBucket", "profile", "Lws/osiris/awsdeploy/AwsProfile;", "deployStages", "", "apiId", "stages", "Lws/osiris/aws/Stage;", "stackCreated", "", "generatedTemplateParameters", "", "templateYaml", "staticFilesBucketName", "uploadFile", "file", "Ljava/nio/file/Path;", "baseDir", "key", "bucketDir", "osiris-aws-deploy"})
public final class DeployKt {
    private static final Logger log = LoggerFactory.getLogger((String)"ws.osiris.awsdeploy");

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> deployStages(@NotNull AwsProfile profile, @NotNull String apiId, @NotNull String apiName, @NotNull List<Stage> stages, boolean stackCreated) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        Intrinsics.checkParameterIsNotNull((Object)apiId, (String)"apiId");
        Intrinsics.checkParameterIsNotNull((Object)apiName, (String)"apiName");
        Intrinsics.checkParameterIsNotNull(stages, (String)"stages");
        if (stackCreated) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = stages;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Stage stage = (Stage)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getName();
                collection.add(string);
            }
            list = (List)destination$iv$iv;
        } else {
            void $this$mapTo$iv$iv;
            Object object;
            Object object2;
            Stage it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = stages;
            boolean $i$f$filter = false;
            Iterable destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv22 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Stage)element$iv$iv;
                boolean bl = false;
                if (!it.getDeployOnUpdate()) continue;
                destination$iv$iv22.add(element$iv$iv);
            }
            List stagesToDeploy = (List)destination$iv$iv22;
            for (Stage stage : stagesToDeploy) {
                log.debug("Updating REST API '" + apiName + "' in stage '" + stage.getName() + '\'');
                $this$filterTo$iv$iv = new CreateDeploymentRequest();
                object2 = profile.getApiGatewayClient();
                boolean destination$iv$iv22 = false;
                $i$f$filterTo = false;
                Iterable $this$apply = $this$filterTo$iv$iv;
                boolean bl = false;
                $this$apply.setRestApiId(apiId);
                $this$apply.setStageName(stage.getName());
                $this$apply.setVariables(stage.getVariables());
                $this$apply.setDescription(stage.getDescription());
                object = $this$filterTo$iv$iv;
                object2.createDeployment((CreateDeploymentRequest)object);
            }
            Iterable $this$map$iv = stagesToDeploy;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Stage)item$iv$iv;
                object2 = destination$iv$iv3;
                boolean bl = false;
                object = it.getName();
                object2.add(object);
            }
            list = (List)destination$iv$iv3;
        }
        return list;
    }

    @NotNull
    public static final String createBucket(@NotNull AwsProfile profile, @NotNull String bucketName) {
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        Intrinsics.checkParameterIsNotNull((Object)bucketName, (String)"bucketName");
        ConfigKt.validateBucketName((String)bucketName);
        if (!profile.getS3Client().doesBucketExistV2(bucketName)) {
            profile.getS3Client().createBucket(bucketName);
            log.info("Created S3 bucket '" + bucketName + '\'');
        } else {
            log.info("Using existing S3 bucket '" + bucketName + '\'');
        }
        return bucketName;
    }

    @NotNull
    public static final String uploadFile(@NotNull AwsProfile profile, @NotNull Path file, @NotNull String bucketName, @Nullable String key) {
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)bucketName, (String)"bucketName");
        Path path = file.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"file.parent");
        return DeployKt.uploadFile$default(profile, file, bucketName, path, key, null, 32, null);
    }

    @NotNull
    public static /* synthetic */ String uploadFile$default(AwsProfile awsProfile, Path path, String string, String string2, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        return DeployKt.uploadFile(awsProfile, path, string, string2);
    }

    @NotNull
    public static final String uploadFile(@NotNull AwsProfile profile, @NotNull Path file, @NotNull String bucketName, @NotNull Path baseDir, @Nullable String key, @Nullable String bucketDir) {
        String string;
        String uploadKey;
        block5: {
            block4: {
                Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                Intrinsics.checkParameterIsNotNull((Object)bucketName, (String)"bucketName");
                Intrinsics.checkParameterIsNotNull((Object)baseDir, (String)"baseDir");
                String string2 = key;
                if (string2 == null) {
                    string2 = uploadKey = ((Object)baseDir.relativize(file)).toString();
                }
                if ((string = bucketDir) == null) break block4;
                String string3 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                string = bucketDir + '/';
                if (string != null) break block5;
            }
            string = "";
        }
        String dirPart = string;
        String fullKey = dirPart + uploadKey;
        profile.getS3Client().putObject(bucketName, fullKey, file.toFile());
        String url = "https://" + bucketName + ".s3.amazonaws.com/" + fullKey;
        log.debug("Uploaded file {} to S3 bucket {}, URL {}", new Object[]{file, bucketName, url});
        return url;
    }

    @NotNull
    public static /* synthetic */ String uploadFile$default(AwsProfile awsProfile, Path path, String string, Path path2, String string2, String string3, int n, Object object) {
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        if ((n & 0x20) != 0) {
            string3 = null;
        }
        return DeployKt.uploadFile(awsProfile, path, string, path2, string2, string3);
    }

    @NotNull
    public static final String bucketName(@NotNull String appName, @Nullable String envName, @NotNull String suffix, @Nullable String prefix) {
        String string;
        String envPart;
        String string2;
        StringBuilder stringBuilder;
        String string3;
        Intrinsics.checkParameterIsNotNull((Object)appName, (String)"appName");
        Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
        if (envName == null) {
            string3 = "";
        } else {
            String string4 = envName;
            stringBuilder = new StringBuilder();
            boolean bl = false;
            String string5 = string4.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
            string2 = string5;
            string3 = envPart = stringBuilder.append(string2).append('-').toString();
        }
        if (prefix == null) {
            string = "";
        } else {
            String string6 = prefix;
            stringBuilder = new StringBuilder();
            boolean bl = false;
            String string7 = string6.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).toLowerCase()");
            string2 = string7;
            string = stringBuilder.append(string2).append('-').toString();
        }
        String prefixPart = string;
        String string8 = appName;
        boolean bl = false;
        String string9 = string8.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.String).toLowerCase()");
        String appNamePart = string9;
        return prefixPart + appNamePart + '-' + envPart + suffix;
    }

    @NotNull
    public static final String codeBucketName(@NotNull String apiName, @Nullable String envName, @Nullable String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)apiName, (String)"apiName");
        return DeployKt.bucketName(apiName, envName, "code", prefix);
    }

    @NotNull
    public static final String staticFilesBucketName(@NotNull String apiName, @Nullable String envName, @Nullable String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)apiName, (String)"apiName");
        return DeployKt.bucketName(apiName, envName, "staticfiles", prefix);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<String> generatedTemplateParameters(@NotNull String templateYaml, @NotNull String codeBucketName, @NotNull String apiName) {
        Object object;
        block13: {
            block12: {
                Map it;
                Object $this$filterTo$iv$iv;
                Object object2;
                Collection collection;
                Object $this$mapTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)templateYaml, (String)"templateYaml");
                Intrinsics.checkParameterIsNotNull((Object)codeBucketName, (String)"codeBucketName");
                Intrinsics.checkParameterIsNotNull((Object)apiName, (String)"apiName");
                ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
                Map rootTemplateMap = (Map)objectMapper.readValue(templateYaml, Map.class);
                String generatedTemplateUrl = "https://" + codeBucketName + ".s3.amazonaws.com/" + apiName + ".template";
                Map map = rootTemplateMap;
                Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"rootTemplateMap");
                Map map2 = map;
                String string = "Resources";
                boolean bl = false;
                object = (Map)map2.get(string);
                if (object == null) break block12;
                Object $this$map$iv = object;
                boolean $i$f$map = false;
                Map map3 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv;
                boolean bl2 = false;
                Iterator iterator2 = iterator.entrySet().iterator();
                while (iterator2.hasNext()) {
                    void it2;
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = iterator2.next();
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    Object v = it2.getValue();
                    if (v == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                    }
                    object2 = (Map)v;
                    collection.add(object2);
                }
                Iterable $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                iterator = $this$filterTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv = iterator.next();
                    it = (Map)element$iv$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual(it.get("Type"), (Object)"AWS::CloudFormation::Stack")) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object item$iv$iv = iterator.next();
                    it = (Map)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl5 = false;
                    Object v = it.get("Properties");
                    if (v == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                    }
                    object2 = (Map)v;
                    collection.add(object2);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                iterator = $this$filterTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv = iterator.next();
                    it = (Map)element$iv$iv;
                    boolean bl6 = false;
                    if (!Intrinsics.areEqual(it.get("TemplateURL"), (Object)generatedTemplateUrl)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object item$iv$iv = iterator.next();
                    it = (Map)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl7 = false;
                    Object v = it.get("Parameters");
                    if (v == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
                    }
                    object2 = (Map)v;
                    collection.add(object2);
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object item$iv$iv = iterator.next();
                    it = (Map)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl8 = false;
                    object2 = it.keySet();
                    collection.add(object2);
                }
                object = (Set)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
                if (object != null) break block13;
            }
            boolean bl = false;
            object = SetsKt.emptySet();
        }
        Object parameters = object;
        return SetsKt.minus((Set)SetsKt.minus((Set)parameters, (Object)"LambdaRole"), (Object)"CustomAuthArn");
    }
}

