/*
 * Decompiled with CFR 0.152.
 */
package ws.osiris.awsdeploy.cloudformation;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import ws.osiris.awsdeploy.cloudformation.CloudFormationFile;
import ws.osiris.awsdeploy.cloudformation.CloudFormationKt;
import ws.osiris.awsdeploy.cloudformation.ResourceTemplate;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lws/osiris/awsdeploy/cloudformation/RestCloudFormationFile;", "Lws/osiris/awsdeploy/cloudformation/CloudFormationFile;", "fileName", "", "templates", "", "Lws/osiris/awsdeploy/cloudformation/ResourceTemplate;", "(Ljava/lang/String;Ljava/util/List;)V", "write", "", "templatesDir", "Ljava/nio/file/Path;", "osiris-aws-deploy"})
public final class RestCloudFormationFile
implements CloudFormationFile {
    private final String fileName;
    private final List<ResourceTemplate> templates;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(@NotNull Path templatesDir) {
        Intrinsics.checkParameterIsNotNull((Object)templatesDir, (String)"templatesDir");
        Path filePath = templatesDir.resolve(this.fileName);
        Closeable closeable = Files.newBufferedWriter(filePath, StandardOpenOption.CREATE);
        Throwable throwable = null;
        try {
            BufferedWriter writer = (BufferedWriter)closeable;
            CloudFormationKt.access$getLog$p().info("Writing CloudFormation template {}", (Object)filePath.toAbsolutePath());
            String header = StringsKt.trimIndent((String)"\n                Parameters:\n                  Api:\n                    Type: String\n                    Description: ID of the API Gateway API\n                  ParentResourceId:\n                    Type: String\n                    Description: ID of the API Gateway resource\n                  LambdaArn:\n                    Type: String\n                    Description: ARN of the lambda function version\n                Resources:\n            ");
            writer.write(header);
            writer.write("\n");
            for (ResourceTemplate template : this.templates) {
                CloudFormationKt.access$getLog$p().debug("Writing resource template with path part {}", (Object)template.getPathPart$osiris_aws_deploy());
                BufferedWriter bufferedWriter = writer;
                Intrinsics.checkExpressionValueIsNotNull((Object)bufferedWriter, (String)"writer");
                template.write(bufferedWriter, "!Ref ParentResourceId", "LambdaArn");
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public RestCloudFormationFile(@NotNull String fileName, @NotNull List<ResourceTemplate> templates) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull(templates, (String)"templates");
        this.fileName = fileName;
        this.templates = templates;
    }
}

