/*
 * Decompiled with CFR 0.152.
 */
package ws.osiris.awsdeploy.cloudformation;

import com.amazonaws.services.apigateway.AmazonApiGateway;
import com.amazonaws.services.apigateway.AmazonApiGatewayClientBuilder;
import com.amazonaws.services.apigateway.model.GetRestApisRequest;
import com.amazonaws.services.apigateway.model.GetRestApisResult;
import com.amazonaws.services.apigateway.model.RestApi;
import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.AmazonCloudFormationClientBuilder;
import com.amazonaws.services.cloudformation.model.CreateStackRequest;
import com.amazonaws.services.cloudformation.model.CreateStackResult;
import com.amazonaws.services.cloudformation.model.DeleteStackRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackResourceRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackResourceResult;
import com.amazonaws.services.cloudformation.model.DescribeStacksRequest;
import com.amazonaws.services.cloudformation.model.DescribeStacksResult;
import com.amazonaws.services.cloudformation.model.ListStacksResult;
import com.amazonaws.services.cloudformation.model.Output;
import com.amazonaws.services.cloudformation.model.Stack;
import com.amazonaws.services.cloudformation.model.StackResourceDetail;
import com.amazonaws.services.cloudformation.model.StackStatus;
import com.amazonaws.services.cloudformation.model.StackSummary;
import com.amazonaws.services.cloudformation.model.UpdateStackRequest;
import com.amazonaws.services.cloudformation.model.UpdateStackResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ws.osiris.awsdeploy.AwsProfile;
import ws.osiris.awsdeploy.cloudformation.DeployResult;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0018\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0001H\u0002\u001a\"\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a&\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0001\u001a\"\u0010\u001a\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"CAPABILITY_IAM", "", "createStatuses", "", "Lcom/amazonaws/services/cloudformation/model/StackStatus;", "deleteStatuses", "deployedStatuses", "failedStatuses", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "successStatuses", "updateStatuses", "apiId", "profile", "Lws/osiris/awsdeploy/AwsProfile;", "apiName", "createStack", "cloudFormationClient", "Lcom/amazonaws/services/cloudformation/AmazonCloudFormation;", "templateUrl", "deleteStack", "", "deployStack", "Lws/osiris/awsdeploy/cloudformation/DeployResult;", "stackName", "updateStack", "waitForStack", "stackId", "osiris-aws-deploy"})
public final class CloudFormationKt {
    private static final Logger log = LoggerFactory.getLogger((String)"ws.osiris.aws.cloudformation");
    private static final String CAPABILITY_IAM = "CAPABILITY_IAM";
    private static final Set<StackStatus> updateStatuses = SetsKt.setOf((Object[])new StackStatus[]{StackStatus.CREATE_COMPLETE, StackStatus.UPDATE_COMPLETE, StackStatus.UPDATE_COMPLETE_CLEANUP_IN_PROGRESS, StackStatus.UPDATE_ROLLBACK_COMPLETE, StackStatus.UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS});
    private static final Set<StackStatus> createStatuses = SetsKt.setOf((Object[])new StackStatus[]{StackStatus.CREATE_FAILED, StackStatus.DELETE_COMPLETE});
    private static final Set<StackStatus> deleteStatuses = SetsKt.setOf((Object)StackStatus.ROLLBACK_COMPLETE);
    private static final Set<StackStatus> deployedStatuses = SetsKt.setOf((Object[])new StackStatus[]{StackStatus.CREATE_COMPLETE, StackStatus.UPDATE_COMPLETE});
    private static final Set<StackStatus> successStatuses = SetsKt.setOf((Object[])new StackStatus[]{StackStatus.CREATE_COMPLETE, StackStatus.DELETE_COMPLETE, StackStatus.UPDATE_COMPLETE});
    private static final Set<StackStatus> failedStatuses = SetsKt.setOf((Object[])new StackStatus[]{StackStatus.CREATE_FAILED, StackStatus.ROLLBACK_IN_PROGRESS, StackStatus.ROLLBACK_FAILED, StackStatus.DELETE_FAILED, StackStatus.ROLLBACK_COMPLETE, StackStatus.UPDATE_ROLLBACK_IN_PROGRESS, StackStatus.UPDATE_ROLLBACK_FAILED, StackStatus.UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS, StackStatus.UPDATE_ROLLBACK_COMPLETE});

    @NotNull
    public static final DeployResult deployStack(@NotNull AwsProfile profile, @NotNull String stackName, @NotNull String apiName, @NotNull String templateUrl) {
        Object v19;
        String keepAliveLambdaArn;
        Stack stack;
        boolean created;
        block16: {
            Object v15;
            Object object2;
            Iterable $i$a$1$filter;
            block15: {
                Iterable $i$a$1$apply;
                DescribeStacksResult describeResult;
                StackSummary stackSummary;
                Pair pair;
                Pair $receiver$iv$iv;
                Iterable $receiver$iv;
                List stackSummaries;
                Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
                Intrinsics.checkParameterIsNotNull((Object)stackName, (String)"stackName");
                Intrinsics.checkParameterIsNotNull((Object)apiName, (String)"apiName");
                Intrinsics.checkParameterIsNotNull((Object)templateUrl, (String)"templateUrl");
                log.debug("Deploying stack to region {} using template {}", (Object)profile.getRegion(), (Object)templateUrl);
                AmazonCloudFormation cloudFormationClient = (AmazonCloudFormation)((AmazonCloudFormationClientBuilder)((AmazonCloudFormationClientBuilder)AmazonCloudFormationClientBuilder.standard().withCredentials(profile.getCredentialsProvider())).withRegion(profile.getRegion())).build();
                ListStacksResult listStacksResult = cloudFormationClient.listStacks();
                Intrinsics.checkExpressionValueIsNotNull((Object)listStacksResult, (String)"cloudFormationClient.listStacks()");
                List list = stackSummaries = listStacksResult.getStackSummaries();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"stackSummaries");
                Iterable iterable = $receiver$iv = (Iterable)list;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    StackSummary it;
                    StackSummary stackSummary2 = it = (StackSummary)element$iv$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)stackSummary2, (String)"it");
                    if (!(Intrinsics.areEqual((Object)stackSummary2.getStackName(), (Object)stackName) && Intrinsics.areEqual((Object)it.getStackStatus(), (Object)"DELETE_COMPLETE") ^ true)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List liveStacks = (List)destination$iv$iv;
                if (liveStacks.isEmpty()) {
                    AmazonCloudFormation amazonCloudFormation = cloudFormationClient;
                    Intrinsics.checkExpressionValueIsNotNull((Object)amazonCloudFormation, (String)"cloudFormationClient");
                    String stackId = CloudFormationKt.createStack(stackName, amazonCloudFormation, templateUrl);
                    pair = new Pair((Object)stackId, (Object)true);
                } else {
                    String stackId;
                    if (liveStacks.size() > 1) {
                        throw (Throwable)new IllegalStateException("Found multiple stacks named '" + stackName + "': " + liveStacks);
                    }
                    StackSummary stackSummary3 = stackSummary = (StackSummary)liveStacks.get(0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)stackSummary3, (String)"stackSummary");
                    StackStatus status = StackStatus.fromValue((String)stackSummary3.getStackStatus());
                    if (deleteStatuses.contains(status)) {
                        AmazonCloudFormation amazonCloudFormation = cloudFormationClient;
                        Intrinsics.checkExpressionValueIsNotNull((Object)amazonCloudFormation, (String)"cloudFormationClient");
                        CloudFormationKt.deleteStack(stackName, amazonCloudFormation);
                        stackId = CloudFormationKt.createStack(stackName, cloudFormationClient, templateUrl);
                        pair = new Pair((Object)stackId, (Object)true);
                    } else if (updateStatuses.contains(status)) {
                        AmazonCloudFormation amazonCloudFormation = cloudFormationClient;
                        Intrinsics.checkExpressionValueIsNotNull((Object)amazonCloudFormation, (String)"cloudFormationClient");
                        stackId = CloudFormationKt.updateStack(stackName, amazonCloudFormation, templateUrl);
                        pair = new Pair((Object)stackId, (Object)false);
                    } else if (createStatuses.contains(status)) {
                        AmazonCloudFormation amazonCloudFormation = cloudFormationClient;
                        Intrinsics.checkExpressionValueIsNotNull((Object)amazonCloudFormation, (String)"cloudFormationClient");
                        stackId = CloudFormationKt.createStack(stackName, amazonCloudFormation, templateUrl);
                        pair = new Pair((Object)stackId, (Object)true);
                    } else {
                        throw (Throwable)new IllegalStateException("Unable to deploy stack '" + stackName + "' with status " + stackSummary.getStackStatus());
                    }
                }
                $receiver$iv$iv = pair;
                created = (Boolean)$receiver$iv$iv.component2();
                stackSummary = new DescribeStackResourceRequest();
                AmazonCloudFormation amazonCloudFormation = cloudFormationClient;
                StackSummary $receiver = stackSummary;
                $receiver.setStackName(stackName);
                $receiver.setLogicalResourceId("ApiStack");
                StackSummary stackSummary4 = stackSummary;
                DescribeStackResourceResult apiStackResourceResult = amazonCloudFormation.describeStackResource((DescribeStackResourceRequest)stackSummary4);
                $receiver = new DescribeStacksRequest();
                amazonCloudFormation = cloudFormationClient;
                StackSummary $receiver2 = $receiver;
                DescribeStackResourceResult describeStackResourceResult = apiStackResourceResult;
                Intrinsics.checkExpressionValueIsNotNull((Object)describeStackResourceResult, (String)"apiStackResourceResult");
                StackResourceDetail stackResourceDetail = describeStackResourceResult.getStackResourceDetail();
                Intrinsics.checkExpressionValueIsNotNull((Object)stackResourceDetail, (String)"apiStackResourceResult.stackResourceDetail");
                $receiver2.setStackName(stackResourceDetail.getPhysicalResourceId());
                stackSummary4 = $receiver;
                DescribeStacksResult describeStacksResult = describeResult = amazonCloudFormation.describeStacks((DescribeStacksRequest)stackSummary4);
                Intrinsics.checkExpressionValueIsNotNull((Object)describeStacksResult, (String)"describeResult");
                if (describeStacksResult.getStacks().size() != 1) {
                    throw (Throwable)new IllegalStateException("Multiple stacks found: " + describeResult.getStacks());
                }
                Stack stack2 = stack = (Stack)describeResult.getStacks().get(0);
                Intrinsics.checkExpressionValueIsNotNull((Object)stack2, (String)"stack");
                List list2 = stack2.getOutputs();
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"stack.outputs");
                $i$a$1$filter = $i$a$1$apply = (Iterable)list2;
                for (Object object2 : $i$a$1$filter) {
                    Output it;
                    Output output = it = (Output)object2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)output, (String)"it");
                    if (!Intrinsics.areEqual((Object)output.getOutputKey(), (Object)"KeepAliveLambdaArn")) continue;
                    v15 = object2;
                    break block15;
                }
                v15 = null;
            }
            Output output = v15;
            keepAliveLambdaArn = output != null ? output.getOutputValue() : null;
            List list = stack.getOutputs();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"stack.outputs");
            $i$a$1$filter = list;
            Iterable iterable = $i$a$1$filter;
            object2 = iterable.iterator();
            while (object2.hasNext()) {
                Output it;
                Object e = object2.next();
                Output output2 = it = (Output)e;
                Intrinsics.checkExpressionValueIsNotNull((Object)output2, (String)"it");
                if (!Intrinsics.areEqual((Object)output2.getOutputKey(), (Object)"LambdaVersionArn")) continue;
                v19 = e;
                break block16;
            }
            v19 = null;
        }
        Output output = v19;
        String string = output != null ? output.getOutputValue() : null;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String lambdaVersionArn = string;
        StackStatus status = StackStatus.fromValue((String)stack.getStackStatus());
        if (!deployedStatuses.contains(status)) {
            throw (Throwable)new IllegalStateException("Stack status is " + stack.getStackStatus());
        }
        return new DeployResult(created, CloudFormationKt.apiId(profile, apiName), lambdaVersionArn, keepAliveLambdaArn);
    }

    private static final String apiId(AwsProfile profile, String apiName) {
        Object object;
        Object v3;
        block2: {
            Iterable iterable;
            AmazonApiGateway apiGatewayClient = (AmazonApiGateway)((AmazonApiGatewayClientBuilder)((AmazonApiGatewayClientBuilder)AmazonApiGatewayClientBuilder.standard().withCredentials(profile.getCredentialsProvider())).withRegion(profile.getRegion())).build();
            GetRestApisResult getRestApisResult = apiGatewayClient.getRestApis(new GetRestApisRequest());
            Intrinsics.checkExpressionValueIsNotNull((Object)getRestApisResult, (String)"apiGatewayClient.getRestApis(GetRestApisRequest())");
            List list = getRestApisResult.getItems();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"apiGatewayClient.getRest\u2026tRestApisRequest()).items");
            Iterable iterable2 = iterable = (Iterable)list;
            for (Object t : iterable2) {
                RestApi it;
                RestApi restApi = it = (RestApi)t;
                Intrinsics.checkExpressionValueIsNotNull((Object)restApi, (String)"it");
                if (!Intrinsics.areEqual((Object)restApi.getName(), (Object)apiName)) continue;
                v3 = t;
                break block2;
            }
            v3 = null;
        }
        if ((object = (RestApi)v3) == null || (object = object.getId()) == null) {
            throw (Throwable)new IllegalStateException("No API found with name '" + apiName + '\'');
        }
        return object;
    }

    private static final void deleteStack(String apiName, AmazonCloudFormation cloudFormationClient) {
        DescribeStacksResult describeResult;
        log.info("Deleting stack '" + apiName + '\'');
        DescribeStacksRequest describeStacksRequest = new DescribeStacksRequest();
        AmazonCloudFormation amazonCloudFormation = cloudFormationClient;
        DescribeStacksRequest $receiver = describeStacksRequest;
        $receiver.setStackName(apiName);
        DescribeStacksRequest describeStacksRequest2 = describeStacksRequest;
        DescribeStacksResult describeStacksResult = describeResult = amazonCloudFormation.describeStacks(describeStacksRequest2);
        Intrinsics.checkExpressionValueIsNotNull((Object)describeStacksResult, (String)"describeResult");
        Object e = describeStacksResult.getStacks().get(0);
        Intrinsics.checkExpressionValueIsNotNull(e, (String)"describeResult.stacks[0]");
        String stackId = ((Stack)e).getStackId();
        DeleteStackRequest deleteStackRequest = new DeleteStackRequest();
        amazonCloudFormation = cloudFormationClient;
        DeleteStackRequest $receiver2 = deleteStackRequest;
        $receiver2.setStackName(apiName);
        describeStacksRequest2 = deleteStackRequest;
        amazonCloudFormation.deleteStack((DeleteStackRequest)describeStacksRequest2);
        String string = stackId;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"stackId");
        CloudFormationKt.waitForStack(string, cloudFormationClient);
        log.info("Deleted stack '" + apiName + '\'');
    }

    private static final String updateStack(String apiName, AmazonCloudFormation cloudFormationClient, String templateUrl) {
        UpdateStackResult updateResult;
        log.info("Updating stack '{}'", (Object)apiName);
        UpdateStackRequest updateStackRequest = new UpdateStackRequest();
        AmazonCloudFormation amazonCloudFormation = cloudFormationClient;
        UpdateStackRequest $receiver = updateStackRequest;
        $receiver.setStackName(apiName);
        $receiver.setTemplateURL(templateUrl);
        $receiver.setCapabilities((Collection)CollectionsKt.listOf((Object)CAPABILITY_IAM));
        UpdateStackRequest updateStackRequest2 = updateStackRequest;
        UpdateStackResult updateStackResult = updateResult = amazonCloudFormation.updateStack(updateStackRequest2);
        Intrinsics.checkExpressionValueIsNotNull((Object)updateStackResult, (String)"updateResult");
        String string = updateStackResult.getStackId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"updateResult.stackId");
        CloudFormationKt.waitForStack(string, cloudFormationClient);
        log.info("Stack updated. ID = " + updateResult.getStackId());
        return updateResult.getStackId();
    }

    private static final String createStack(String apiName, AmazonCloudFormation cloudFormationClient, String templateUrl) {
        CreateStackResult createResult;
        log.info("Creating stack '{}'", (Object)apiName);
        CreateStackRequest createStackRequest = new CreateStackRequest();
        AmazonCloudFormation amazonCloudFormation = cloudFormationClient;
        CreateStackRequest $receiver = createStackRequest;
        $receiver.setStackName(apiName);
        $receiver.setTemplateURL(templateUrl);
        $receiver.setCapabilities((Collection)CollectionsKt.listOf((Object)CAPABILITY_IAM));
        CreateStackRequest createStackRequest2 = createStackRequest;
        CreateStackResult createStackResult = createResult = amazonCloudFormation.createStack(createStackRequest2);
        Intrinsics.checkExpressionValueIsNotNull((Object)createStackResult, (String)"createResult");
        String string = createStackResult.getStackId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"createResult.stackId");
        CloudFormationKt.waitForStack(string, cloudFormationClient);
        log.info("Stack created. ID = " + createResult.getStackId());
        return createResult.getStackId();
    }

    private static final void waitForStack(String stackId, AmazonCloudFormation cloudFormationClient) {
        Function1<Integer, Unit> waitForStack$ = new Function1<Integer, Unit>(cloudFormationClient, stackId){
            final /* synthetic */ AmazonCloudFormation $cloudFormationClient;
            final /* synthetic */ String $stackId;

            /*
             * WARNING - void declaration
             */
            public final void invoke(int count) {
                while (true) {
                    StackSummary stackSummary;
                    void $receiver$iv$iv;
                    Iterable $receiver$iv;
                    ListStacksResult listStacksResult = this.$cloudFormationClient.listStacks();
                    Intrinsics.checkExpressionValueIsNotNull((Object)listStacksResult, (String)"cloudFormationClient.listStacks()");
                    List list = listStacksResult.getStackSummaries();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"cloudFormationClient.listStacks().stackSummaries");
                    Iterable iterable = $receiver$iv = (Iterable)list;
                    Collection destination$iv$iv = new ArrayList<E>();
                    for (T element$iv$iv : $receiver$iv$iv) {
                        StackSummary it;
                        StackSummary stackSummary2 = it = (StackSummary)element$iv$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)stackSummary2, (String)"it");
                        if (!Intrinsics.areEqual((Object)stackSummary2.getStackId(), (Object)this.$stackId)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    StackSummary stackSummary3 = stackSummary = (StackSummary)((List)destination$iv$iv).get(0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)stackSummary3, (String)"stackSummary");
                    StackStatus status = StackStatus.fromValue((String)stackSummary3.getStackStatus());
                    if (CloudFormationKt.access$getSuccessStatuses$p().contains(status)) {
                        CloudFormationKt.access$getLog$p().debug("Stack status " + status + ", returning");
                        return;
                    }
                    if (CloudFormationKt.access$getFailedStatuses$p().contains(status)) {
                        throw (Throwable)new IllegalStateException("Deployment failed, stack status: " + status);
                    }
                    CloudFormationKt.access$getLog$p().debug("Stack status " + status + ", waiting");
                    if (count % 5 == 0) {
                        CloudFormationKt.access$getLog$p().info("Waiting for stack to deploy...");
                    }
                    Thread.sleep(1000L);
                    ++count;
                }
            }
            {
                this.$cloudFormationClient = amazonCloudFormation;
                this.$stackId = string;
                super(1);
            }
        };
        waitForStack$.invoke(1);
    }

    public static final /* synthetic */ Logger access$getLog$p() {
        return log;
    }

    @NotNull
    public static final /* synthetic */ Set access$getSuccessStatuses$p() {
        return successStatuses;
    }

    @NotNull
    public static final /* synthetic */ Set access$getFailedStatuses$p() {
        return failedStatuses;
    }
}

