/*
 * Decompiled with CFR 0.152.
 */
package ws.osiris.awsdeploy.cloudformation;

import com.google.common.hash.Hashing;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ws.osiris.awsdeploy.cloudformation.ApiTemplate;
import ws.osiris.awsdeploy.cloudformation.LambdaMethodTemplate;
import ws.osiris.awsdeploy.cloudformation.MethodTemplate;
import ws.osiris.awsdeploy.cloudformation.ResourceTemplate;
import ws.osiris.awsdeploy.cloudformation.StaticIndexFileMethodTemplate;
import ws.osiris.awsdeploy.cloudformation.StaticRootMethodTemplate;
import ws.osiris.awsdeploy.cloudformation.Template;
import ws.osiris.awsdeploy.cloudformation.TemplatesKt;
import ws.osiris.core.Api;
import ws.osiris.core.Auth;
import ws.osiris.core.FixedRouteNode;
import ws.osiris.core.HttpMethod;
import ws.osiris.core.RouteNode;
import ws.osiris.core.StaticRouteNode;
import ws.osiris.core.VariableRouteNode;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\b\u0018\u0000 \"2\u00020\u0001:\u0001\"B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0011\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u0012J\t\u0010\u0013\u001a\u00020\u0005H\u00c2\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u00c2\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u00c2\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u00c2\u0003JE\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\fH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006#"}, d2={"Lws/osiris/awsdeploy/cloudformation/ApiTemplate;", "Lws/osiris/awsdeploy/cloudformation/Template;", "rootResource", "Lws/osiris/awsdeploy/cloudformation/ResourceTemplate;", "name", "", "description", "envName", "binaryMimeTypes", "", "(Lws/osiris/awsdeploy/cloudformation/ResourceTemplate;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;)V", "resourceCount", "", "getResourceCount", "()I", "getRootResource$osiris_aws_deploy", "()Lws/osiris/awsdeploy/cloudformation/ResourceTemplate;", "component1", "component1$osiris_aws_deploy", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "toString", "write", "", "writer", "Ljava/io/Writer;", "Companion", "osiris-aws-deploy"})
public final class ApiTemplate
implements Template {
    private final int resourceCount = 1;
    @NotNull
    private final ResourceTemplate rootResource;
    private final String name;
    private final String description;
    private final String envName;
    private final Set<String> binaryMimeTypes;
    public static final Companion Companion = new Companion(null);

    @Override
    public int getResourceCount() {
        return this.resourceCount;
    }

    @Override
    public void write(@NotNull Writer writer) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        String name = this.envName == null ? this.name : this.name + '.' + this.envName;
        String binaryTypes2 = CollectionsKt.joinToString$default((Iterable)this.binaryMimeTypes, (CharSequence)",", (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)write.binaryTypes.1.INSTANCE, (int)24, null);
        StringBuilder stringBuilder = new StringBuilder().append("\n        |\n        |  Api:\n        |    Type: AWS::ApiGateway::RestApi\n        |    Properties:\n        |      Name: \"").append(name).append("\"\n        |      Description: \"");
        String string = this.description;
        if (string == null) {
            string = name;
        }
        String template = StringsKt.trimMargin$default((String)stringBuilder.append(string).append("\"\n        |      FailOnWarnings: true\n        |      BinaryMediaTypes: ").append(binaryTypes2).append('\n').toString(), null, (int)1, null);
        writer.write(template);
        this.rootResource.write(writer, "!GetAtt Api.RootResourceId", "LambdaVersion.FunctionArn");
    }

    @NotNull
    public final ResourceTemplate getRootResource$osiris_aws_deploy() {
        return this.rootResource;
    }

    public ApiTemplate(@NotNull ResourceTemplate rootResource, @NotNull String name, @Nullable String description, @Nullable String envName, @NotNull Set<String> binaryMimeTypes) {
        Intrinsics.checkParameterIsNotNull((Object)rootResource, (String)"rootResource");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(binaryMimeTypes, (String)"binaryMimeTypes");
        this.rootResource = rootResource;
        this.name = name;
        this.description = description;
        this.envName = envName;
        this.binaryMimeTypes = binaryMimeTypes;
        this.resourceCount = 1;
    }

    @NotNull
    public final ResourceTemplate component1$osiris_aws_deploy() {
        return this.rootResource;
    }

    private final String component2() {
        return this.name;
    }

    private final String component3() {
        return this.description;
    }

    private final String component4() {
        return this.envName;
    }

    private final Set<String> component5() {
        return this.binaryMimeTypes;
    }

    @NotNull
    public final ApiTemplate copy(@NotNull ResourceTemplate rootResource, @NotNull String name, @Nullable String description, @Nullable String envName, @NotNull Set<String> binaryMimeTypes) {
        Intrinsics.checkParameterIsNotNull((Object)rootResource, (String)"rootResource");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(binaryMimeTypes, (String)"binaryMimeTypes");
        return new ApiTemplate(rootResource, name, description, envName, binaryMimeTypes);
    }

    @NotNull
    public static /* synthetic */ ApiTemplate copy$default(ApiTemplate apiTemplate, ResourceTemplate resourceTemplate, String string, String string2, String string3, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            resourceTemplate = apiTemplate.rootResource;
        }
        if ((n & 2) != 0) {
            string = apiTemplate.name;
        }
        if ((n & 4) != 0) {
            string2 = apiTemplate.description;
        }
        if ((n & 8) != 0) {
            string3 = apiTemplate.envName;
        }
        if ((n & 0x10) != 0) {
            set = apiTemplate.binaryMimeTypes;
        }
        return apiTemplate.copy(resourceTemplate, string, string2, string3, set);
    }

    @NotNull
    public String toString() {
        return "ApiTemplate(rootResource=" + this.rootResource + ", name=" + this.name + ", description=" + this.description + ", envName=" + this.envName + ", binaryMimeTypes=" + this.binaryMimeTypes + ")";
    }

    public int hashCode() {
        ResourceTemplate resourceTemplate = this.rootResource;
        String string = this.name;
        String string2 = this.description;
        String string3 = this.envName;
        Set<String> set = this.binaryMimeTypes;
        return ((((resourceTemplate != null ? ((Object)resourceTemplate).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (set != null ? ((Object)set).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ApiTemplate)) break block3;
                ApiTemplate apiTemplate = (ApiTemplate)object;
                if (!Intrinsics.areEqual((Object)this.rootResource, (Object)apiTemplate.rootResource) || !Intrinsics.areEqual((Object)this.name, (Object)apiTemplate.name) || !Intrinsics.areEqual((Object)this.description, (Object)apiTemplate.description) || !Intrinsics.areEqual((Object)this.envName, (Object)apiTemplate.envName) || !Intrinsics.areEqual(this.binaryMimeTypes, apiTemplate.binaryMimeTypes)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JP\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eJ6\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\bH\u0002J>\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00102\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\bH\u0002J*\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00102\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\bH\u0002J>\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u00102\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\bH\u0002J8\u0010\u001e\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\bH\u0002J6\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\bH\u0002J6\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\bH\u0002\u00a8\u0006#"}, d2={"Lws/osiris/awsdeploy/cloudformation/ApiTemplate$Companion;", "", "()V", "create", "Lws/osiris/awsdeploy/cloudformation/ApiTemplate;", "api", "Lws/osiris/core/Api;", "name", "", "description", "envName", "staticFilesBucket", "staticHash", "binaryMimeTypes", "", "fixedChildResourceTemplates", "", "Lws/osiris/awsdeploy/cloudformation/ResourceTemplate;", "node", "Lws/osiris/core/RouteNode;", "parentPath", "indexFileMethodTemplates", "Lws/osiris/awsdeploy/cloudformation/MethodTemplate;", "Lws/osiris/core/StaticRouteNode;", "resourceName", "resourceRef", "lambdaMethodTemplates", "Lws/osiris/awsdeploy/cloudformation/LambdaMethodTemplate;", "methodTemplates", "path", "resourceTemplate", "isRoot", "", "staticProxyResourceTemplates", "variableChildResourceTemplates", "osiris-aws-deploy"})
    public static final class Companion {
        @NotNull
        public final ApiTemplate create(@NotNull Api<?> api, @NotNull String name, @Nullable String description, @Nullable String envName, @Nullable String staticFilesBucket, @Nullable String staticHash, @NotNull Set<String> binaryMimeTypes) {
            Intrinsics.checkParameterIsNotNull(api, (String)"api");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull(binaryMimeTypes, (String)"binaryMimeTypes");
            RouteNode rootNode = RouteNode.Companion.create(api);
            ResourceTemplate rootTemplate = this.resourceTemplate(rootNode, staticFilesBucket, staticHash, true, "");
            return new ApiTemplate(rootTemplate, name, description, envName, binaryMimeTypes);
        }

        private final ResourceTemplate resourceTemplate(RouteNode<?> node, String staticFilesBucket, String staticHash, boolean isRoot, String parentPath) {
            RouteNode<?> routeNode = node;
            String pathPart = routeNode instanceof VariableRouteNode ? '{' + node.getName() + '}' : node.getName();
            String path = parentPath + '/' + pathPart;
            String resourceName = this.resourceName(path);
            String resourceRef = isRoot ? "!GetAtt Api.RootResourceId" : "!Ref " + resourceName;
            List<MethodTemplate> methods = this.methodTemplates(node, resourceName, resourceRef, staticFilesBucket, staticHash);
            List<ResourceTemplate> fixedChildTemplates = this.fixedChildResourceTemplates(node, staticFilesBucket, staticHash, path);
            List<ResourceTemplate> staticProxyTemplates = this.staticProxyResourceTemplates(node, staticFilesBucket, staticHash, path);
            List<ResourceTemplate> variableChildTemplates = this.variableChildResourceTemplates(node, staticFilesBucket, staticHash, path);
            List childResourceTemplates = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)fixedChildTemplates, (Iterable)variableChildTemplates), (Iterable)staticProxyTemplates);
            return new ResourceTemplate(methods, childResourceTemplates, pathPart, resourceName, isRoot);
        }

        /*
         * WARNING - void declaration
         */
        private final List<ResourceTemplate> fixedChildResourceTemplates(RouteNode<?> node, String staticFilesBucket, String staticHash, String parentPath) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)node.getFixedChildren().values();
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                RouteNode routeNode = (RouteNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                ResourceTemplate resourceTemplate = Companion.resourceTemplate((RouteNode<?>)it, staticFilesBucket, staticHash, false, parentPath);
                collection.add(resourceTemplate);
            }
            return (List)destination$iv$iv;
        }

        private final List<ResourceTemplate> variableChildResourceTemplates(RouteNode<?> node, String staticFilesBucket, String staticHash, String parentPath) {
            VariableRouteNode variableChild = node.getVariableChild();
            return variableChild == null ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)this.resourceTemplate((RouteNode)variableChild, staticFilesBucket, staticHash, false, parentPath));
        }

        private final List<ResourceTemplate> staticProxyResourceTemplates(RouteNode<?> node, String staticFilesBucket, String staticHash, String parentPath) {
            List list;
            if (node instanceof StaticRouteNode) {
                List proxyChildren;
                if (staticFilesBucket == null) {
                    throw (Throwable)new IllegalStateException("Index file specified with no static files bucket");
                }
                TemplatesKt.access$getLog$p().debug("Creating static root template with hash {}, bucket {}", (Object)staticHash, (Object)staticFilesBucket);
                String pathPart = "{proxy+}";
                String path = parentPath + '/' + pathPart;
                String proxyChildName = this.resourceName(path);
                String proxyChildRef = "!Ref " + proxyChildName;
                StaticRootMethodTemplate proxyChildMethodTemplate = new StaticRootMethodTemplate(proxyChildName, proxyChildRef, ((StaticRouteNode)node).getAuth(), staticFilesBucket, staticHash);
                List list2 = proxyChildren = CollectionsKt.listOf((Object)proxyChildMethodTemplate);
                List list3 = CollectionsKt.emptyList();
                boolean bl = false;
                String string = proxyChildName;
                String string2 = pathPart;
                List list4 = list3;
                List list5 = list2;
                list = CollectionsKt.listOf((Object)new ResourceTemplate(list5, list4, string2, string, bl));
            } else {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        private final List<MethodTemplate> methodTemplates(RouteNode<?> node, String resourceName, String resourceRef, String staticFilesBucket, String staticHash) {
            List<MethodTemplate> list;
            RouteNode<?> routeNode = node;
            if (routeNode instanceof FixedRouteNode) {
                list = this.lambdaMethodTemplates(node, resourceName, resourceRef);
            } else if (routeNode instanceof VariableRouteNode) {
                list = this.lambdaMethodTemplates(node, resourceName, resourceRef);
            } else if (routeNode instanceof StaticRouteNode) {
                list = this.indexFileMethodTemplates((StaticRouteNode)node, resourceName, resourceRef, staticFilesBucket, staticHash);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return list;
        }

        /*
         * WARNING - void declaration
         */
        private final List<LambdaMethodTemplate> lambdaMethodTemplates(RouteNode<?> node, String resourceName, String resourceRef) {
            void $receiver$iv$iv;
            Map $receiver$iv;
            Map map = $receiver$iv = node.getHandlers();
            Collection destination$iv$iv = new ArrayList($receiver$iv.size());
            void var7_7 = $receiver$iv$iv;
            Iterator iterator = var7_7.entrySet().iterator();
            while (iterator.hasNext()) {
                void $httpMethod_pair;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                void var11_11 = $httpMethod_pair;
                HttpMethod httpMethod = (HttpMethod)var11_11.getKey();
                var11_11 = $httpMethod_pair;
                Pair pair = (Pair)var11_11.getValue();
                LambdaMethodTemplate lambdaMethodTemplate = new LambdaMethodTemplate(resourceName, resourceRef, httpMethod, (Auth)pair.getSecond());
                collection.add(lambdaMethodTemplate);
            }
            return (List)destination$iv$iv;
        }

        private final List<MethodTemplate> indexFileMethodTemplates(StaticRouteNode<?> node, String resourceName, String resourceRef, String staticFilesBucket, String staticHash) {
            List list;
            TemplatesKt.access$getLog$p().debug("Creating static index file template with hash {}, bucket {}", (Object)staticHash, (Object)staticFilesBucket);
            String indexFile = node.getIndexFile();
            if (indexFile == null) {
                list = CollectionsKt.emptyList();
            } else {
                if (staticFilesBucket == null) {
                    throw (Throwable)new IllegalStateException("Index file specified with no static files bucket");
                }
                list = CollectionsKt.listOf((Object)new StaticIndexFileMethodTemplate(resourceName, resourceRef, node.getAuth(), staticFilesBucket, staticHash, indexFile));
            }
            return list;
        }

        private final String resourceName(String path) {
            long hash = Hashing.farmHashFingerprint64().hashString((CharSequence)path, Charsets.UTF_8).asLong();
            String id = Long.toHexString(hash);
            return "Resource" + id;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

