/*
 * Decompiled with CFR 0.152.
 */
package ws.osiris.awsdeploy.cloudformation;

import java.io.Writer;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import ws.osiris.awsdeploy.cloudformation.WritableResource;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lws/osiris/awsdeploy/cloudformation/PublishLambdaTemplate;", "Lws/osiris/awsdeploy/cloudformation/WritableResource;", "codeHash", "", "(Ljava/lang/String;)V", "write", "", "writer", "Ljava/io/Writer;", "osiris-aws-deploy"})
public final class PublishLambdaTemplate
implements WritableResource {
    private final String codeHash;

    @Override
    public void write(@NotNull Writer writer) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        String arn = "arn:aws:execute-api:${AWS::Region}:${AWS::AccountId}:${Api}/*";
        String string = UUID.randomUUID().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UUID.randomUUID().toString()");
        String statementId = string;
        String script = "\n          var AWS = require('aws-sdk');\n          var response = require('cfn-response');\n          exports.handler = (event, context, callback) => {\n            if (event.RequestType == 'Delete') {\n              response.send(event, context, response.SUCCESS);\n            }\n            var lambda = new AWS.Lambda();\n            lambda.publishVersion({FunctionName: event.ResourceProperties.FunctionName}).promise().then((data) => {\n              var permissionsParams = {\n                  Action: \"lambda:InvokeFunction\",\n                  FunctionName: data.FunctionArn,\n                  Principal: \"apigateway.amazonaws.com\",\n                  SourceArn: \"" + arn + "\",\n                  StatementId: \"" + statementId + "\"\n              }\n              lambda.addPermission(permissionsParams).promise().then((resp) => {\n                return response.send(event, context, response.SUCCESS, {FunctionArn: data.FunctionArn}, data.FunctionArn);\n              }).catch((e) => {\n                return response.send(event, context, response.FAILED, e);\n              });\n            }).catch((e) => {\n              return response.send(event, context, response.FAILED, e);\n            });\n          };\n";
        String template = StringsKt.trimMargin$default((String)("\n        |\n        |  LambdaVersion:\n        |    Type: Custom::LambdaVersion\n        |    Properties:\n        |      ServiceToken: !GetAtt LambdaVersionFunction.Arn\n        |      FunctionName: !Ref Function\n        |      CodeHash: " + this.codeHash + "\n        |\n        |  LambdaVersionFunction:\n        |    Type: AWS::Lambda::Function\n        |    Properties:\n        |      Handler: \"index.handler\"\n        |      Role: !GetAtt LambdaVersionExecutionRole.Arn\n        |      Code:\n        |        ZipFile: !Sub |\n        |          " + script + "\n        |      Runtime: nodejs6.10\n        |\n        |  LambdaVersionExecutionRole:\n        |    Type: AWS::IAM::Role\n        |    Properties:\n        |      AssumeRolePolicyDocument:\n        |        Version: '2012-10-17'\n        |        Statement:\n        |        - Effect: Allow\n        |          Principal: {Service: [lambda.amazonaws.com]}\n        |          Action: ['sts:AssumeRole']\n        |      Path: /\n        |      ManagedPolicyArns:\n        |      - arn:aws:iam::aws:policy/service-role/AWSLambdaBasicExecutionRole\n        |      Policies:\n        |      - PolicyName: PublishVersion\n        |        PolicyDocument:\n        |          Version: 2012-10-17\n        |          Statement:\n        |          - Effect: Allow\n        |            Action: ['lambda:PublishVersion', 'lambda:AddPermission']\n        |            Resource: '*'\n"), null, (int)1, null);
        writer.write(template);
    }

    public PublishLambdaTemplate(@NotNull String codeHash) {
        Intrinsics.checkParameterIsNotNull((Object)codeHash, (String)"codeHash");
        this.codeHash = codeHash;
    }
}

