/*
 * Decompiled with CFR 0.152.
 */
package ws.osiris.awsdeploy.cloudformation;

import java.io.Writer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ws.osiris.awsdeploy.cloudformation.MethodTemplate;
import ws.osiris.awsdeploy.cloudformation.TemplatesKt;
import ws.osiris.core.Auth;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u0003X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lws/osiris/awsdeploy/cloudformation/StaticIndexFileMethodTemplate;", "Lws/osiris/awsdeploy/cloudformation/MethodTemplate;", "resourceName", "", "resourceRef", "auth", "Lws/osiris/core/Auth;", "staticFilesBucket", "staticHash", "indexFile", "(Ljava/lang/String;Ljava/lang/String;Lws/osiris/core/Auth;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "name", "getName$osiris_aws_deploy", "()Ljava/lang/String;", "write", "", "writer", "Ljava/io/Writer;", "osiris-aws-deploy"})
public final class StaticIndexFileMethodTemplate
extends MethodTemplate {
    @NotNull
    private final String name;
    private final String resourceRef;
    private final Auth auth;
    private final String staticFilesBucket;
    private final String staticHash;
    private final String indexFile;

    @Override
    @NotNull
    public String getName$osiris_aws_deploy() {
        return this.name;
    }

    @Override
    public void write(@NotNull Writer writer) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        String arn = "arn:aws:apigateway:${AWS::Region}:s3:path/" + this.staticFilesBucket + '/' + this.staticHash + '/' + this.indexFile;
        String template = StringsKt.trimMargin$default((String)("\n        |\n        |  " + this.getName$osiris_aws_deploy() + ":\n        |    Type: AWS::ApiGateway::Method\n        |    Properties:\n        |      HttpMethod: GET\n        |      ResourceId: " + this.resourceRef + "\n        |      RestApiId: !Ref Api\n        |      " + TemplatesKt.access$authSnippet(this.auth) + "\n        |      Integration:\n        |        IntegrationHttpMethod: GET\n        |        Type: AWS\n        |        Uri: !Sub " + arn + "\n        |        Credentials: !GetAtt StaticFilesRole.Arn\n        |        IntegrationResponses:\n        |          - StatusCode: 200\n        |            ResponseParameters:\n        |              method.response.header.Content-Type: integration.response.header.Content-Type\n        |              method.response.header.Content-Length: integration.response.header.Content-Length\n        |          - StatusCode: 403\n        |            SelectionPattern: 403\n        |          - StatusCode: 404\n        |            SelectionPattern: 404\n        |      MethodResponses:\n        |        - StatusCode: 200\n        |          ResponseParameters:\n        |            method.response.header.Content-Type: true\n        |            method.response.header.Content-Length: true\n        |        - StatusCode: 403\n        |        - StatusCode: 404\n"), null, (int)1, null);
        writer.write(template);
    }

    public StaticIndexFileMethodTemplate(@NotNull String resourceName, @NotNull String resourceRef, @Nullable Auth auth, @NotNull String staticFilesBucket, @Nullable String staticHash, @NotNull String indexFile) {
        Intrinsics.checkParameterIsNotNull((Object)resourceName, (String)"resourceName");
        Intrinsics.checkParameterIsNotNull((Object)resourceRef, (String)"resourceRef");
        Intrinsics.checkParameterIsNotNull((Object)staticFilesBucket, (String)"staticFilesBucket");
        Intrinsics.checkParameterIsNotNull((Object)indexFile, (String)"indexFile");
        super(null);
        this.resourceRef = resourceRef;
        this.auth = auth;
        this.staticFilesBucket = staticFilesBucket;
        this.staticHash = staticHash;
        this.indexFile = indexFile;
        this.name = resourceName + "GET";
    }
}

