/*
 * Decompiled with CFR 0.152.
 */
package ws.osiris.awsdeploy.cloudformation;

import java.io.Writer;
import java.time.Duration;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import ws.osiris.awsdeploy.cloudformation.WritableResource;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lws/osiris/awsdeploy/cloudformation/KeepAliveTemplate;", "Lws/osiris/awsdeploy/cloudformation/WritableResource;", "instanceCount", "", "keepAliveInterval", "Ljava/time/Duration;", "keepAliveSleep", "codeS3Bucket", "", "codeS3Key", "(ILjava/time/Duration;Ljava/time/Duration;Ljava/lang/String;Ljava/lang/String;)V", "write", "", "writer", "Ljava/io/Writer;", "osiris-aws-deploy"})
public final class KeepAliveTemplate
implements WritableResource {
    private final int instanceCount;
    private final Duration keepAliveInterval;
    private final Duration keepAliveSleep;
    private final String codeS3Bucket;
    private final String codeS3Key;

    @Override
    public void write(@NotNull Writer writer) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        long intervalMinutes = this.keepAliveInterval.toMinutes();
        String scheduleExpr = intervalMinutes == 1L ? "rate(1 minute)" : "rate(" + intervalMinutes + " minutes)";
        String targetId = UUID.randomUUID().toString();
        String template = StringsKt.trimMargin$default((String)("\n        |\n        |  KeepAliveEventRule:\n        |    Type: AWS::Events::Rule\n        |    Properties:\n        |      Description: Event to trigger the keep-alive lambda to send keep-alive messages to the handler lambda\n        |      ScheduleExpression: " + scheduleExpr + "\n        |      State: ENABLED\n        |      Targets:\n        |        - Arn: !GetAtt KeepAliveFunction.Arn\n        |          Id: " + targetId + "\n        |          Input: !Sub |\n        |            {\n        |              \"functionArn\": \"${LambdaVersion.FunctionArn}\",\n        |              \"instanceCount\": " + this.instanceCount + ",\n        |              \"sleepTimeMs\": " + this.keepAliveSleep.toMillis() + "\n        |            }\n        |\n        |  KeepAliveFunction:\n        |    Type: AWS::Lambda::Function\n        |    Properties:\n        |      Handler: ws.osiris.aws.KeepAliveLambda::handle\n        |      Runtime: java8\n        |      MemorySize: 1024\n        |      Timeout: 10\n        |      Code:\n        |        S3Bucket: " + this.codeS3Bucket + "\n        |        S3Key: " + this.codeS3Key + "\n        |      Role: !GetAtt KeepAliveFunctionRole.Arn\n        |\n        |  KeepAliveFunctionRole:\n        |    Type: AWS::IAM::Role\n        |    Properties:\n        |      AssumeRolePolicyDocument:\n        |        Version: 2012-10-17\n        |        Statement:\n        |          - Effect: Allow\n        |            Principal:\n        |              Service:\n        |                - lambda.amazonaws.com\n        |            Action: sts:AssumeRole\n        |      Policies:\n        |        - PolicyName: LambdaPolicy\n        |          PolicyDocument:\n        |            Version: 2012-10-17\n        |            Statement:\n        |              - Effect: Allow\n        |                Action:\n        |                  - \"logs:*\"\n        |                Resource: \"arn:aws:logs:*:*:*\"\n        |              - Effect: Allow\n        |                Action:\n        |                  - \"lambda:InvokeFunction\"\n        |                Resource: !GetAtt LambdaVersion.FunctionArn\n        |\n        |  KeepAlivePermission:\n        |    Type: AWS::Lambda::Permission\n        |    Properties:\n        |      Action: lambda:InvokeFunction\n        |      FunctionName: !GetAtt KeepAliveFunction.Arn\n        |      Principal: events.amazonaws.com\n        |      SourceArn: !GetAtt KeepAliveEventRule.Arn\n"), null, (int)1, null);
        writer.write(template);
    }

    public KeepAliveTemplate(int instanceCount, @NotNull Duration keepAliveInterval, @NotNull Duration keepAliveSleep, @NotNull String codeS3Bucket, @NotNull String codeS3Key) {
        Intrinsics.checkParameterIsNotNull((Object)keepAliveInterval, (String)"keepAliveInterval");
        Intrinsics.checkParameterIsNotNull((Object)keepAliveSleep, (String)"keepAliveSleep");
        Intrinsics.checkParameterIsNotNull((Object)codeS3Bucket, (String)"codeS3Bucket");
        Intrinsics.checkParameterIsNotNull((Object)codeS3Key, (String)"codeS3Key");
        this.instanceCount = instanceCount;
        this.keepAliveInterval = keepAliveInterval;
        this.keepAliveSleep = keepAliveSleep;
        this.codeS3Bucket = codeS3Bucket;
        this.codeS3Key = codeS3Key;
    }
}

