/*
 * Decompiled with CFR 0.152.
 */
package ws.osiris.awsdeploy.cloudformation;

import java.io.Writer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ws.osiris.aws.AuthConfig;
import ws.osiris.awsdeploy.cloudformation.TemplatesKt;
import ws.osiris.awsdeploy.cloudformation.WritableResource;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lws/osiris/awsdeploy/cloudformation/CustomAuthorizerTemplate;", "Lws/osiris/awsdeploy/cloudformation/WritableResource;", "authConfig", "Lws/osiris/aws/AuthConfig;", "(Lws/osiris/aws/AuthConfig;)V", "write", "", "writer", "Ljava/io/Writer;", "osiris-aws-deploy"})
public final class CustomAuthorizerTemplate
implements WritableResource {
    private final AuthConfig authConfig;

    @Override
    public void write(@NotNull Writer writer) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        if (this.authConfig instanceof AuthConfig.Custom) {
            TemplatesKt.access$getLog$p().debug("Creating custom authorizer resource with ARN of existing lambda {}", (Object)((AuthConfig.Custom)this.authConfig).getLambdaArn());
            string = ((AuthConfig.Custom)this.authConfig).getLambdaArn();
        } else {
            TemplatesKt.access$getLog$p().debug("Creating custom authorizer resource using template parameter CustomAuthArn");
            string = "${CustomAuthArn}";
        }
        String arn = string;
        String uri = "!Sub arn:aws:apigateway:${AWS::Region}:lambda:path/2015-03-31/functions/" + arn + "/invocations";
        String template = StringsKt.trimMargin$default((String)("\n        |\n        |  Authorizer:\n        |    Type: \"AWS::ApiGateway::Authorizer\"\n        |    Properties:\n        |      Name: CustomAuthorizer\n        |      IdentitySource: method.request.header.Authorization\n        |      AuthorizerUri: " + uri + "\n        |      RestApiId: !Ref Api\n        |      Type: TOKEN\n"), null, (int)1, null);
        writer.write(template);
    }

    public CustomAuthorizerTemplate(@Nullable AuthConfig authConfig) {
        this.authConfig = authConfig;
    }
}

