/*
 * Decompiled with CFR 0.152.
 */
package ws.osiris.awsdeploy;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ws.osiris.aws.ApiFactory;
import ws.osiris.aws.ApplicationConfig;
import ws.osiris.awsdeploy.AwsProfile;
import ws.osiris.awsdeploy.DeployException;
import ws.osiris.awsdeploy.DeployKt;
import ws.osiris.awsdeploy.DeployableProject;
import ws.osiris.awsdeploy.DeployableProjectKt;
import ws.osiris.awsdeploy.StaticFilesInfo;
import ws.osiris.awsdeploy.cloudformation.CloudFormationKt;
import ws.osiris.awsdeploy.cloudformation.DeployResult;
import ws.osiris.core.Api;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\bf\u0018\u00002\u00020\u0001:\u0001EJ\u0014\u0010#\u001a\u0006\u0012\u0002\b\u00030$2\u0006\u0010%\u001a\u00020&H\u0016J\u0014\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030(H\u0016J\b\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u0003H\u0002J&\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00030.2\u0006\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u0003H\u0002J\u0010\u00102\u001a\u00020\b2\u0006\u0010,\u001a\u00020\u0003H\u0016J\u0010\u00103\u001a\u0002042\u0006\u00101\u001a\u00020\u0003H\u0002J\u001c\u00105\u001a\u00020\u00032\u0012\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b07\"\u00020\bH\u0002J\b\u00108\u001a\u000209H\u0002J \u0010:\u001a\u0004\u0018\u00010;2\n\u0010<\u001a\u0006\u0012\u0002\b\u00030=2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0003H\u0002J \u0010>\u001a\u00020\u00032\u0006\u0010?\u001a\u00020\u00032\u0006\u0010@\u001a\u00020\u00032\u0006\u0010A\u001a\u00020\u0003H\u0002J.\u0010B\u001a\u00020*2\u0006\u00108\u001a\u0002092\n\u0010<\u001a\u0006\u0012\u0002\b\u00030=2\u0006\u0010C\u001a\u00020\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010\u0003H\u0002J \u0010D\u001a\u00020*2\u0006\u00108\u001a\u0002092\u0006\u0010@\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0000R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0000R\u000e\u0010\f\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0000R\u0014\u0010\r\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u000e\u0010\u000f\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0000R\u0012\u0010\u0010\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\nR\u000e\u0010\u0012\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0000R\u000e\u0010\u0013\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0000R\u000e\u0010\u0014\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0000R\u000e\u0010\u0015\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0000R\u0012\u0010\u0016\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0006R\u0012\u0010\u0018\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0006R\u000e\u0010\u001a\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0000R\u0012\u0010\u001b\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\nR\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0006R\u0014\u0010\u001f\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0006R\u0014\u0010!\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0006\u00a8\u0006F"}, d2={"Lws/osiris/awsdeploy/DeployableProject;", "", "apiFactoryClassName", "", "awsProfile", "getAwsProfile", "()Ljava/lang/String;", "buildDir", "Ljava/nio/file/Path;", "getBuildDir", "()Ljava/nio/file/Path;", "cloudFormationGeneratedDir", "cloudFormationSourceDir", "environmentName", "getEnvironmentName", "generatedCorePackage", "jarBuildDir", "getJarBuildDir", "jarFile", "jarName", "lambdaClassName", "lambdaHandler", "name", "getName", "rootPackage", "getRootPackage", "rootTemplate", "sourceDir", "getSourceDir", "stackName", "getStackName", "staticFilesDirectory", "getStaticFilesDirectory", "version", "getVersion", "createApiFactory", "Lws/osiris/aws/ApiFactory;", "parentClassLoader", "Ljava/lang/ClassLoader;", "deploy", "", "generateCloudFormation", "", "generatedTemplateName", "appName", "generatedTemplateParameters", "", "rootTemplatePath", "codeBucketName", "apiName", "generatedTemplatePath", "jarS3Key", "Lws/osiris/awsdeploy/DeployableProject$JarKey;", "md5Hash", "files", "", "profile", "Lws/osiris/awsdeploy/AwsProfile;", "staticFilesInfo", "Lws/osiris/awsdeploy/StaticFilesInfo;", "api", "Lws/osiris/core/Api;", "templateUrl", "templateName", "codeBucket", "region", "uploadStaticFiles", "bucket", "uploadTemplates", "JarKey", "osiris-aws-deploy"})
public interface DeployableProject {
    @NotNull
    public String getName();

    @Nullable
    public String getVersion();

    @NotNull
    public Path getBuildDir();

    @NotNull
    public Path getJarBuildDir();

    @NotNull
    public Path getSourceDir();

    @NotNull
    public String getRootPackage();

    @Nullable
    public String getEnvironmentName();

    @Nullable
    public String getStaticFilesDirectory();

    @Nullable
    public String getAwsProfile();

    @Nullable
    public String getStackName();

    @NotNull
    public ApiFactory<?> createApiFactory(@NotNull ClassLoader var1);

    public void generateCloudFormation();

    @NotNull
    public Path generatedTemplatePath(@NotNull String var1);

    @NotNull
    public Map<String, String> deploy();

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lws/osiris/awsdeploy/DeployableProject$JarKey;", "", "hash", "", "name", "(Ljava/lang/String;Ljava/lang/String;)V", "getHash", "()Ljava/lang/String;", "getName", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "osiris-aws-deploy"})
    private static final class JarKey {
        @NotNull
        private final String hash;
        @NotNull
        private final String name;

        @NotNull
        public final String getHash() {
            return this.hash;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public JarKey(@NotNull String hash, @NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            this.hash = hash;
            this.name = name;
        }

        @NotNull
        public final String component1() {
            return this.hash;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final JarKey copy(@NotNull String hash, @NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            return new JarKey(hash, name);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ JarKey copy$default(JarKey jarKey, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = jarKey.hash;
            }
            if ((n & 2) != 0) {
                string2 = jarKey.name;
            }
            return jarKey.copy(string, string2);
        }

        public String toString() {
            return "JarKey(hash=" + this.hash + ", name=" + this.name + ")";
        }

        public int hashCode() {
            String string = this.hash;
            String string2 = this.name;
            return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof JarKey)) break block3;
                    JarKey jarKey = (JarKey)object;
                    if (!Intrinsics.areEqual((Object)this.hash, (Object)jarKey.hash) || !Intrinsics.areEqual((Object)this.name, (Object)jarKey.name)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=3)
    public static final class DefaultImpls {
        private static Path getCloudFormationSourceDir(DeployableProject $this) {
            Path path = $this.getSourceDir().resolve("cloudformation");
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"sourceDir.resolve(\"cloudformation\")");
            return path;
        }

        private static Path getRootTemplate(DeployableProject $this) {
            Path path = DefaultImpls.getCloudFormationSourceDir($this).resolve("root.template");
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"cloudFormationSourceDir.resolve(\"root.template\")");
            return path;
        }

        private static String getGeneratedCorePackage(DeployableProject $this) {
            return $this.getRootPackage() + ".core.generated";
        }

        private static String getLambdaClassName(DeployableProject $this) {
            return DefaultImpls.getGeneratedCorePackage($this) + ".GeneratedLambda";
        }

        private static String getLambdaHandler(DeployableProject $this) {
            return DefaultImpls.getLambdaClassName($this) + "::handle";
        }

        private static Path getCloudFormationGeneratedDir(DeployableProject $this) {
            Path path = $this.getBuildDir().resolve("cloudformation");
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"buildDir.resolve(\"cloudformation\")");
            return path;
        }

        private static String getApiFactoryClassName(DeployableProject $this) {
            return DefaultImpls.getGeneratedCorePackage($this) + ".GeneratedApiFactory";
        }

        private static Path getJarFile(DeployableProject $this) {
            Path path = $this.getJarBuildDir().resolve(DefaultImpls.getJarName($this));
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"jarBuildDir.resolve(jarName)");
            return path;
        }

        private static String getJarName(DeployableProject $this) {
            return $this.getVersion() == null ? $this.getName() + "-jar-with-dependencies.jar" : $this.getName() + '-' + $this.getVersion() + "-jar-with-dependencies.jar";
        }

        /*
         * WARNING - void declaration
         */
        private static AwsProfile profile(DeployableProject $this) {
            AwsProfile awsProfile;
            String awsProfile2 = $this.getAwsProfile();
            if (awsProfile2 == null) {
                AwsProfile profile = AwsProfile.Companion.default();
                DeployableProjectKt.access$getLog$p().info("Using default AWS profile, region = {}", (Object)profile.getRegion());
                awsProfile = profile;
            } else {
                void var2_3;
                AwsProfile profile = AwsProfile.Companion.named(awsProfile2);
                DeployableProjectKt.access$getLog$p().info("Using AWS profile named '{}', region = {}", (Object)awsProfile2, (Object)profile.getRegion());
                awsProfile = var2_3;
            }
            return awsProfile;
        }

        @NotNull
        public static ApiFactory<?> createApiFactory(DeployableProject $this, @NotNull ClassLoader parentClassLoader) {
            Intrinsics.checkParameterIsNotNull((Object)parentClassLoader, (String)"parentClassLoader");
            if (!Files.exists(DefaultImpls.getJarFile($this), new LinkOption[0])) {
                throw (Throwable)new DeployException("Cannot find " + DefaultImpls.getJarFile($this).toAbsolutePath());
            }
            URLClassLoader classLoader = new URLClassLoader(new URL[]{DefaultImpls.getJarFile($this).toUri().toURL()}, parentClassLoader);
            Class<?> apiFactoryClass = Class.forName(DefaultImpls.getApiFactoryClassName($this), true, classLoader);
            Object obj = apiFactoryClass.newInstance();
            if (obj == null) {
                throw new TypeCastException("null cannot be cast to non-null type ws.osiris.aws.ApiFactory<*>");
            }
            return (ApiFactory)obj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public static void generateCloudFormation(DeployableProject $this) {
            ClassLoader classLoader = $this.getClass().getClassLoader();
            Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"javaClass.classLoader");
            ApiFactory<?> apiFactory = $this.createApiFactory(classLoader);
            Api api = apiFactory.getApi();
            ApplicationConfig appConfig = apiFactory.getConfig();
            String string = appConfig.getCodeBucket();
            if (string == null) {
                string = DeployKt.codeBucketName(appConfig.getApplicationName(), $this.getEnvironmentName(), appConfig.getBucketPrefix());
            }
            String codeBucket = string;
            JarKey jarKey = DefaultImpls.jarS3Key($this, appConfig.getApplicationName());
            String string2 = jarKey.component1();
            String jarKey2 = jarKey.component2();
            String lambdaHandler = DefaultImpls.getLambdaHandler($this);
            boolean rootTemplateExists = Files.exists(DefaultImpls.getRootTemplate($this), new LinkOption[0]);
            Set<String> templateParams = rootTemplateExists ? DefaultImpls.generatedTemplateParameters($this, DefaultImpls.getRootTemplate($this), codeBucket, appConfig.getApplicationName()) : SetsKt.emptySet();
            StaticFilesInfo staticFilesInfo2 = DefaultImpls.staticFilesInfo($this, api, $this.getStaticFilesDirectory());
            String staticHash = staticFilesInfo2 != null ? staticFilesInfo2.getHash() : null;
            boolean createLambdaRole = !rootTemplateExists;
            Path generatedTemplatePath = $this.generatedTemplatePath(appConfig.getApplicationName());
            Files.deleteIfExists(generatedTemplatePath);
            Files.createDirectories(generatedTemplatePath.getParent(), new FileAttribute[0]);
            Closeable closeable = Files.newBufferedWriter(generatedTemplatePath, StandardOpenOption.CREATE);
            Throwable throwable = null;
            try {
                void codeHash;
                BufferedWriter it;
                BufferedWriter bufferedWriter = it = (BufferedWriter)closeable;
                Intrinsics.checkExpressionValueIsNotNull((Object)bufferedWriter, (String)"it");
                CloudFormationKt.writeTemplate(bufferedWriter, api, appConfig, templateParams, lambdaHandler, (String)codeHash, staticHash, codeBucket, jarKey2, createLambdaRole, $this.getEnvironmentName(), appConfig.getBucketPrefix(), appConfig.getBinaryMimeTypes());
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            if (!Files.exists(DefaultImpls.getCloudFormationSourceDir($this), new LinkOption[0])) {
                return;
            }
            Files.list(DefaultImpls.getCloudFormationSourceDir($this)).filter(generateCloudFormation.2.INSTANCE).forEach(new Consumer<Path>($this, codeBucket, jarKey2){
                final /* synthetic */ DeployableProject this$0;
                final /* synthetic */ String $codeBucket;
                final /* synthetic */ String $jarKey;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void accept(Path file) {
                    String string;
                    Closeable closeable = new BufferedReader(new FileReader(file.toFile()));
                    Throwable throwable = null;
                    try {
                        BufferedReader it = (BufferedReader)closeable;
                        string = TextStreamsKt.readText((Reader)it);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    String templateText = string;
                    String string2 = StringsKt.replace$default((String)StringsKt.replace$default((String)templateText, (String)"${codeS3Bucket}", (String)this.$codeBucket, (boolean)false, (int)4, null), (String)"${codeS3Key}", (String)this.$jarKey, (boolean)false, (int)4, null);
                    String string3 = this.this$0.getEnvironmentName();
                    if (string3 == null) {
                        string3 = "null";
                    }
                    String generatedFile = StringsKt.replace$default((String)string2, (String)"${environmentName}", (String)string3, (boolean)false, (int)4, null);
                    Path path = DefaultImpls.access$getCloudFormationGeneratedDir$p(this.this$0);
                    Path path2 = file;
                    Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"file");
                    Path generatedFilePath = path.resolve(path2.getFileName());
                    DeployableProjectKt.access$getLog$p().debug("Copying template from " + file.toAbsolutePath() + " to " + generatedFilePath.toAbsolutePath());
                    string = generatedFile;
                    Charset charset = Charsets.UTF_8;
                    Path path3 = generatedFilePath;
                    String string4 = string;
                    if (string4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    byte[] byArray = string4.getBytes(charset);
                    Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                    byte[] byArray2 = byArray;
                    Files.write(path3, byArray2, new OpenOption[0]);
                }
                {
                    this.this$0 = deployableProject;
                    this.$codeBucket = string;
                    this.$jarKey = string2;
                }
            });
        }

        private static JarKey jarS3Key(DeployableProject $this, String apiName) {
            Path jarPath = $this.getJarBuildDir().resolve(DefaultImpls.getJarName($this));
            Path[] pathArray = new Path[1];
            Path path = jarPath;
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"jarPath");
            pathArray[0] = path;
            String md5Hash2 = DefaultImpls.md5Hash($this, pathArray);
            return new JarKey(md5Hash2, apiName + '.' + md5Hash2 + ".jar");
        }

        private static String generatedTemplateName(DeployableProject $this, String appName) {
            return appName + ".template";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static String md5Hash(DeployableProject $this, Path ... files) {
            MessageDigest messageDigest = MessageDigest.getInstance("md5");
            byte[] buffer = new byte[0x100000];
            Function1<InputStream, Unit> readChunk$ = new Function1<InputStream, Unit>(buffer, messageDigest){
                final /* synthetic */ byte[] $buffer;
                final /* synthetic */ MessageDigest $messageDigest;

                public final void invoke(@NotNull InputStream stream) {
                    while (true) {
                        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
                        int bytesRead = stream.read(this.$buffer);
                        if (bytesRead == -1) {
                            return;
                        }
                        this.$messageDigest.update(this.$buffer, 0, bytesRead);
                    }
                }
                {
                    this.$buffer = byArray;
                    this.$messageDigest = messageDigest;
                    super(1);
                }
            };
            for (Path file : files) {
                InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"Files.newInputStream(file)");
                Closeable closeable = inputStream;
                int n = 0x100000;
                closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
                Throwable throwable = null;
                try {
                    BufferedInputStream it = (BufferedInputStream)closeable;
                    readChunk$.invoke((InputStream)it);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            byte[] digest = messageDigest.digest();
            Intrinsics.checkExpressionValueIsNotNull((Object)digest, (String)"digest");
            return ArraysKt.joinToString$default((byte[])digest, (CharSequence)"", null, null, (int)0, null, (Function1)md5Hash.3.INSTANCE, (int)30, null);
        }

        private static String templateUrl(DeployableProject $this, String templateName, String codeBucket, String region) {
            return "https://s3-" + region + ".amazonaws.com/" + codeBucket + '/' + templateName;
        }

        private static Set<String> generatedTemplateParameters(DeployableProject $this, Path rootTemplatePath, String codeBucketName, String apiName) {
            byte[] templateBytes = Files.readAllBytes(rootTemplatePath);
            Intrinsics.checkExpressionValueIsNotNull((Object)templateBytes, (String)"templateBytes");
            byte[] byArray = templateBytes;
            Charset charset = Charsets.UTF_8;
            String templateYaml = new String(byArray, charset);
            return DeployKt.generatedTemplateParameters(templateYaml, codeBucketName, apiName);
        }

        @NotNull
        public static Path generatedTemplatePath(DeployableProject $this, @NotNull String appName) {
            Intrinsics.checkParameterIsNotNull((Object)appName, (String)"appName");
            Path path = DefaultImpls.getCloudFormationGeneratedDir($this).resolve(DefaultImpls.generatedTemplateName($this, appName));
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"cloudFormationGeneratedD\u2026tedTemplateName(appName))");
            return path;
        }

        @NotNull
        public static Map<String, String> deploy(DeployableProject $this) {
            Map stageUrls;
            Map $receiver$iv$iv;
            String string;
            if (!Files.exists(DefaultImpls.getJarFile($this), new LinkOption[0])) {
                throw (Throwable)new DeployException("Cannot find " + DefaultImpls.getJarName($this));
            }
            URLClassLoader classLoader = new URLClassLoader(new URL[]{DefaultImpls.getJarFile($this).toUri().toURL()}, $this.getClass().getClassLoader());
            ApiFactory<?> apiFactory = $this.createApiFactory(classLoader);
            ApplicationConfig appConfig = apiFactory.getConfig();
            Api api = apiFactory.getApi();
            String appName = appConfig.getApplicationName();
            AwsProfile profile = DefaultImpls.profile($this);
            String string2 = appConfig.getCodeBucket();
            if (string2 == null) {
                string2 = DeployKt.createBucket(profile, appName, $this.getEnvironmentName(), "code", appConfig.getBucketPrefix());
            }
            String codeBucket = string2;
            JarKey jarKey = DefaultImpls.jarS3Key($this, appName);
            String jarKey2 = jarKey.component2();
            DeployableProjectKt.access$getLog$p().info("Uploading function code '" + DefaultImpls.getJarFile($this) + "' to " + codeBucket + " with key " + jarKey2);
            DeployKt.uploadFile(profile, DefaultImpls.getJarFile($this), codeBucket, jarKey2);
            DeployableProjectKt.access$getLog$p().info("Upload of function code complete");
            DefaultImpls.uploadTemplates($this, profile, codeBucket, appConfig.getApplicationName());
            String deploymentTemplateUrl = Files.exists(DefaultImpls.getRootTemplate($this), new LinkOption[0]) ? DefaultImpls.templateUrl($this, ((Object)DefaultImpls.getRootTemplate($this).getFileName()).toString(), codeBucket, profile.getRegion()) : DefaultImpls.templateUrl($this, DefaultImpls.generatedTemplateName($this, appName), codeBucket, profile.getRegion());
            String apiEnvSuffix = $this.getEnvironmentName() == null ? "" : '.' + $this.getEnvironmentName();
            String apiName = appConfig.getApplicationName() + apiEnvSuffix;
            String localStackName = $this.getStackName();
            if (localStackName == null) {
                String stackEnvSuffix = $this.getEnvironmentName() == null ? "" : '-' + $this.getEnvironmentName();
                string = appConfig.getApplicationName() + stackEnvSuffix;
            } else {
                string = localStackName;
            }
            String stackName = string;
            DeployResult deployResult = CloudFormationKt.deployStack(profile, stackName, apiName, deploymentTemplateUrl);
            String string3 = appConfig.getStaticFilesBucket();
            if (string3 == null) {
                string3 = DeployKt.staticFilesBucketName(appConfig.getApplicationName(), $this.getEnvironmentName(), appConfig.getBucketPrefix());
            }
            String staticBucket = string3;
            DefaultImpls.uploadStaticFiles($this, profile, api, staticBucket, $this.getStaticFilesDirectory());
            String apiId = deployResult.getApiId();
            boolean stackCreated = deployResult.getStackCreated();
            List<String> deployedStages = DeployKt.deployStages(profile, apiId, apiName, appConfig.getStages(), stackCreated);
            Iterable $receiver$iv = deployedStages;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
            Iterable iterable = $receiver$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            Map.Entry entry = $receiver$iv$iv.iterator();
            while (entry.hasNext()) {
                Object element$iv$iv = entry.next();
                Map map = destination$iv$iv;
                String it = (String)element$iv$iv;
                Pair pair = new Pair((Object)it, (Object)("https://" + apiId + ".execute-api." + profile.getRegion() + ".amazonaws.com/" + it + '/'));
                map.put(pair.getFirst(), pair.getSecond());
            }
            $receiver$iv$iv = stageUrls = destination$iv$iv;
            Iterator iterator = $receiver$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry2;
                entry = entry2 = iterator.next();
                String stage = (String)entry.getKey();
                entry = entry2;
                String url = (String)entry.getValue();
                DeployableProjectKt.access$getLog$p().info("Deployed to stage '" + stage + "' at " + url);
            }
            return stageUrls;
        }

        private static void uploadStaticFiles(DeployableProject $this, AwsProfile profile, Api<?> api, String bucket, String staticFilesDirectory) {
            String string;
            String it;
            StaticFilesInfo staticFilesInfo2 = DefaultImpls.staticFilesInfo($this, api, staticFilesDirectory);
            if (staticFilesInfo2 == null) {
                return;
            }
            StaticFilesInfo staticFilesInfo3 = staticFilesInfo2;
            Object object = staticFilesDirectory;
            if (object == null || (object = Paths.get(it = (string = object), new String[0])) == null) {
                object = $this.getSourceDir().resolve("static");
            }
            Object staticFilesDir = object;
            for (Path file : staticFilesInfo3.getFiles()) {
                Object object2 = staticFilesDir;
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"staticFilesDir");
                DeployKt.uploadFile$default(profile, file, bucket, (Path)object2, null, staticFilesInfo3.getHash(), 16, null);
            }
        }

        private static void uploadTemplates(DeployableProject $this, AwsProfile profile, String codeBucket, String appName) {
            if (!Files.exists(DefaultImpls.getCloudFormationGeneratedDir($this), new LinkOption[0])) {
                return;
            }
            Files.list(DefaultImpls.getCloudFormationGeneratedDir($this)).filter(uploadTemplates.1.INSTANCE).forEach(new Consumer<Path>(profile, codeBucket){
                final /* synthetic */ AwsProfile $profile;
                final /* synthetic */ String $codeBucket;

                public final void accept(Path templateFile) {
                    Path path = templateFile;
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"templateFile");
                    String templateUrl = DeployKt.uploadFile$default(this.$profile, path, this.$codeBucket, null, 8, null);
                    DeployableProjectKt.access$getLog$p().debug("Uploaded template file " + templateFile.toAbsolutePath() + ", S3 URL: " + templateUrl);
                }
                {
                    this.$profile = awsProfile;
                    this.$codeBucket = string;
                }
            });
            Path generatedTemplate = $this.generatedTemplatePath(appName);
            String templateUrl = DeployKt.uploadFile$default(profile, generatedTemplate, codeBucket, null, 8, null);
            DeployableProjectKt.access$getLog$p().debug("Uploaded generated template file " + generatedTemplate.toAbsolutePath() + ", S3 URL: " + templateUrl);
        }

        /*
         * WARNING - void declaration
         */
        private static StaticFilesInfo staticFilesInfo(DeployableProject $this, Api<?> api, String staticFilesDirectory) {
            void $receiver$iv;
            List staticFiles2;
            String string;
            String it;
            if (!api.getStaticFiles()) {
                return null;
            }
            Object object = staticFilesDirectory;
            if (object == null || (object = Paths.get(it = (string = object), new String[0])) == null) {
                object = $this.getSourceDir().resolve("static");
            }
            Object staticFilesDir = object;
            List list = staticFiles2 = Files.walk((Path)staticFilesDir, Integer.MAX_VALUE, new FileVisitOption[0]).filter(staticFilesInfo.staticFiles.1.INSTANCE).collect(Collectors.toList());
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"staticFiles");
            Collection $i$a$1$let = list;
            DeployableProject deployableProject = $this;
            void v2 = $receiver$iv;
            if (v2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            void thisCollection$iv = v2;
            Path[] pathArray = thisCollection$iv.toArray(new Path[0]);
            if (pathArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Path[] pathArray2 = pathArray;
            String hash = DefaultImpls.md5Hash(deployableProject, Arrays.copyOf(pathArray2, pathArray2.length));
            return new StaticFilesInfo(staticFiles2, hash);
        }

        @NotNull
        public static /* synthetic */ Path access$getCloudFormationGeneratedDir$p(DeployableProject $this) {
            return DefaultImpls.getCloudFormationGeneratedDir($this);
        }
    }
}

