/*
 * Decompiled with CFR 0.152.
 */
package ws.osiris.awsdeploy;

import com.amazonaws.services.apigateway.AmazonApiGateway;
import com.amazonaws.services.apigateway.AmazonApiGatewayClientBuilder;
import com.amazonaws.services.apigateway.model.CreateDeploymentRequest;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ws.osiris.aws.Stage;
import ws.osiris.awsdeploy.AwsProfile;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0004\u001a\"\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0004\u001a2\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0004\u001a:\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\u0006\u0010\u0012\u001a\u00020\u0013\u001a&\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u001a\"\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0004\u001a>\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001a2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u0004\u001a*\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u0004\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "bucketName", "", "apiName", "envName", "suffix", "prefix", "codeBucketName", "createBucket", "profile", "Lws/osiris/awsdeploy/AwsProfile;", "deployStages", "", "apiId", "stages", "Lws/osiris/aws/Stage;", "stackCreated", "", "generatedTemplateParameters", "", "templateYaml", "staticFilesBucketName", "uploadFile", "file", "Ljava/nio/file/Path;", "baseDir", "key", "bucketDir", "osiris-aws-deploy"})
public final class DeployKt {
    private static final Logger log = LoggerFactory.getLogger((String)"ws.osiris.awsdeploy");

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> deployStages(@NotNull AwsProfile profile, @NotNull String apiId, @NotNull String apiName, @NotNull List<Stage> stages, boolean stackCreated) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        Intrinsics.checkParameterIsNotNull((Object)apiId, (String)"apiId");
        Intrinsics.checkParameterIsNotNull((Object)apiName, (String)"apiName");
        Intrinsics.checkParameterIsNotNull(stages, (String)"stages");
        if (stackCreated) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)stages;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it2;
                Stage stage = (Stage)item$iv$iv;
                Collection collection = destination$iv$iv;
                String string = it2.getName();
                collection.add(string);
            }
            list = (List)destination$iv$iv;
        } else {
            Object object;
            Object object2;
            Stage it;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            AmazonApiGateway apiGateway = (AmazonApiGateway)((AmazonApiGatewayClientBuilder)((AmazonApiGatewayClientBuilder)AmazonApiGatewayClientBuilder.standard().withCredentials(profile.getCredentialsProvider())).withRegion(profile.getRegion())).build();
            Iterable iterable = $receiver$iv = (Iterable)stages;
            Collection destination$iv$iv = new ArrayList();
            Iterator it2 = $receiver$iv$iv.iterator();
            while (it2.hasNext()) {
                Object element$iv$iv = it2.next();
                it = (Stage)element$iv$iv;
                if (!it.getDeployOnUpdate()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List stagesToDeploy = (List)destination$iv$iv;
            for (Stage stage : stagesToDeploy) {
                log.debug("Updating REST API '" + apiName + "' in stage '" + stage.getName() + '\'');
                destination$iv$iv = new CreateDeploymentRequest();
                object2 = apiGateway;
                Collection $receiver = destination$iv$iv;
                $receiver.setRestApiId(apiId);
                $receiver.setStageName(stage.getName());
                $receiver.setVariables(stage.getVariables());
                $receiver.setDescription(stage.getDescription());
                object = destination$iv$iv;
                object2.createDeployment((CreateDeploymentRequest)object);
            }
            $receiver$iv = stagesToDeploy;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object item$iv$iv = iterator.next();
                it = (Stage)item$iv$iv;
                object2 = destination$iv$iv;
                object = it.getName();
                object2.add(object);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    @NotNull
    public static final String createBucket(@NotNull AwsProfile profile, @NotNull String apiName, @Nullable String envName, @NotNull String suffix, @Nullable String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        Intrinsics.checkParameterIsNotNull((Object)apiName, (String)"apiName");
        Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
        AmazonS3 s3Client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials(profile.getCredentialsProvider())).withRegion(profile.getRegion())).build();
        String bucketName = DeployKt.bucketName(apiName, envName, suffix, prefix);
        if (!s3Client.doesBucketExistV2(bucketName)) {
            s3Client.createBucket(bucketName);
            log.info("Created S3 bucket '" + bucketName + '\'');
        } else {
            log.info("Using existing S3 bucket '" + bucketName + '\'');
        }
        return bucketName;
    }

    @NotNull
    public static final String uploadFile(@NotNull AwsProfile profile, @NotNull Path file, @NotNull String bucketName, @Nullable String key) {
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)bucketName, (String)"bucketName");
        Path path = file.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"file.parent");
        return DeployKt.uploadFile$default(profile, file, bucketName, path, key, null, 32, null);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String uploadFile$default(AwsProfile awsProfile, Path path, String string, String string2, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        return DeployKt.uploadFile(awsProfile, path, string, string2);
    }

    @NotNull
    public static final String uploadFile(@NotNull AwsProfile profile, @NotNull Path file, @NotNull String bucketName, @NotNull Path baseDir, @Nullable String key, @Nullable String bucketDir) {
        String string;
        String uploadKey;
        AmazonS3 s3Client;
        block5: {
            block4: {
                String string2;
                Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                Intrinsics.checkParameterIsNotNull((Object)bucketName, (String)"bucketName");
                Intrinsics.checkParameterIsNotNull((Object)baseDir, (String)"baseDir");
                s3Client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials(profile.getCredentialsProvider())).withRegion(profile.getRegion())).build();
                String string3 = key;
                if (string3 == null) {
                    string3 = uploadKey = ((Object)baseDir.relativize(file)).toString();
                }
                if ((string = bucketDir) == null) break block4;
                String it = string2 = string;
                string = bucketDir + '/';
                if (string != null) break block5;
            }
            string = "";
        }
        String dirPart = string;
        String fullKey = dirPart + uploadKey;
        s3Client.putObject(bucketName, fullKey, file.toFile());
        String url = "https://s3-" + profile.getRegion() + ".amazonaws.com/" + bucketName + '/' + fullKey;
        log.debug("Uploaded file {} to S3 bucket {}, URL {}", new Object[]{file, bucketName, url});
        return url;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String uploadFile$default(AwsProfile awsProfile, Path path, String string, Path path2, String string2, String string3, int n, Object object) {
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        if ((n & 0x20) != 0) {
            string3 = null;
        }
        return DeployKt.uploadFile(awsProfile, path, string, path2, string2, string3);
    }

    @NotNull
    public static final String bucketName(@NotNull String apiName, @Nullable String envName, @NotNull String suffix, @Nullable String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)apiName, (String)"apiName");
        Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
        String accountPart = envName == null ? "" : envName + '.';
        String prefixPart = prefix == null ? "" : prefix + '.';
        return prefixPart + apiName + '.' + accountPart + suffix;
    }

    @NotNull
    public static final String codeBucketName(@NotNull String apiName, @Nullable String envName, @Nullable String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)apiName, (String)"apiName");
        return DeployKt.bucketName(apiName, envName, "code", prefix);
    }

    @NotNull
    public static final String staticFilesBucketName(@NotNull String apiName, @Nullable String envName, @Nullable String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)apiName, (String)"apiName");
        return DeployKt.bucketName(apiName, envName, "static-files", prefix);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<String> generatedTemplateParameters(@NotNull String templateYaml, @NotNull String codeBucketName, @NotNull String apiName) {
        Object object;
        block13: {
            block12: {
                Map it;
                Object object2;
                Collection collection;
                Iterable $receiver$iv$iv;
                Iterable $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)templateYaml, (String)"templateYaml");
                Intrinsics.checkParameterIsNotNull((Object)codeBucketName, (String)"codeBucketName");
                Intrinsics.checkParameterIsNotNull((Object)apiName, (String)"apiName");
                ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
                Map rootTemplateMap = (Map)objectMapper.readValue(templateYaml, Map.class);
                String generatedTemplateUrl = "https://s3-${AWS::Region}.amazonaws.com/" + codeBucketName + '/' + apiName + ".template";
                Map map = rootTemplateMap;
                Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"rootTemplateMap");
                Map map2 = map;
                String string = "Resources";
                object = (Map)map2.get(string);
                if (object == null) break block12;
                map2 = object;
                string = $receiver$iv;
                Collection destination$iv$iv = new ArrayList($receiver$iv.size());
                Iterator iterator = $receiver$iv$iv;
                Iterator iterator2 = iterator.entrySet().iterator();
                while (iterator2.hasNext()) {
                    void it2;
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = iterator2.next();
                    collection = destination$iv$iv;
                    Object v = it2.getValue();
                    if (v == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                    }
                    object2 = (Map)v;
                    collection.add(object2);
                }
                $receiver$iv = (List)destination$iv$iv;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    it = (Map)element$iv$iv;
                    if (!Intrinsics.areEqual(it.get("Type"), (Object)"AWS::CloudFormation::Stack")) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    it = (Map)item$iv$iv;
                    collection = destination$iv$iv;
                    Object v = it.get("Properties");
                    if (v == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                    }
                    object2 = (Map)v;
                    collection.add(object2);
                }
                $receiver$iv = (List)destination$iv$iv;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    it = (Map)element$iv$iv;
                    if (!Intrinsics.areEqual(it.get("TemplateURL"), (Object)generatedTemplateUrl)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    it = (Map)item$iv$iv;
                    collection = destination$iv$iv;
                    Object v = it.get("Parameters");
                    if (v == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
                    }
                    object2 = (Map)v;
                    collection.add(object2);
                }
                $receiver$iv = (List)destination$iv$iv;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    it = (Map)item$iv$iv;
                    collection = destination$iv$iv;
                    object2 = it.keySet();
                    collection.add(object2);
                }
                object = (Set)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
                if (object != null) break block13;
            }
            object = SetsKt.emptySet();
        }
        Object parameters = object;
        return SetsKt.minus((Set)parameters, (Object)"LambdaRole");
    }
}

