/*
 * Decompiled with CFR 0.152.
 */
package wf.bitcoin.javabitcoindrpcclient;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import wf.bitcoin.javabitcoindrpcclient.BitcoinRPCException;
import wf.bitcoin.javabitcoindrpcclient.BitcoinRpcException;

public interface BitcoindRpcClient {
    public String createRawTransaction(List<TxInput> var1, List<TxOutput> var2) throws BitcoinRpcException;

    public String dumpPrivKey(String var1) throws BitcoinRpcException;

    public String getAccount(String var1) throws BitcoinRpcException;

    public String getAccountAddress(String var1) throws BitcoinRpcException;

    public List<String> getAddressesByAccount(String var1) throws BitcoinRpcException;

    public double getBalance() throws BitcoinRpcException;

    public double getBalance(String var1) throws BitcoinRpcException;

    public double getBalance(String var1, int var2) throws BitcoinRpcException;

    public Info getInfo() throws BitcoinRpcException;

    public MiningInfo getMiningInfo() throws BitcoinRpcException;

    public MultiSig createMultiSig(int var1, List<String> var2) throws BitcoinRpcException;

    public NetworkInfo getNetworkInfo() throws BitcoinRpcException;

    public TxOutSetInfo getTxOutSetInfo();

    public WalletInfo getWalletInfo();

    public Block getBlock(int var1) throws BitcoinRpcException;

    public Block getBlock(String var1) throws BitcoinRpcException;

    public String getBlockHash(int var1) throws BitcoinRpcException;

    public BlockChainInfo getBlockChainInfo() throws BitcoinRpcException;

    public int getBlockCount() throws BitcoinRpcException;

    public String getNewAddress() throws BitcoinRpcException;

    public String getNewAddress(String var1) throws BitcoinRpcException;

    public List<String> getRawMemPool() throws BitcoinRpcException;

    public String getBestBlockHash() throws BitcoinRpcException;

    public String getRawTransactionHex(String var1) throws BitcoinRpcException;

    public RawTransaction getRawTransaction(String var1) throws BitcoinRpcException;

    public double getReceivedByAddress(String var1) throws BitcoinRpcException;

    public double getReceivedByAddress(String var1, int var2) throws BitcoinRpcException;

    public void importPrivKey(String var1) throws BitcoinRpcException;

    public void importPrivKey(String var1, String var2) throws BitcoinRpcException;

    public void importPrivKey(String var1, String var2, boolean var3) throws BitcoinRpcException;

    public Map<String, Number> listAccounts() throws BitcoinRpcException;

    public Map<String, Number> listAccounts(int var1) throws BitcoinRpcException;

    public List<ReceivedAddress> listReceivedByAddress() throws BitcoinRpcException;

    public List<ReceivedAddress> listReceivedByAddress(int var1) throws BitcoinRpcException;

    public List<ReceivedAddress> listReceivedByAddress(int var1, boolean var2) throws BitcoinRpcException;

    public TransactionsSinceBlock listSinceBlock() throws BitcoinRpcException;

    public TransactionsSinceBlock listSinceBlock(String var1) throws BitcoinRpcException;

    public TransactionsSinceBlock listSinceBlock(String var1, int var2) throws BitcoinRpcException;

    public List<Transaction> listTransactions() throws BitcoinRpcException;

    public List<Transaction> listTransactions(String var1) throws BitcoinRpcException;

    public List<Transaction> listTransactions(String var1, int var2) throws BitcoinRpcException;

    public List<Transaction> listTransactions(String var1, int var2, int var3) throws BitcoinRpcException;

    public List<Unspent> listUnspent() throws BitcoinRpcException;

    public List<Unspent> listUnspent(int var1) throws BitcoinRpcException;

    public List<Unspent> listUnspent(int var1, int var2) throws BitcoinRpcException;

    public List<Unspent> listUnspent(int var1, int var2, String ... var3) throws BitcoinRpcException;

    public String move(String var1, String var2, double var3) throws BitcoinRpcException;

    public String move(String var1, String var2, double var3, int var5) throws BitcoinRpcException;

    public String move(String var1, String var2, double var3, int var5, String var6) throws BitcoinRpcException;

    public String sendFrom(String var1, String var2, double var3) throws BitcoinRpcException;

    public String sendFrom(String var1, String var2, double var3, int var5) throws BitcoinRpcException;

    public String sendFrom(String var1, String var2, double var3, int var5, String var6) throws BitcoinRpcException;

    public String sendFrom(String var1, String var2, double var3, int var5, String var6, String var7) throws BitcoinRpcException;

    public String sendRawTransaction(String var1) throws BitcoinRpcException;

    public String sendToAddress(String var1, double var2) throws BitcoinRpcException;

    public String sendToAddress(String var1, double var2, String var4) throws BitcoinRpcException;

    public String sendToAddress(String var1, double var2, String var4, String var5) throws BitcoinRpcException;

    public String signRawTransaction(String var1, List<ExtendedTxInput> var2, List<String> var3) throws BitcoinRpcException;

    public void setGenerate(boolean var1) throws BitcoinRPCException;

    public List<String> generate(int var1) throws BitcoinRPCException;

    public AddressValidationResult validateAddress(String var1) throws BitcoinRpcException;

    public double getEstimateFee(int var1) throws BitcoinRpcException;

    public double getEstimatePriority(int var1) throws BitcoinRpcException;

    public void invalidateBlock(String var1) throws BitcoinRpcException;

    public void reconsiderBlock(String var1) throws BitcoinRpcException;

    public List<PeerInfoResult> getPeerInfo();

    public void stop();

    public String getRawChangeAddress();

    public long getConnectionCount();

    public double getUnconfirmedBalance();

    public double getDifficulty();

    public void ping();

    public DecodedScript decodeScript(String var1);

    public NetTotals getNetTotals();

    public boolean getGenerate();

    public double getNetworkHashPs();

    public boolean setTxFee(BigDecimal var1);

    public void addNode(String var1, String var2);

    public void backupWallet(String var1);

    public String signMessage(String var1, String var2);

    public void dumpWallet(String var1);

    public void importWallet(String var1);

    public void keyPoolRefill();

    public BigDecimal getReceivedByAccount(String var1);

    public void encryptWallet(String var1);

    public void walletPassPhrase(String var1, long var2);

    public boolean verifyMessage(String var1, String var2, String var3);

    public String addMultiSigAddress(int var1, List<String> var2);

    public String addMultiSigAddress(int var1, List<String> var2, String var3);

    public boolean verifyChain();

    public List<NodeInfo> getAddedNodeInfo(boolean var1, String var2);

    public void submitBlock(String var1);

    public TxOut getTxOut(String var1, long var2);

    public static interface PeerInfoResult
    extends Serializable {
        public long getId();

        public String getAddr();

        public String getAddrLocal();

        public String getServices();

        public long getLastSend();

        public long getLastRecv();

        public long getBytesSent();

        public long getBytesRecv();

        public long getConnTime();

        public int getTimeOffset();

        public double getPingTime();

        public long getVersion();

        public String getSubVer();

        public boolean isInbound();

        public int getStartingHeight();

        public long getBanScore();

        public int getSyncedHeaders();

        public int getSyncedBlocks();

        public boolean isWhiteListed();
    }

    public static interface AddressValidationResult
    extends Serializable {
        public boolean isValid();

        public String address();

        public boolean isMine();

        public boolean isScript();

        public String pubKey();

        public boolean isCompressed();

        public String account();
    }

    public static interface Unspent
    extends TxInput,
    TxOutput,
    Serializable {
        @Override
        public String txid();

        @Override
        public int vout();

        @Override
        public String address();

        public String account();

        @Override
        public String scriptPubKey();

        @Override
        public double amount();

        public int confirmations();
    }

    public static interface TransactionsSinceBlock
    extends Serializable {
        public List<Transaction> transactions();

        public String lastBlock();
    }

    public static interface Transaction
    extends Serializable {
        public String account();

        public String address();

        public String category();

        public double amount();

        public double fee();

        public int confirmations();

        public String blockHash();

        public int blockIndex();

        public Date blockTime();

        public String txId();

        public Date time();

        public Date timeReceived();

        public String comment();

        public String commentTo();

        public RawTransaction raw();
    }

    public static interface ReceivedAddress
    extends Serializable {
        public String address();

        public String account();

        public double amount();

        public int confirmations();
    }

    public static interface RawTransaction
    extends Serializable {
        public String hex();

        public String txId();

        public int version();

        public long lockTime();

        public long size();

        public long vsize();

        public String hash();

        public List<In> vIn();

        public List<Out> vOut();

        public String blockHash();

        public int confirmations();

        public Date time();

        public Date blocktime();

        public static interface Out
        extends Serializable {
            public double value();

            public int n();

            public ScriptPubKey scriptPubKey();

            public TxInput toInput();

            public RawTransaction transaction();

            public static interface ScriptPubKey
            extends Serializable {
                public String asm();

                public String hex();

                public int reqSigs();

                public String type();

                public List<String> addresses();
            }
        }

        public static interface In
        extends TxInput,
        Serializable {
            public Map<String, Object> scriptSig();

            public long sequence();

            public RawTransaction getTransaction();

            public Out getTransactionOutput();
        }
    }

    public static interface TxOutSetInfo
    extends Serializable {
        public long height();

        public String bestBlock();

        public long transactions();

        public long txouts();

        public long bytesSerialized();

        public String hashSerialized();

        public BigDecimal totalAmount();
    }

    public static interface Block
    extends Serializable {
        public String hash();

        public int confirmations();

        public int size();

        public int height();

        public int version();

        public String merkleRoot();

        public List<String> tx();

        public Date time();

        public long nonce();

        public String bits();

        public double difficulty();

        public String previousHash();

        public String nextHash();

        public String chainwork();

        public Block previous() throws BitcoinRpcException;

        public Block next() throws BitcoinRpcException;
    }

    public static interface TxOut
    extends Serializable {
        public String bestBlock();

        public long confirmations();

        public BigDecimal value();

        public String asm();

        public String hex();

        public long reqSigs();

        public String type();

        public List<String> addresses();

        public long version();

        public boolean coinBase();
    }

    public static interface Address
    extends Serializable {
        public String address();

        public String connected();
    }

    public static interface NodeInfo
    extends Serializable {
        public String addedNode();

        public boolean connected();

        public List<Address> addresses();
    }

    public static interface MultiSig
    extends Serializable {
        public String address();

        public String redeemScript();
    }

    public static interface Network
    extends Serializable {
        public String name();

        public boolean limited();

        public boolean reachable();

        public String proxy();

        public boolean proxyRandomizeCredentials();
    }

    public static interface NetworkInfo
    extends Serializable {
        public long version();

        public String subversion();

        public long protocolVersion();

        public String localServices();

        public boolean localRelay();

        public long timeOffset();

        public long connections();

        public List<Network> networks();

        public BigDecimal relayFee();

        public List<String> localAddresses();

        public String warnings();
    }

    public static interface WalletInfo
    extends Serializable {
        public long walletVersion();

        public BigDecimal balance();

        public BigDecimal unconfirmedBalance();

        public BigDecimal immatureBalance();

        public long txCount();

        public long keyPoolOldest();

        public long keyPoolSize();

        public long unlockedUntil();

        public BigDecimal payTxFee();

        public String hdMasterKeyId();
    }

    public static interface DecodedScript
    extends Serializable {
        public String asm();

        public String hex();

        public String type();

        public int reqSigs();

        public List<String> addresses();

        public String p2sh();
    }

    public static interface BlockChainInfo
    extends Serializable {
        public String chain();

        public int blocks();

        public String bestBlockHash();

        public double difficulty();

        public double verificationProgress();

        public String chainWork();
    }

    public static interface NetTotals
    extends Serializable {
        public long totalBytesRecv();

        public long totalBytesSent();

        public long timeMillis();

        public uploadTarget uploadTarget();

        public static interface uploadTarget
        extends Serializable {
            public long timeFrame();

            public int target();

            public boolean targetReached();

            public boolean serveHistoricalBlocks();

            public long bytesLeftInCycle();

            public long timeLeftInCycle();
        }
    }

    public static interface MiningInfo
    extends Serializable {
        public int blocks();

        public int currentBlockSize();

        public int currentBlockWeight();

        public int currentBlockTx();

        public double difficulty();

        public String errors();

        public double networkHashps();

        public int pooledTx();

        public boolean testNet();

        public String chain();
    }

    public static interface Info
    extends Serializable {
        public long version();

        public long protocolVersion();

        public long walletVersion();

        public double balance();

        public int blocks();

        public int timeOffset();

        public int connections();

        public String proxy();

        public double difficulty();

        public boolean testnet();

        public long keyPoolOldest();

        public long keyPoolSize();

        public double payTxFee();

        public double relayFee();

        public String errors();
    }

    public static class BasicTxOutput
    implements TxOutput {
        public String address;
        public double amount;

        public BasicTxOutput(String address, double amount) {
            this.address = address;
            this.amount = amount;
        }

        @Override
        public String address() {
            return this.address;
        }

        @Override
        public double amount() {
            return this.amount;
        }
    }

    public static interface TxOutput
    extends Serializable {
        public String address();

        public double amount();
    }

    public static class ExtendedTxInput
    extends BasicTxInput {
        public String redeemScript;
        public BigDecimal amount;

        public ExtendedTxInput(String txid, int vout) {
            super(txid, vout);
        }

        public ExtendedTxInput(String txid, int vout, String scriptPubKey) {
            super(txid, vout, scriptPubKey);
        }

        public ExtendedTxInput(String txid, int vout, String scriptPubKey, String redeemScript, BigDecimal amount) {
            super(txid, vout, scriptPubKey);
            this.redeemScript = redeemScript;
            this.amount = amount;
        }

        public String redeemScript() {
            return this.redeemScript;
        }

        public BigDecimal amount() {
            return this.amount;
        }
    }

    public static class BasicTxInput
    implements TxInput {
        public String txid;
        public int vout;
        public String scriptPubKey;

        public BasicTxInput(String txid, int vout) {
            this.txid = txid;
            this.vout = vout;
        }

        public BasicTxInput(String txid, int vout, String scriptPubKey) {
            this(txid, vout);
            this.scriptPubKey = scriptPubKey;
        }

        @Override
        public String txid() {
            return this.txid;
        }

        @Override
        public int vout() {
            return this.vout;
        }

        @Override
        public String scriptPubKey() {
            return this.scriptPubKey;
        }
    }

    public static interface TxInput
    extends Serializable {
        public String txid();

        public int vout();

        public String scriptPubKey();
    }
}

