package uk.num.modules.registrant.expanded;

import java.io.IOException;
import java.io.IOException;
import com.fasterxml.jackson.core.*;
import com.fasterxml.jackson.databind.*;
import com.fasterxml.jackson.databind.annotation.*;
import com.fasterxml.jackson.core.type.*;
import java.util.List;

@JsonDeserialize(using = Address.Deserializer.class)
@JsonSerialize(using = Address.Serializer.class)
public class Address {
    public AddressClass addressClassValue;
    public List<Object> anythingArrayValue;

    static class Deserializer extends JsonDeserializer<Address> {
        @Override
        public Address deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Address value = new Address();
            switch (jsonParser.currentToken()) {
                case VALUE_NULL:
                    break;
                case START_ARRAY:
                    value.anythingArrayValue = jsonParser.readValueAs(new TypeReference<List<Object>>() {});
                    break;
                case START_OBJECT:
                    value.addressClassValue = jsonParser.readValueAs(AddressClass.class);
                    break;
                default: throw new IOException("Cannot deserialize Address");
            }
            return value;
        }
    }

    static class Serializer extends JsonSerializer<Address> {
        @Override
        public void serialize(Address obj, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (obj.addressClassValue != null) {
                jsonGenerator.writeObject(obj.addressClassValue);
                return;
            }
            if (obj.anythingArrayValue != null) {
                jsonGenerator.writeObject(obj.anythingArrayValue);
                return;
            }
            jsonGenerator.writeNull();
        }
    }
}
