package uk.num.modules.registrant.compact;

import java.io.IOException;
import java.io.IOException;
import com.fasterxml.jackson.core.*;
import com.fasterxml.jackson.databind.*;
import com.fasterxml.jackson.databind.annotation.*;
import com.fasterxml.jackson.core.type.*;
import java.util.List;

@JsonDeserialize(using = Party.Deserializer.class)
@JsonSerialize(using = Party.Serializer.class)
public class Party {
    public List<Object> anythingArrayValue;
    public PartyClass partyClassValue;

    static class Deserializer extends JsonDeserializer<Party> {
        @Override
        public Party deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Party value = new Party();
            switch (jsonParser.currentToken()) {
                case VALUE_NULL:
                    break;
                case START_ARRAY:
                    value.anythingArrayValue = jsonParser.readValueAs(new TypeReference<List<Object>>() {});
                    break;
                case START_OBJECT:
                    value.partyClassValue = jsonParser.readValueAs(PartyClass.class);
                    break;
                default: throw new IOException("Cannot deserialize Party");
            }
            return value;
        }
    }

    static class Serializer extends JsonSerializer<Party> {
        @Override
        public void serialize(Party obj, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (obj.anythingArrayValue != null) {
                jsonGenerator.writeObject(obj.anythingArrayValue);
                return;
            }
            if (obj.partyClassValue != null) {
                jsonGenerator.writeObject(obj.partyClassValue);
                return;
            }
            jsonGenerator.writeNull();
        }
    }
}
