package uk.num.modules.contacts.compact;

import java.io.IOException;
import java.io.IOException;
import com.fasterxml.jackson.core.*;
import com.fasterxml.jackson.databind.*;
import com.fasterxml.jackson.databind.annotation.*;
import com.fasterxml.jackson.core.type.*;
import java.util.List;

@JsonDeserialize(using = Person.Deserializer.class)
@JsonSerialize(using = Person.Serializer.class)
public class Person {
    public List<Object> anythingArrayValue;
    public PersonClass personClassValue;

    static class Deserializer extends JsonDeserializer<Person> {
        @Override
        public Person deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Person value = new Person();
            switch (jsonParser.currentToken()) {
                case VALUE_NULL:
                    break;
                case START_ARRAY:
                    value.anythingArrayValue = jsonParser.readValueAs(new TypeReference<List<Object>>() {});
                    break;
                case START_OBJECT:
                    value.personClassValue = jsonParser.readValueAs(PersonClass.class);
                    break;
                default: throw new IOException("Cannot deserialize Person");
            }
            return value;
        }
    }

    static class Serializer extends JsonSerializer<Person> {
        @Override
        public void serialize(Person obj, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (obj.anythingArrayValue != null) {
                jsonGenerator.writeObject(obj.anythingArrayValue);
                return;
            }
            if (obj.personClassValue != null) {
                jsonGenerator.writeObject(obj.personClassValue);
                return;
            }
            jsonGenerator.writeNull();
        }
    }
}
