package uk.num.modules.contacts.compact;

import java.io.IOException;
import java.io.IOException;
import com.fasterxml.jackson.core.*;
import com.fasterxml.jackson.databind.*;
import com.fasterxml.jackson.databind.annotation.*;
import com.fasterxml.jackson.core.type.*;
import java.util.List;

@JsonDeserialize(using = Organisation.Deserializer.class)
@JsonSerialize(using = Organisation.Serializer.class)
public class Organisation {
    public List<Object> anythingArrayValue;
    public OrganisationClass organisationClassValue;

    static class Deserializer extends JsonDeserializer<Organisation> {
        @Override
        public Organisation deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Organisation value = new Organisation();
            switch (jsonParser.currentToken()) {
                case VALUE_NULL:
                    break;
                case START_ARRAY:
                    value.anythingArrayValue = jsonParser.readValueAs(new TypeReference<List<Object>>() {});
                    break;
                case START_OBJECT:
                    value.organisationClassValue = jsonParser.readValueAs(OrganisationClass.class);
                    break;
                default: throw new IOException("Cannot deserialize Organisation");
            }
            return value;
        }
    }

    static class Serializer extends JsonSerializer<Organisation> {
        @Override
        public void serialize(Organisation obj, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (obj.anythingArrayValue != null) {
                jsonGenerator.writeObject(obj.anythingArrayValue);
                return;
            }
            if (obj.organisationClassValue != null) {
                jsonGenerator.writeObject(obj.organisationClassValue);
                return;
            }
            jsonGenerator.writeNull();
        }
    }
}
