package uk.num.modules.contacts.compact;

import java.io.IOException;
import java.io.IOException;
import com.fasterxml.jackson.core.*;
import com.fasterxml.jackson.databind.*;
import com.fasterxml.jackson.databind.annotation.*;
import com.fasterxml.jackson.core.type.*;
import java.util.List;

@JsonDeserialize(using = Location.Deserializer.class)
@JsonSerialize(using = Location.Serializer.class)
public class Location {
    public List<Object> anythingArrayValue;
    public LocationClass locationClassValue;

    static class Deserializer extends JsonDeserializer<Location> {
        @Override
        public Location deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Location value = new Location();
            switch (jsonParser.currentToken()) {
                case VALUE_NULL:
                    break;
                case START_ARRAY:
                    value.anythingArrayValue = jsonParser.readValueAs(new TypeReference<List<Object>>() {});
                    break;
                case START_OBJECT:
                    value.locationClassValue = jsonParser.readValueAs(LocationClass.class);
                    break;
                default: throw new IOException("Cannot deserialize Location");
            }
            return value;
        }
    }

    static class Serializer extends JsonSerializer<Location> {
        @Override
        public void serialize(Location obj, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (obj.anythingArrayValue != null) {
                jsonGenerator.writeObject(obj.anythingArrayValue);
                return;
            }
            if (obj.locationClassValue != null) {
                jsonGenerator.writeObject(obj.locationClassValue);
                return;
            }
            jsonGenerator.writeNull();
        }
    }
}
