package uk.num.modules.contacts.compact;

import java.io.IOException;
import java.io.IOException;
import com.fasterxml.jackson.core.*;
import com.fasterxml.jackson.databind.*;
import com.fasterxml.jackson.databind.annotation.*;
import com.fasterxml.jackson.core.type.*;
import java.util.List;

@JsonDeserialize(using = Group.Deserializer.class)
@JsonSerialize(using = Group.Serializer.class)
public class Group {
    public List<Object> anythingArrayValue;
    public GroupClass groupClassValue;

    static class Deserializer extends JsonDeserializer<Group> {
        @Override
        public Group deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Group value = new Group();
            switch (jsonParser.currentToken()) {
                case VALUE_NULL:
                    break;
                case START_ARRAY:
                    value.anythingArrayValue = jsonParser.readValueAs(new TypeReference<List<Object>>() {});
                    break;
                case START_OBJECT:
                    value.groupClassValue = jsonParser.readValueAs(GroupClass.class);
                    break;
                default: throw new IOException("Cannot deserialize Group");
            }
            return value;
        }
    }

    static class Serializer extends JsonSerializer<Group> {
        @Override
        public void serialize(Group obj, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (obj.anythingArrayValue != null) {
                jsonGenerator.writeObject(obj.anythingArrayValue);
                return;
            }
            if (obj.groupClassValue != null) {
                jsonGenerator.writeObject(obj.groupClassValue);
                return;
            }
            jsonGenerator.writeNull();
        }
    }
}
