package uk.num.modules.contacts.compact;

import java.io.IOException;
import java.io.IOException;
import com.fasterxml.jackson.core.*;
import com.fasterxml.jackson.databind.*;
import com.fasterxml.jackson.databind.annotation.*;
import com.fasterxml.jackson.core.type.*;
import java.util.List;

@JsonDeserialize(using = Employee.Deserializer.class)
@JsonSerialize(using = Employee.Serializer.class)
public class Employee {
    public List<Object> anythingArrayValue;
    public EmployeeClass employeeClassValue;

    static class Deserializer extends JsonDeserializer<Employee> {
        @Override
        public Employee deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Employee value = new Employee();
            switch (jsonParser.currentToken()) {
                case VALUE_NULL:
                    break;
                case START_ARRAY:
                    value.anythingArrayValue = jsonParser.readValueAs(new TypeReference<List<Object>>() {});
                    break;
                case START_OBJECT:
                    value.employeeClassValue = jsonParser.readValueAs(EmployeeClass.class);
                    break;
                default: throw new IOException("Cannot deserialize Employee");
            }
            return value;
        }
    }

    static class Serializer extends JsonSerializer<Employee> {
        @Override
        public void serialize(Employee obj, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (obj.anythingArrayValue != null) {
                jsonGenerator.writeObject(obj.anythingArrayValue);
                return;
            }
            if (obj.employeeClassValue != null) {
                jsonGenerator.writeObject(obj.employeeClassValue);
                return;
            }
            jsonGenerator.writeNull();
        }
    }
}
