package uk.num.modules.contacts.compact;

import java.io.IOException;
import java.io.IOException;
import com.fasterxml.jackson.core.*;
import com.fasterxml.jackson.databind.*;
import com.fasterxml.jackson.databind.annotation.*;
import com.fasterxml.jackson.core.type.*;
import java.util.List;

@JsonDeserialize(using = Department.Deserializer.class)
@JsonSerialize(using = Department.Serializer.class)
public class Department {
    public List<Object> anythingArrayValue;
    public DepartmentClass departmentClassValue;

    static class Deserializer extends JsonDeserializer<Department> {
        @Override
        public Department deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Department value = new Department();
            switch (jsonParser.currentToken()) {
                case VALUE_NULL:
                    break;
                case START_ARRAY:
                    value.anythingArrayValue = jsonParser.readValueAs(new TypeReference<List<Object>>() {});
                    break;
                case START_OBJECT:
                    value.departmentClassValue = jsonParser.readValueAs(DepartmentClass.class);
                    break;
                default: throw new IOException("Cannot deserialize Department");
            }
            return value;
        }
    }

    static class Serializer extends JsonSerializer<Department> {
        @Override
        public void serialize(Department obj, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (obj.anythingArrayValue != null) {
                jsonGenerator.writeObject(obj.anythingArrayValue);
                return;
            }
            if (obj.departmentClassValue != null) {
                jsonGenerator.writeObject(obj.departmentClassValue);
                return;
            }
            jsonGenerator.writeNull();
        }
    }
}
