package uk.num.modules.contacts.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;

public class ObjectMapperFactory {
  private static ObjectMapper mapper = null;

  private ObjectMapperFactory() {
  }

  public static ObjectMapper instance() {
    if (mapper == null) {
      mapper = new ObjectMapper();
      final SimpleModule module = new SimpleModule();
      module.addSerializer(String.class, new CustomStringSerializer());
      mapper.registerModule(module);
    }
    return mapper;
  }

}
