package uk.num.json_modl.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.commons.lang3.StringUtils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;

class UtilFuncs {
    private static final Pattern shouldBeQuoted = Pattern.compile(".*[()\\[\\];{}:=].*");
    private static final ObjectMapper mapper = new ObjectMapper();
    /**
     * Convert JSON to a JsonNode
     */
    static Function<String, JsonNode> mapJson = (s) -> {
        try {
            return (mapper.readTree(s));
        } catch (final IOException e) {
            throw new RuntimeException(e);
        }
    };
    /**
     * Convert an ArrayNode to a List of JsonNodes
     */
    static Function<ArrayNode, List<JsonNode>> toList = (node) -> {
        final List<JsonNode> nodes = new ArrayList<>();

        for (int i = 0; i < node.size(); i++) {
            nodes.add(node.get(i));
        }
        return nodes;
    };
    /**
     * Convert the elements of a JsonNode to a List of NamedNode objects
     */
    static Function<JsonNode, List<NamedNode>> toNamedNodeList = (node) -> {
        final Iterator<String> elements = node.fieldNames();
        final List<NamedNode> nodes = new ArrayList<>();

        while (elements.hasNext()) {
            final String field = elements.next();
            nodes.add(new NamedNode(field, node.get(field)));
        }
        return nodes;
    };
    /**
     * Some MODL string need backtick quotes.
     */
    private static Function<String, String> quoteIfNecessary = (s) -> (shouldBeQuoted.matcher(s)
            .matches()) || StringUtils.isEmpty(s) ? "`" + s + "`" : s;
    /**
     * Handy function composition
     */
    static final Function<String, String> escapeAndQuote = UtilFuncs.quoteIfNecessary.compose(UnicodeEscaper.escape);

}
