package uk.num.json_modl.converter;

import java.util.function.Function;
import java.util.stream.Collectors;

class UnicodeEscaper {
    /**
     * Unicode escapes for non-ASCII values.
     */
    static Function<String, String> escape = (s) -> s.codePoints()
            .mapToObj(UnicodeEscaper::escape)
            .collect(Collectors.joining());

    /**
     * Unicode escapes for non-ASCII characters.
     *
     * @param c the codepoint to be checked
     * @return a String with escaped unicode sequences if necessary.
     */
    private static String escape(final int c) {
        if (c >= 32 && c <= 127) {
            return String.valueOf(Character.toChars(c));
        } else if (c >= 0x100000 && c <= 0x10ffff) {
            return String.format("~u%06x", c);
        } else if (c >= 0x10000 && c <= 0xfffff) {
            return String.format("~u%05x", c);
        } else {
            return String.format("~u%04x", c);
        }
    }
}
