package uk.num.json_modl.converter;

import lombok.extern.log4j.Log4j2;
import uk.modl.interpreter.Interpreter;
import uk.modl.modlObject.ModlObject;
import uk.modl.parser.printers.JsonPrinter;

import java.io.IOException;
import java.util.function.BiFunction;
import java.util.function.Function;

@Log4j2
class ModlVerifier {
    /**
     * Function to apply the MODL interpreter
     */
    private static Function<String, String> interpretModl = (modl) -> {
        try {
            final ModlObject modlObject = Interpreter.interpret(modl);
            return JsonPrinter.printModl(modlObject);
        } catch (final IOException e) {
            throw new RuntimeException(e);
        }
    };
    /**
     * Run the generated MODL through the interpreter to check for errors.
     */
    static BiFunction<String, String, String> verifyModl = (modl, json) -> {
        //
        // If the interpreter doesn't throw an exception then we should be ok, but we will log differences
        // between the input JSON and the JSON generated from the JSON-to-MODL conversion.
        //
        final String output = interpretModl.apply(modl);

        //
        // Make some general changes to make the results more likely to be comparable
        //
        final String expected = json.replace(" ", "")
                .replace("\n", "")
                .replace("\r", "");
        final String actual = output.replace(" ", "")
                .replace("\n", "")
                .replace("\r", "");

        //
        // Log any differences but continue with the generated MODL
        //
        if (!expected.equals(actual)) {
            log.error("Failed: Expected: {}", expected);
            log.error("Failed: Actual  : {}", actual);
            // Fall through to return the MODL anyway
        }
        return modl;
    };
}
