/*
 * Decompiled with CFR 0.152.
 */
package uk.num.json_modl.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import uk.num.json_modl.converter.NamedNode;
import uk.num.json_modl.converter.UnicodeEscaper;

class UtilFuncs {
    private static final Pattern shouldBeQuoted = Pattern.compile(".*[()\\[\\];{}:=].*");
    private static final ObjectMapper mapper = new ObjectMapper();
    static Function<String, JsonNode> mapJson = s -> {
        try {
            return mapper.readTree(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    };
    static Function<ArrayNode, List<JsonNode>> toList = node -> {
        ArrayList<JsonNode> nodes = new ArrayList<JsonNode>();
        for (int i = 0; i < node.size(); ++i) {
            nodes.add(node.get(i));
        }
        return nodes;
    };
    static Function<JsonNode, List<NamedNode>> toNamedNodeList = node -> {
        Iterator elements = node.fieldNames();
        ArrayList<NamedNode> nodes = new ArrayList<NamedNode>();
        while (elements.hasNext()) {
            String field = (String)elements.next();
            nodes.add(new NamedNode(field, node.get(field)));
        }
        return nodes;
    };
    private static Function<String, String> quoteIfNecessary = s -> shouldBeQuoted.matcher((CharSequence)s).matches() ? "`" + s + "`" : s;
    static final Function<String, String> escapeAndQuote = quoteIfNecessary.compose(UnicodeEscaper.escape);

    UtilFuncs() {
    }
}

