/*
 * Decompiled with CFR 0.152.
 */
package iterator;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public final class Reflection {
    private static final Logger LOG = LoggerFactory.getLogger(Reflection.class);

    public static <A extends Annotation, T> T findAnnotationMemberDefault(Class<A> annotationClass, String memberName) {
        return Reflection.find(Reflection.getAnnotationMemberDefaultCallback(annotationClass, memberName));
    }

    public static Field findField(Class<?> clazz, String fieldName) {
        return Reflection.find(Reflection.getFieldCallback(clazz, fieldName));
    }

    public static <A extends Annotation> A findFieldAnnotation(Class<?> clazz, String fieldName, Class<A> annotationClass) {
        Field f = Reflection.findField(clazz, fieldName);
        return f != null ? (A)f.getAnnotation(annotationClass) : null;
    }

    public static <A extends Annotation> A findTypeAnnotation(Class<?> clazz, Class<A> annotationClass) {
        return (A)AnnotationUtils.findAnnotation(clazz, annotationClass);
    }

    public static <A extends Annotation, T> T getAnnotationMemberDefault(Class<A> annotationClass, String memberName) {
        return Reflection.get(Reflection.getAnnotationMemberDefaultCallback(annotationClass, memberName));
    }

    public static <A extends Annotation> Class<?> getAnnotationMemberType(Class<A> annotationClass, String memberName) {
        return Reflection.get(Reflection.getAnnotationMemberTypeCallback(annotationClass, memberName));
    }

    public static <A extends Annotation, T> T getAnnotationMemberValue(A annotation, String memberName) {
        return Reflection.get(Reflection.getAnnotationMemberValueCallback(annotation, memberName));
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        return Reflection.get(Reflection.getFieldCallback(clazz, fieldName));
    }

    public static <A extends Annotation> A getFieldAnnotation(Class<?> clazz, String fieldName, Class<A> annotationClass) {
        return Reflection.getField(clazz, fieldName).getAnnotation(annotationClass);
    }

    public static <O, T> T getFieldValue(O instance, String fieldName) {
        try {
            Field f = Reflection.findField(instance.getClass(), fieldName);
            f.setAccessible(true);
            return (T)f.get(instance);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Unable to retrieve value of field %s from instance %s", fieldName, instance), e);
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object ... args) {
        try {
            return (T)ConstructorUtils.invokeConstructor(clazz, (Object[])args);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Deprecated(since="2.2.6", forRemoval=true)
    public static <T> void setField(T instance, String fieldName, Object value) {
        Reflection.setFieldValue(instance, fieldName, value);
    }

    public static <T> void setFieldValue(T instance, String fieldName, Object value) {
        try {
            Field f = Reflection.findField(instance.getClass(), fieldName);
            f.setAccessible(true);
            f.set(instance, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot set '" + fieldName + "' to '" + value + "' on " + instance, e);
        }
    }

    private static <T> T find(Callback<T> callback) {
        try {
            return callback.execute();
        }
        catch (Exception e) {
            LOG.debug("Find callback failed. Were you expecting a value here?", (Throwable)e);
            return null;
        }
    }

    private static <T> T get(Callback<T> callback) {
        try {
            return callback.execute();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static <T, A extends Annotation> Callback<T> getAnnotationMemberDefaultCallback(Class<A> annotationClass, String memberName) {
        return () -> annotationClass.getDeclaredMethod(memberName, new Class[0]).getDefaultValue();
    }

    private static <A extends Annotation> Callback<Class<?>> getAnnotationMemberTypeCallback(Class<A> annotationClass, String memberName) {
        return () -> annotationClass.getDeclaredMethod(memberName, new Class[0]).getReturnType();
    }

    private static <T, A extends Annotation> Callback<T> getAnnotationMemberValueCallback(A annotation, String memberName) {
        return () -> annotation.annotationType().getDeclaredMethod(memberName, new Class[0]).invoke((Object)annotation, new Object[0]);
    }

    private static Callback<Field> getFieldCallback(Class<?> clazz, String fieldName) {
        return () -> {
            Field f = ReflectionUtils.findField((Class)clazz, (String)fieldName);
            if (f == null) {
                throw new NoSuchFieldException(String.format("Could not locate field %s in class %s", fieldName, clazz));
            }
            return f;
        };
    }

    private Reflection() {
        throw new IllegalStateException();
    }

    @FunctionalInterface
    static interface Callback<T> {
        public T execute() throws ReflectiveOperationException;
    }
}

