/*
 * Decompiled with CFR 0.152.
 */
package uk.co.evoco.webdriver.utils;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.Sleeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.evoco.webdriver.configuration.TestConfigHelper;
import uk.co.evoco.webdriver.utils.SelectBoxInteractionType;

public class TolerantInteraction {
    private final Logger logger = LoggerFactory.getLogger(TolerantInteraction.class);
    private final Clock clock = Clock.systemDefaultZone();
    private Instant end;
    private final Sleeper sleeper = Sleeper.SYSTEM_SLEEPER;
    private final Duration intervalDuration = Duration.ofMillis(500L);
    private Throwable lastException = null;

    public WebElement tolerantInteraction(WebElement webElement, SelectBoxInteractionType selectBoxInteractionType, Optional<String> visibleTextOrHtmlValueString, Optional<Integer> itemIndex, int timeoutInSeconds) throws Throwable {
        this.end = this.clock.instant().plusSeconds(timeoutInSeconds);
        while (true) {
            try {
                if (Boolean.TRUE.equals(webElement.isEnabled())) {
                    visibleTextOrHtmlValueString.ifPresent(text -> this.interact(new Select(webElement), (String)text, selectBoxInteractionType));
                    itemIndex.ifPresent(index -> this.interact(new Select(webElement), (int)index));
                    return webElement;
                }
            }
            catch (Throwable e) {
                this.lastException = this.propagateIfNotIgnored(e);
            }
            if (this.end.isBefore(this.clock.instant())) {
                if (null == this.lastException) {
                    this.logger.error("Exception condition failed: Timeout (tried for {} seconds with 500ms interval", (Object)timeoutInSeconds);
                    this.lastException = new TimeoutException();
                } else {
                    this.logger.error("Exception condition failed: {} (tried for {} seconds with 500ms interval", (Object)this.lastException.getCause(), (Object)timeoutInSeconds);
                }
                throw this.lastException;
            }
            try {
                this.sleeper.sleep(this.intervalDuration);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WebDriverException((Throwable)e);
            }
        }
    }

    public WebElement tolerantInteraction(List<WebElement> webElements, String visibleText, int timeoutInSeconds) throws Throwable {
        this.end = this.clock.instant().plusSeconds(timeoutInSeconds);
        while (true) {
            try {
                for (WebElement webElement : webElements) {
                    if (!webElement.getText().equals(visibleText)) continue;
                    this.interact(webElement);
                    return webElement;
                }
            }
            catch (Throwable e) {
                this.lastException = this.propagateIfNotIgnored(e);
            }
            if (this.end.isBefore(this.clock.instant())) {
                if (null == this.lastException) {
                    this.logger.error("Exception condition failed: Timeout (tried for {} seconds with 500ms interval", (Object)timeoutInSeconds);
                    this.lastException = new TimeoutException();
                } else {
                    this.logger.error("Exception condition failed: {} (tried for {} seconds with 500ms interval", (Object)this.lastException.getCause(), (Object)timeoutInSeconds);
                }
                throw this.lastException;
            }
            try {
                this.sleeper.sleep(this.intervalDuration);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WebDriverException((Throwable)e);
            }
        }
    }

    public WebElement tolerantInteraction(WebElement webElement, Optional<String> textToType, int timeoutInSeconds) throws Throwable {
        this.end = this.clock.instant().plusSeconds(timeoutInSeconds);
        while (true) {
            try {
                if (Boolean.TRUE.equals(webElement.isEnabled())) {
                    textToType.ifPresentOrElse(text -> this.interact(webElement, (String)text), () -> this.interact(webElement));
                    return webElement;
                }
            }
            catch (Throwable e) {
                this.lastException = this.propagateIfNotIgnored(e);
            }
            if (this.end.isBefore(this.clock.instant())) {
                if (null == this.lastException) {
                    this.logger.error("Exception condition failed: Timeout (tried for {} seconds with 500ms interval", (Object)timeoutInSeconds);
                    this.lastException = new TimeoutException();
                } else {
                    this.logger.error("Exception condition failed: {} (tried for {} seconds with 500ms interval", (Object)this.lastException.getCause(), (Object)timeoutInSeconds);
                }
                throw this.lastException;
            }
            try {
                this.sleeper.sleep(this.intervalDuration);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WebDriverException((Throwable)e);
            }
        }
    }

    private void interact(WebElement webElement, String textToType) {
        webElement.sendKeys(new CharSequence[]{textToType});
    }

    private void interact(WebElement webElement) {
        webElement.click();
    }

    private void interact(Select selectBox, String value, SelectBoxInteractionType selectBoxInteractionType) {
        switch (selectBoxInteractionType) {
            case BY_VALUE: {
                selectBox.selectByValue(value);
                break;
            }
            case BY_VISIBLE_TEXT: {
                selectBox.selectByVisibleText(value);
                break;
            }
            default: {
                throw new WebDriverException("Must be one of BY_VALUE or BY_VISIBLE_TEXT");
            }
        }
    }

    private void interact(Select selectBox, int index) {
        int normalisedIndex = index - 1;
        selectBox.selectByIndex(normalisedIndex);
    }

    private Throwable propagateIfNotIgnored(Throwable e) throws Throwable {
        for (String ignoredException : TestConfigHelper.get().getTolerantActionExceptions().getExceptionsToHandle()) {
            if (Class.forName(ignoredException).isInstance(e)) {
                this.logger.info("Exception {} will be ignored", (Object)ignoredException);
                continue;
            }
            return e;
        }
        return e;
    }
}

