/*
 * Decompiled with CFR 0.152.
 */
package uk.co.evoco.webdriver.configuration;

import java.io.IOException;
import uk.co.evoco.webdriver.configuration.WebDriverConfig;
import uk.co.evoco.webdriver.configuration.utils.FileLoaderUtils;
import uk.co.evoco.webdriver.utils.JsonUtils;

public class ConfigurationLoader {
    private final String INTERNAL_CONFIGURATION_FILE = "config.json";
    private String targetConfigurationFile;

    public ConfigurationLoader decideWhichConfigurationToUse() {
        String configurationProperty = System.getProperty("config", "DEFAULT");
        if (configurationProperty.toUpperCase().trim().equals("DEFAULT")) {
            this.targetConfigurationFile = "config.json";
            return this;
        }
        if (configurationProperty.toLowerCase().trim().contains(".json")) {
            this.targetConfigurationFile = configurationProperty;
            return this;
        }
        throw new RuntimeException("Issue figuring out what configuration to use");
    }

    public WebDriverConfig build() {
        try {
            return JsonUtils.fromFile(FileLoaderUtils.loadFromClasspathOrFileSystem(this.targetConfigurationFile), WebDriverConfig.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load configuration from " + this.targetConfigurationFile);
        }
    }
}

