/*
 * Decompiled with CFR 0.152.
 */
package uk.co.evoco.webdriver.configuration.driver;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;
import uk.co.evoco.webdriver.WebDriverListener;
import uk.co.evoco.webdriver.configuration.TestConfigHelper;

public interface ConfiguredDriver {
    public WebDriver getLocalDriver() throws IOException;

    public WebDriver getRemoteDriver();

    default public EventFiringWebDriver getDriver(File screenshotPath) throws IOException {
        WebDriver webDriver;
        switch (TestConfigHelper.get().getRunType()) {
            case LOCAL: {
                webDriver = this.getLocalDriver();
                break;
            }
            case GRID: {
                webDriver = this.getRemoteDriver();
                break;
            }
            default: {
                throw new WebDriverException("Must set runType to either LOCAL or GRID in configuration file");
            }
        }
        return this.configureEventFiringWebDriver(webDriver, TestConfigHelper.get().getWebDriverWaitTimeout(), screenshotPath);
    }

    default public EventFiringWebDriver configureEventFiringWebDriver(WebDriver webDriver, long timeout, File screenshotDirectory) {
        EventFiringWebDriver eventFiringWebDriver = new EventFiringWebDriver(webDriver);
        WebDriverListener eventListener = new WebDriverListener();
        eventListener.setScreenshotDirectory(screenshotDirectory);
        eventFiringWebDriver.register((WebDriverEventListener)eventListener);
        return eventFiringWebDriver;
    }

    default public void createLogDirectory() throws IOException {
        FileUtils.forceMkdir((File)new File("./logs"));
    }
}

