/*
 * Decompiled with CFR 0.152.
 */
package uk.co.evoco.webdriver;

import java.io.File;
import java.util.UUID;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.events.WebDriverEventListener;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.evoco.webdriver.configuration.TestConfigHelper;

public class WebDriverListener
implements WebDriverEventListener {
    private static final Logger logger = LoggerFactory.getLogger(WebDriverListener.class);
    private File screenshotDirectory;

    public void setScreenshotDirectory(File screenshotDirectory) {
        this.screenshotDirectory = screenshotDirectory;
    }

    public void beforeAlertAccept(WebDriver webDriver) {
    }

    public void afterAlertAccept(WebDriver webDriver) {
    }

    public void afterAlertDismiss(WebDriver webDriver) {
    }

    public void beforeAlertDismiss(WebDriver webDriver) {
    }

    public void beforeNavigateTo(String s, WebDriver webDriver) {
    }

    public void afterNavigateTo(String s, WebDriver webDriver) {
    }

    public void beforeNavigateBack(WebDriver webDriver) {
    }

    public void afterNavigateBack(WebDriver webDriver) {
    }

    public void beforeNavigateForward(WebDriver webDriver) {
    }

    public void afterNavigateForward(WebDriver webDriver) {
    }

    public void beforeNavigateRefresh(WebDriver webDriver) {
    }

    public void afterNavigateRefresh(WebDriver webDriver) {
    }

    public void beforeFindBy(By by, WebElement webElement, WebDriver webDriver) {
        new WebDriverWait(webDriver, TestConfigHelper.get().getWebDriverWaitTimeout()).until((Function)ExpectedConditions.presenceOfElementLocated((By)by));
    }

    public void afterFindBy(By by, WebElement webElement, WebDriver webDriver) {
    }

    public void beforeClickOn(WebElement webElement, WebDriver webDriver) {
        new WebDriverWait(webDriver, TestConfigHelper.get().getWebDriverWaitTimeout()).until((Function)ExpectedConditions.elementToBeClickable((WebElement)webElement));
    }

    public void afterClickOn(WebElement webElement, WebDriver webDriver) {
    }

    public void beforeChangeValueOf(WebElement webElement, WebDriver webDriver, CharSequence[] charSequences) {
    }

    public void afterChangeValueOf(WebElement webElement, WebDriver webDriver, CharSequence[] charSequences) {
    }

    public void beforeScript(String s, WebDriver webDriver) {
    }

    public void afterScript(String s, WebDriver webDriver) {
    }

    public void beforeSwitchToWindow(String s, WebDriver webDriver) {
    }

    public void afterSwitchToWindow(String s, WebDriver webDriver) {
    }

    public void onException(Throwable throwable, WebDriver webDriver) {
        File scrFile = (File)((TakesScreenshot)webDriver).getScreenshotAs(OutputType.FILE);
        try {
            String filename = UUID.randomUUID().toString() + "-FAILED-" + throwable.getClass().getName() + ".jpeg";
            FileUtils.copyFile((File)scrFile, (File)new File(this.screenshotDirectory.getPath() + "/" + filename));
        }
        catch (Exception e) {
            logger.error("Unable to Save to directory: {}", (Object)this.screenshotDirectory.getPath());
        }
    }

    public <X> void beforeGetScreenshotAs(OutputType<X> outputType) {
    }

    public <X> void afterGetScreenshotAs(OutputType<X> outputType, X x) {
    }

    public void beforeGetText(WebElement webElement, WebDriver webDriver) {
    }

    public void afterGetText(WebElement webElement, WebDriver webDriver, String s) {
    }
}

