/*
 * Decompiled with CFR 0.152.
 */
package uk.co.evoco.testdata;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.restassured.RestAssured;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import uk.co.evoco.testdata.BankHoliday;
import uk.co.evoco.testdata.BankHolidays;
import uk.co.evoco.testdata.Locale;
import uk.co.evoco.webdriver.utils.JsonUtils;

public class Dates
extends MockUnitBase {
    public static String futureDate(String startDate, int daysToAdd, String dateFormat) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)dateFormat);
        DateTime dateTime = DateTime.parse((String)startDate, (DateTimeFormatter)dateTimeFormatter).plusDays(daysToAdd).toDateTime();
        return dateTime.toString(dateTimeFormatter);
    }

    public static String pastDate(String startDate, int daysToRemove, String dateFormat) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)dateFormat);
        DateTime dateTime = DateTime.parse((String)startDate, (DateTimeFormatter)dateTimeFormatter).minusDays(daysToRemove).toDateTime();
        return dateTime.toString(dateTimeFormatter);
    }

    public static String now(String dateFormat) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)dateFormat);
        DateTime dateTime = DateTime.now().toDateTime();
        return dateTime.toString(dateTimeFormatter);
    }

    public static String futureDateAvoidingWeekends(String startDate, int numberOfBusinessDaysToAdd, String dateFormat) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)dateFormat);
        DateTime futureDateTime = DateTime.parse((String)startDate, (DateTimeFormatter)dateTimeFormatter).toDateTime();
        int addedDays = 0;
        while (addedDays < numberOfBusinessDaysToAdd) {
            if ((futureDateTime = futureDateTime.plusDays(1)).getDayOfWeek() == 6 || futureDateTime.getDayOfWeek() == 7) continue;
            ++addedDays;
        }
        return futureDateTime.toString(dateTimeFormatter);
    }

    public static String futureDataAvoidingWeekendsAndBankHolidays(Locale locale, String startDate, int numberOfBusinessDaysToAdd, String dateFormat) throws JsonProcessingException {
        BankHolidays bankHolidays = JsonUtils.fromString(RestAssured.get((String)"https://www.gov.uk/bank-holidays.json", (Object[])new Object[0]).body().asString(), BankHolidays.class);
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)dateFormat);
        DateTime now = DateTime.parse((String)startDate, (DateTimeFormatter)dateTimeFormatter).toDateTime();
        DateTime futureDateTime = DateTime.parse((String)Dates.futureDateAvoidingWeekends(startDate, numberOfBusinessDaysToAdd, dateFormat), (DateTimeFormatter)dateTimeFormatter).toDateTime();
        int bankHolidayCount = 0;
        for (BankHoliday bankHoliday : bankHolidays.get(locale)) {
            if (bankHoliday.getLocalDate().isBefore((ReadablePartial)new LocalDate((Object)now)) || bankHoliday.getLocalDate().isAfter((ReadablePartial)new LocalDate((Object)futureDateTime))) continue;
            ++bankHolidayCount;
        }
        futureDateTime = DateTime.parse((String)Dates.futureDateAvoidingWeekends(futureDateTime.toString(dateTimeFormatter), bankHolidayCount, dateFormat), (DateTimeFormatter)dateTimeFormatter).toDateTime();
        return futureDateTime.toString(dateTimeFormatter);
    }
}

