/*
 * Decompiled with CFR 0.152.
 */
package uk.co.evoco.webdriver.utils;

import java.util.Optional;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;
import uk.co.evoco.webdriver.configuration.TestConfigHelper;
import uk.co.evoco.webdriver.utils.SelectBoxInteractionType;
import uk.co.evoco.webdriver.utils.SendKeysUtils;
import uk.co.evoco.webdriver.utils.TolerantInteraction;

public final class SelectBoxUtils
extends TolerantInteraction {
    public static void itemByHtmlValueAttribute(WebElement selectBox, String htmlValue) {
        Select select = new Select(selectBox);
        select.selectByValue(htmlValue);
    }

    public static void itemByIndex(WebElement selectBox, int index) {
        int normalisedIndex = index - 1;
        Select select = new Select(selectBox);
        select.selectByIndex(normalisedIndex);
    }

    public static void itemByVisibleText(WebElement selectBox, String visibleText) {
        Select select = new Select(selectBox);
        select.selectByVisibleText(visibleText);
    }

    public static void tolerantItemByHtmlValueAttribute(WebElement webElement, String htmlValue, int timeout) throws Throwable {
        new SendKeysUtils().tolerantInteraction(webElement, SelectBoxInteractionType.BY_VALUE, Optional.of(htmlValue), Optional.empty(), timeout);
    }

    public static void tolerantItemByVisibleText(WebElement webElement, String visibleText, int timeout) throws Throwable {
        new SendKeysUtils().tolerantInteraction(webElement, SelectBoxInteractionType.BY_VISIBLE_TEXT, Optional.of(visibleText), Optional.empty(), timeout);
    }

    public static void tolerantItemByIndex(WebElement webElement, int index, int timeout) throws Throwable {
        new SendKeysUtils().tolerantInteraction(webElement, SelectBoxInteractionType.BY_INDEX, Optional.empty(), Optional.of(index), timeout);
    }

    public static void tolerantItemByVisibleText(WebElement webElement, String visibleText) throws Throwable {
        new SendKeysUtils().tolerantInteraction(webElement, SelectBoxInteractionType.BY_VISIBLE_TEXT, Optional.of(visibleText), Optional.empty(), TestConfigHelper.get().getTolerantActionWaitTimeoutInSeconds());
    }

    public static void tolerantItemByIndex(WebElement webElement, int index) throws Throwable {
        new SendKeysUtils().tolerantInteraction(webElement, SelectBoxInteractionType.BY_INDEX, Optional.empty(), Optional.of(index), TestConfigHelper.get().getTolerantActionWaitTimeoutInSeconds());
    }

    public static void tolerantItemByHtmlValueAttribute(WebElement webElement, String htmlValue) throws Throwable {
        new SendKeysUtils().tolerantInteraction(webElement, SelectBoxInteractionType.BY_VALUE, Optional.of(htmlValue), Optional.empty(), TestConfigHelper.get().getTolerantActionWaitTimeoutInSeconds());
    }
}

