/*
 * Decompiled with CFR 0.152.
 */
package uk.co.evoco.webdriver.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import uk.co.evoco.webdriver.configuration.BrowserType;
import uk.co.evoco.webdriver.configuration.GridConfig;
import uk.co.evoco.webdriver.configuration.RunType;
import uk.co.evoco.webdriver.configuration.TolerantActionExceptions;

public class WebDriverConfig {
    private BrowserType browserType;
    private URL baseUrl;
    private long webDriverWaitTimeout;
    private boolean isHeadless;
    private JsonNode testConfig;
    private GridConfig gridConfig;
    private RunType runType;
    private Map<String, ObjectNode> browserPreferences;
    private TolerantActionExceptions tolerantActionExceptions;

    public BrowserType getBrowserType() {
        return this.browserType;
    }

    @JsonProperty(value="browser")
    public void setBrowserType(String browserType) {
        this.browserType = BrowserType.valueOf(browserType.toUpperCase());
    }

    public void setBrowserType(BrowserType browserType) {
        this.browserType = browserType;
    }

    public String getBaseUrl() {
        return this.baseUrl.toString();
    }

    @JsonProperty(value="baseUrl")
    public void setBaseUrl(String baseUrl) throws MalformedURLException {
        String targetBaseUrl = System.getProperty("baseUrl", baseUrl);
        this.baseUrl = new URL(targetBaseUrl);
    }

    public long getWebDriverWaitTimeout() {
        return this.webDriverWaitTimeout;
    }

    @JsonProperty(value="timeout")
    public void setWebDriverWaitTimeout(String webDriverWaitTimeout) {
        this.webDriverWaitTimeout = Long.parseLong(webDriverWaitTimeout);
    }

    public String getTestConfigItem(String item) {
        return this.testConfig.get(item).textValue();
    }

    @JsonProperty(value="testConfig")
    public void setTestConfig(JsonNode testConfig) {
        this.testConfig = testConfig;
    }

    public boolean isHeadless() {
        return this.isHeadless;
    }

    @JsonProperty(value="headless")
    public void setHeadless(boolean headless) {
        this.isHeadless = headless;
    }

    public GridConfig getGridConfig() {
        return this.gridConfig;
    }

    @JsonProperty(value="gridConfig")
    public void setGridConfig(GridConfig gridConfig) {
        this.gridConfig = gridConfig;
    }

    public ObjectNode getBrowserPreferences(BrowserType browserType) {
        return Optional.ofNullable(this.browserPreferences).flatMap(options -> options.entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase(browserType.toString())).findFirst().map(Map.Entry::getValue)).orElse(JsonNodeFactory.instance.objectNode());
    }

    @JsonProperty(value="browserPreferences")
    public void setBrowserPreferences(Map<String, ObjectNode> browserPreferences) {
        this.browserPreferences = browserPreferences;
    }

    public RunType getRunType() {
        return this.runType;
    }

    @JsonProperty(value="runType")
    public void setRunType(String runType) {
        this.runType = RunType.valueOf(runType.toUpperCase());
    }

    public TolerantActionExceptions getTolerantActionExceptions() {
        return this.tolerantActionExceptions;
    }

    @JsonProperty(value="tolerantActionExceptions")
    public void setTolerantActionExceptions(TolerantActionExceptions tolerantActionExceptions) {
        this.tolerantActionExceptions = tolerantActionExceptions;
    }

    public int getTolerantActionWaitTimeoutInSeconds() {
        return Optional.ofNullable(this.tolerantActionExceptions.getWaitTimeoutInSeconds()).map(Integer::parseInt).orElse((int)this.webDriverWaitTimeout);
    }
}

