/*
 * Decompiled with CFR 0.152.
 */
package uk.co.evoco.webdriver;

import java.io.File;
import java.io.IOException;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import uk.co.evoco.webdriver.configuration.TestConfigHelper;
import uk.co.evoco.webdriver.configuration.driver.ConfiguredChromeDriver;
import uk.co.evoco.webdriver.configuration.driver.ConfiguredEdgeDriver;
import uk.co.evoco.webdriver.configuration.driver.ConfiguredFirefoxDriver;
import uk.co.evoco.webdriver.configuration.driver.ConfiguredInternetExplorerDriver;
import uk.co.evoco.webdriver.configuration.driver.ConfiguredSafariDriver;

public class WebDriverBuilder {
    private File screenshotDirectory;

    public WebDriverBuilder setResultsDirectory(File screenshotDirectory) {
        this.screenshotDirectory = screenshotDirectory;
        return this;
    }

    public EventFiringWebDriver build() throws IOException {
        switch (TestConfigHelper.get().getBrowserType()) {
            case CHROME: {
                return new ConfiguredChromeDriver().getDriver(this.screenshotDirectory);
            }
            case FIREFOX: {
                return new ConfiguredFirefoxDriver().getDriver(this.screenshotDirectory);
            }
            case IE: {
                return new ConfiguredInternetExplorerDriver().getDriver(this.screenshotDirectory);
            }
            case EDGE: {
                return new ConfiguredEdgeDriver().getDriver(this.screenshotDirectory);
            }
            case SAFARI: {
                return new ConfiguredSafariDriver().getDriver(this.screenshotDirectory);
            }
        }
        throw new RuntimeException("WebDriverBuilder has no valid target browser set in WebDriverConfig");
    }
}

