/*
 * Decompiled with CFR 0.152.
 */
package uk.co.evoco.webdriver.utils;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.Optional;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;
import uk.co.evoco.metrics.MetricRegistryHelper;
import uk.co.evoco.webdriver.configuration.TestConfigHelper;
import uk.co.evoco.webdriver.utils.SelectBoxInteractionType;
import uk.co.evoco.webdriver.utils.TolerantInteraction;

public final class SelectBoxUtils
extends TolerantInteraction {
    private static final Timer itemByHtmlValueAttributeAction = MetricRegistryHelper.get().timer(MetricRegistry.name((String)"SelectBoxUtils.itemByHtmlValueAttribute", (String[])new String[0]));
    private static final Timer itemByIndexAction = MetricRegistryHelper.get().timer(MetricRegistry.name((String)"SelectBoxUtils.itemByIndex", (String[])new String[0]));
    private static final Timer itemByVisibleTextAction = MetricRegistryHelper.get().timer(MetricRegistry.name((String)"SelectBoxUtils.itemByVisibleText", (String[])new String[0]));
    private static final Timer tolerantItemByHtmlValueAttributeAction = MetricRegistryHelper.get().timer(MetricRegistry.name((String)"SelectBoxUtils.tolerantItemByHtmlValueAttribute", (String[])new String[0]));
    private static final Timer tolerantItemByVisibleTextAction = MetricRegistryHelper.get().timer(MetricRegistry.name((String)"SelectBoxUtils.tolerantItemByVisibleText", (String[])new String[0]));
    private static final Timer tolerantItemByIndexAction = MetricRegistryHelper.get().timer(MetricRegistry.name((String)"SelectBoxUtils.tolerantItemByIndex", (String[])new String[0]));

    public static void itemByHtmlValueAttribute(WebElement selectBox, String htmlValue) {
        try (Timer.Context ignored = itemByHtmlValueAttributeAction.time();){
            Select select = new Select(selectBox);
            select.selectByValue(htmlValue);
        }
    }

    public static void itemByIndex(WebElement selectBox, int index) {
        try (Timer.Context ignored = itemByIndexAction.time();){
            int normalisedIndex = index - 1;
            Select select = new Select(selectBox);
            select.selectByIndex(normalisedIndex);
        }
    }

    public static void itemByVisibleText(WebElement selectBox, String visibleText) {
        try (Timer.Context ignored = itemByVisibleTextAction.time();){
            Select select = new Select(selectBox);
            select.selectByVisibleText(visibleText);
        }
    }

    public static void tolerantItemByHtmlValueAttribute(WebElement webElement, String htmlValue, int timeout) throws Throwable {
        try (Timer.Context ignored = tolerantItemByHtmlValueAttributeAction.time();){
            new SelectBoxUtils().tolerantInteraction(webElement, SelectBoxInteractionType.BY_VALUE, Optional.of(htmlValue), Optional.empty(), timeout);
        }
    }

    public static void tolerantItemByHtmlValueAttribute(WebElement webElement, String htmlValue) throws Throwable {
        try (Timer.Context ignored = tolerantItemByHtmlValueAttributeAction.time();){
            new SelectBoxUtils().tolerantInteraction(webElement, SelectBoxInteractionType.BY_VALUE, Optional.of(htmlValue), Optional.empty(), TestConfigHelper.get().getTolerantActionWaitTimeoutInSeconds());
        }
    }

    public static void tolerantItemByVisibleText(WebElement webElement, String visibleText, int timeout) throws Throwable {
        try (Timer.Context ignored = tolerantItemByVisibleTextAction.time();){
            new SelectBoxUtils().tolerantInteraction(webElement, SelectBoxInteractionType.BY_VISIBLE_TEXT, Optional.of(visibleText), Optional.empty(), timeout);
        }
    }

    public static void tolerantItemByVisibleText(WebElement webElement, String visibleText) throws Throwable {
        try (Timer.Context ignored = tolerantItemByVisibleTextAction.time();){
            new SelectBoxUtils().tolerantInteraction(webElement, SelectBoxInteractionType.BY_VISIBLE_TEXT, Optional.of(visibleText), Optional.empty(), TestConfigHelper.get().getTolerantActionWaitTimeoutInSeconds());
        }
    }

    public static void tolerantItemByVisibleText(WebDriver webDriver, By locator, String visibleText) throws Throwable {
        try (Timer.Context ignored = tolerantItemByVisibleTextAction.time();){
            new SelectBoxUtils().tolerantInteraction(webDriver, locator, SelectBoxInteractionType.BY_VISIBLE_TEXT, Optional.of(visibleText), Optional.empty(), TestConfigHelper.get().getTolerantActionWaitTimeoutInSeconds());
        }
    }

    public static void tolerantItemByIndex(WebElement webElement, int index, int timeout) throws Throwable {
        try (Timer.Context ignored = tolerantItemByIndexAction.time();){
            new SelectBoxUtils().tolerantInteraction(webElement, SelectBoxInteractionType.BY_INDEX, Optional.empty(), Optional.of(index), timeout);
        }
    }

    public static void tolerantItemByIndex(WebElement webElement, int index) throws Throwable {
        try (Timer.Context ignored = tolerantItemByIndexAction.time();){
            new SelectBoxUtils().tolerantInteraction(webElement, SelectBoxInteractionType.BY_INDEX, Optional.empty(), Optional.of(index), TestConfigHelper.get().getTolerantActionWaitTimeoutInSeconds());
        }
    }
}

