/*
 * Decompiled with CFR 0.152.
 */
package uk.co.evoco.webdriver.utils;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ByIdOrName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.evoco.metrics.MetricRegistryHelper;

public final class FindByUtils {
    private static final Logger logger = LoggerFactory.getLogger(FindByUtils.class);
    private static final Timer multipleLocatorMatchGetDisplayedAction = MetricRegistryHelper.get().timer(MetricRegistry.name((String)"FindByUtils.multipleLocatorMatchGetDisplayedAction", (String[])new String[0]));
    private static final Timer byIdOrNameAction = MetricRegistryHelper.get().timer(MetricRegistry.name((String)"FindByUtils.byIdOrName", (String[])new String[0]));

    private FindByUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static WebElement multipleLocatorMatchGetDisplayed(WebDriver webDriver, By locator) throws WebDriverException {
        try (Timer.Context ignored = multipleLocatorMatchGetDisplayedAction.time();){
            List elements = webDriver.findElements(locator);
            logger.info("Found {} elements with locator: {}", (Object)elements.size(), (Object)locator.toString());
            for (WebElement element : elements) {
                if (!element.isDisplayed()) continue;
                WebElement webElement = element;
                return webElement;
            }
            throw new WebDriverException("No elements in the list were displayed");
        }
    }

    public static WebElement byIdOrName(WebDriver webDriver, String idOrName) {
        try (Timer.Context ignored = byIdOrNameAction.time();){
            WebElement webElement = webDriver.findElement((By)new ByIdOrName(idOrName));
            return webElement;
        }
    }
}

