/*
 * Decompiled with CFR 0.152.
 */
package uk.co.evoco.webdriver.utils;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.List;
import org.openqa.selenium.WebElement;
import uk.co.evoco.metrics.MetricRegistryHelper;
import uk.co.evoco.webdriver.configuration.TestConfigHelper;
import uk.co.evoco.webdriver.utils.TolerantInteraction;

public final class RadioButtonUtils
extends TolerantInteraction {
    private static final Timer selectByLabelAction = MetricRegistryHelper.get().timer(MetricRegistry.name((String)"RadioButtonUtils.selectByLabelAction", (String[])new String[0]));
    private static final Timer tolerantSelectByLabelAction = MetricRegistryHelper.get().timer(MetricRegistry.name((String)"RadioButtonUtils.tolerantSelectByLabel", (String[])new String[0]));

    public static void selectByLabel(List<WebElement> webElements, String visibleLabelText) {
        try (Timer.Context ignored = selectByLabelAction.time();){
            for (WebElement webElement : webElements) {
                if (!webElement.getText().equals(visibleLabelText)) continue;
                webElement.click();
                break;
            }
        }
    }

    public static void tolerantSelectByLabel(List<WebElement> webElements, String visibleLabelText, int timeout) throws Throwable {
        try (Timer.Context ignored = tolerantSelectByLabelAction.time();){
            new RadioButtonUtils().tolerantInteraction(webElements, visibleLabelText, timeout);
        }
    }

    public static void tolerantSelectByLabel(List<WebElement> webElements, String visibleLabelText) throws Throwable {
        try (Timer.Context ignored = tolerantSelectByLabelAction.time();){
            new RadioButtonUtils().tolerantInteraction(webElements, visibleLabelText, TestConfigHelper.get().getTolerantActionWaitTimeoutInSeconds());
        }
    }
}

